/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import javax.swing.Box;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.controls.ValuesPropertyPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.panels.partition.TablePartitionPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleTablePartitions;

class PartitionSetByPanel
extends ChildObjectEditorPanel<OracleTablePartitions, Table> {
    private final TablePartitionPanel m_parent;
    private final Component m_glue = Box.createHorizontalGlue();

    PartitionSetByPanel(TablePartitionPanel tablePartitionPanel) {
        super("PartitionSetByPanel", null, true);
        this.m_parent = tablePartitionPanel;
    }

    public String getName() {
        return UIBundle.get("PARTITIONS_SUBTAB_SET_BY");
    }

    @Override
    protected String getPropertyPath() {
        return PartitionProperty.PARTITIONSETS_FOR_TABLE;
    }

    @Override
    public void initialiseComponents() {
        super.initialiseComponents();
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        ComponentWrapper componentWrapper = this.getOrCreateWrapper("partitionType");
        componentWrapper.getLabel().setText(UIBundle.get("PARTITIONSET_TYPE_LABEL"));
        dBUILayoutHelper.add(componentWrapper.getLabel(), 1, 1, false, false);
        dBUILayoutHelper.add(componentWrapper.getComponent(), 1, 1, false, false);
        dBUILayoutHelper.nextRow();
        ComponentWrapper componentWrapper2 = this.getOrCreateWrapper("partitionColumns");
        dBUILayoutHelper.add(componentWrapper2.getLabel(), 1, 1, false, false);
        dBUILayoutHelper.add(componentWrapper2.getComponent(), 1, 1, true, true);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(this.m_glue, 2, 1, true, true);
        dBUILayoutHelper.layout();
        componentWrapper.addListener(propertyChangeEvent -> this.processPartitionSetTypeChange());
        componentWrapper2.addListener(propertyChangeEvent -> this.processPartitionSetColsChange(propertyChangeEvent, "partitionColumns"));
    }

    @Override
    public void initialisePanel() {
        this.enableControls();
    }

    private void processPartitionSetColsChange(PropertyChangeEvent propertyChangeEvent, String string) {
        Object[] objectArray = (Object[])propertyChangeEvent.getNewValue();
        ValuesPropertyPanel.updateTablePartitionMaxValues(objectArray.length, (Table)this.getUpdatedObject(), string.equals("partitionColumns"));
        this.enableControls();
    }

    private void processPartitionSetTypeChange() {
        ComponentWrapper componentWrapper = this.getOrCreateWrapper("partitionColumns");
        componentWrapper.setPropertyValue(new String[0]);
        this.getComponentFactory().processComponents();
        this.enableControls();
    }

    private void enableControls() {
        ComponentWrapper componentWrapper = this.getOrCreateWrapper("partitionColumns");
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
        OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions != null ? oracleTablePartitions.getPartitionSetModel() : null;
        boolean bl = this.hasPartitionTypeSet(oracleTablePartitions2);
        boolean bl2 = bl && this.hasPartitionColumns(oracleTablePartitions2);
        componentWrapper.setEnabled(bl);
        if (!bl) {
            this.m_glue.setVisible(true);
        } else {
            this.m_glue.setVisible(false);
        }
        boolean bl3 = bl && (bl2 || bl && oracleTablePartitions2.getPartitions().length > 0);
        this.m_parent.enablePartitionSetTab(bl3);
    }

    private boolean hasPartitionTypeSet(OracleTablePartitions oracleTablePartitions) {
        boolean bl = false;
        if (oracleTablePartitions != null && oracleTablePartitions.getProperty("partitionType") != null) {
            bl = true;
        }
        return bl;
    }

    private boolean hasPartitionColumns(OracleTablePartitions oracleTablePartitions) {
        boolean bl = false;
        if (oracleTablePartitions != null) {
            DBObjectID[] dBObjectIDArray = (DBObjectID[])oracleTablePartitions.getProperty("partitionColumns");
            bl = dBObjectIDArray != null && dBObjectIDArray.length > 0;
        }
        return bl;
    }
}

