/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ora.OracleTablePartitions;

final class PartitionDescriptionPanel
extends JPanel {
    private final JLabel m_lblPartition = new JLabel();
    private final JLabel m_lblSubPartition = new JLabel();
    private final JCheckBox m_chkDefinePartitions = new JCheckBox();

    PartitionDescriptionPanel() {
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this, true);
        dBUILayoutHelper.add(this.m_lblPartition, 1, 1, false, true);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(this.m_lblSubPartition, 1, 1, false, true);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(this.m_chkDefinePartitions, 1, 1, false, true);
        dBUILayoutHelper.layout();
    }

    void init(OracleTablePartitions oracleTablePartitions, DBUIResourceHelper dBUIResourceHelper) {
        String string = null;
        string = oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE ? DBUtil.getDBObjectName((DBObjectID)oracleTablePartitions.getReferenceConstraintID()) : PartitionDescriptionPanel.getColumnList(oracleTablePartitions.getPartitionColumns());
        if (oracleTablePartitions.getObjectType() != OracleTablePartitions.ObjectType.PARTITIONSET) {
            this.m_lblPartition.setText(UIBundle.format("PARTITIONS_DESC_MAIN", oracleTablePartitions.getPartitionType(), string));
        } else {
            this.m_lblPartition.setText(UIBundle.format("PARTITIONS_DESC_SET", oracleTablePartitions.getPartitionType(), string));
        }
        dBUIResourceHelper.resButton(this.m_chkDefinePartitions, UIBundle.get("PART_OVERRIDE_REF_PARTITIONS"), "CheckDefinePartitions");
        if (oracleTablePartitions.getPartitionType() != OracleTablePartitions.PartitionType.REFERENCE) {
            this.m_chkDefinePartitions.setVisible(false);
        } else {
            this.m_chkDefinePartitions.setVisible(true);
        }
        if (oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE) {
            this.m_lblSubPartition.setVisible(false);
        } else {
            this.m_lblSubPartition.setVisible(true);
            OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions.getObjectType() != OracleTablePartitions.ObjectType.PARTITIONSET ? oracleTablePartitions.getSubpartitionModel() : ((OracleTablePartitions)oracleTablePartitions.getParent()).getSubpartitionModel();
            if (oracleTablePartitions2 != null) {
                this.m_lblSubPartition.setText(UIBundle.format("PARTITIONS_DESC_SUB", oracleTablePartitions2.getPartitionType(), PartitionDescriptionPanel.getColumnList(oracleTablePartitions2.getPartitionColumns())));
            } else {
                this.m_lblSubPartition.setText(UIBundle.get("PARTITIONS_DESC_NO_SUB"));
            }
        }
    }

    public JCheckBox getDefinePartitionsCheckBox() {
        return this.m_chkDefinePartitions;
    }

    private static final String getColumnList(DBObjectID[] dBObjectIDArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (DBObjectID dBObjectID : dBObjectIDArray) {
            stringBuilder.append(DBUtil.getDBObjectName((DBObjectID)dBObjectID));
            stringBuilder.append(", ");
        }
        String string = stringBuilder.toString();
        int n = string.length() - ", ".length();
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }
}

