/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.panels.ChildListEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.partition.GlobalIndexPartitionDetailsPanel;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;

class GlobalIndexPartitionListEditorPanel
extends ChildListEditorPanel<IndexPartition, Index> {
    GlobalIndexPartitionListEditorPanel() {
        super("GlobalIndexPartitionListEditorPanel");
    }

    @Override
    protected String getListLabel() {
        return UIBundle.get("PARTITIONS_LIST_TITLE");
    }

    @Override
    protected ChildObjectEditorPanel<IndexPartition, Index> createChildPanel() {
        return new GlobalIndexPartitionDetailsPanel();
    }

    @Override
    protected Class<IndexPartition> getChildClass() {
        return IndexPartition.class;
    }

    @Override
    protected String getChildProperty() {
        return PartitionProperty.INDEX_PARTITIONS;
    }

    @Override
    protected void removeFromParent(IndexPartition indexPartition) {
        DBObject dBObject = indexPartition.getParent();
        if (dBObject instanceof OracleIndexPartitions) {
            OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)dBObject;
            oracleIndexPartitions.removePartition(indexPartition);
        }
    }

    @Override
    protected DBObjectRenderer createItemRenderer() {
        return new DBObjectRenderer(false){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent(jList, object, n, bl, bl2);
                IndexPartition indexPartition = (IndexPartition)object;
                if (indexPartition != null) {
                    StringBuilder stringBuilder = new StringBuilder(indexPartition.getName());
                    Object[] objectArray = indexPartition.getValuesLessThan();
                    stringBuilder.append(" (");
                    if (objectArray != null && objectArray.length > 0) {
                        for (Object object2 : objectArray) {
                            stringBuilder.append(object2);
                            stringBuilder.append(", ");
                        }
                        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
                    }
                    stringBuilder.append(")");
                    jLabel.setText(stringBuilder.toString());
                }
                return jLabel;
            }
        };
    }
}

