/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.lang.reflect.Array;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.db.controls.SelectableComponent;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.property.MissingPropertyException;

public abstract class ChildTreeEditorPanel<C extends ChildDBObject, P extends DBObject>
extends ChildSelectableComponentEditorPanel<C, P> {
    private JTree m_tree;

    public ChildTreeEditorPanel(String string) {
        super(string);
    }

    protected abstract String[] getChildProperties();

    @Override
    protected final String getChildProperty() {
        return this.getChildProperties()[0];
    }

    @Override
    protected SelectableComponent createSelectableComponent() {
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode(this.getUpdatedObject()));
        this.m_tree = new JTree(defaultTreeModel);
        this.m_tree.setRootVisible(false);
        this.m_tree.setCellRenderer(DBValidationManager.wrapTreeCellRenderer(this.createItemRenderer(), this.getDataContext()));
        this.m_tree.setShowsRootHandles(true);
        return SelectableComponent.createSelectableComponent(this.m_tree);
    }

    protected TreeCellRenderer createItemRenderer() {
        return new DBObjectRenderer();
    }

    @Override
    protected void populateComponent() {
        this.addNode((DefaultMutableTreeNode)this.m_tree.getModel().getRoot(), (DBObject)this.getUpdatedObject(), 0);
    }

    @Override
    protected C[] getChildren() {
        SelectableComponent selectableComponent = this.getSelectableComponent();
        int n = selectableComponent.getSelectedIndex();
        Object t = n < 0 ? this.getUpdatedObject() : (DBObject)selectableComponent.getParent(selectableComponent.get(n));
        Object[] objectArray = selectableComponent.getChildren(t);
        ChildDBObject[] childDBObjectArray = (ChildDBObject[])Array.newInstance(this.getChildClass(), objectArray.length);
        for (int i = 0; i < childDBObjectArray.length; ++i) {
            childDBObjectArray[i] = (ChildDBObject)objectArray[i];
        }
        return childDBObjectArray;
    }

    private void addNode(DefaultMutableTreeNode defaultMutableTreeNode, DBObject dBObject, int n) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        if (n > 0) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(dBObject);
            defaultMutableTreeNode.insert(defaultMutableTreeNode2, defaultMutableTreeNode.getChildCount());
        } else {
            defaultMutableTreeNode2 = defaultMutableTreeNode;
        }
        String[] stringArray = this.getChildProperties();
        if (n < stringArray.length) {
            Object object;
            String string = stringArray[n];
            try {
                object = this.getPropertyHelper().getPropertyValueOrFail((Object)dBObject, stringArray[n]);
            }
            catch (MissingPropertyException missingPropertyException) {
                throw new IllegalStateException("No such property: " + string);
            }
            if (object instanceof DBObject[]) {
                DBObject[] dBObjectArray;
                for (DBObject dBObject2 : dBObjectArray = (DBObject[])object) {
                    this.addNode(defaultMutableTreeNode2, dBObject2, n + 1);
                }
            } else if (object != null) {
                throw new IllegalStateException("Property must be a list of child objects");
            }
        }
    }
}

