/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.lang.reflect.Array;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.controls.SelectableComponent;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;

public abstract class ChildListEditorPanel<C extends ChildDBObject, P extends DBObject>
extends ChildSelectableComponentEditorPanel<C, P> {
    public ChildListEditorPanel() {
        this(null);
    }

    public ChildListEditorPanel(String string) {
        super(string);
    }

    @Override
    protected SelectableComponent createSelectableComponent() {
        final DefaultListModel defaultListModel = new DefaultListModel();
        final JList jList = new JList(defaultListModel);
        jList.setSelectionMode(2);
        jList.setCellRenderer(DBValidationManager.wrapListCellRenderer(this.createItemRenderer(), this.getDataContext()));
        defaultListModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                this.listContentsChangedImpl();
            }

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                this.listContentsChangedImpl();
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                this.listContentsChangedImpl();
            }

            private void listContentsChangedImpl() {
                if (ChildListEditorPanel.this.isEntered()) {
                    jList.setFocusable(defaultListModel.getSize() > 0);
                }
            }
        });
        return SelectableComponent.createSelectableComponent(jList);
    }

    @Override
    protected void populateComponent() {
        List list = this.getChildList();
        for (ChildDBObject childDBObject : list) {
            this.getSelectableComponent().add(childDBObject);
        }
    }

    @Override
    protected C[] getChildren() {
        ChildDBObject[] childDBObjectArray = (ChildDBObject[])Array.newInstance(this.getChildClass(), this.getSelectableComponent().size());
        for (int i = 0; i < childDBObjectArray.length; ++i) {
            childDBObjectArray[i] = (ChildDBObject)this.getSelectableComponent().get(i);
        }
        return childDBObjectArray;
    }

    @Override
    protected ListButtons createListButtons() {
        return new ListButtons(this.getSelectableComponent(), this.createButtonsHelper());
    }

    @Deprecated
    protected final DefaultListModel getChildModel() {
        return (DefaultListModel)((JList)this.getSelectableComponent().getComponent()).getModel();
    }

    @Deprecated
    protected void commitChildList() {
        this.commitChildProperty();
    }

    protected ListCellRenderer createItemRenderer() {
        return new DBObjectRenderer();
    }
}

