/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ideimpl.db.panels.CommentPanel;
import oracle.ideimpl.db.panels.partition.TablePartitionPanel;
import oracle.ideimpl.db.panels.table.ColumnsTableEditorPanel;
import oracle.ideimpl.db.panels.table.ConstraintsPanel;
import oracle.ideimpl.db.panels.table.IndexesPanel;
import oracle.ideimpl.db.panels.table.OracleExternalTablePropertiesPanel;
import oracle.ideimpl.db.panels.table.OracleIOTPropertiesPanel;
import oracle.ideimpl.db.panels.table.SimpleCreateTablePanel;
import oracle.ideimpl.db.panels.table.StoragePanel;
import oracle.ideimpl.db.panels.table.TableInMemoryPanel;
import oracle.ideimpl.db.panels.table.TableInfoPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.property.PropertyManager;

public class TablePanelLibrary
extends PanelLibrary<Table> {
    private static final Dimension DIALOG_SIZE = new Dimension(1200, 800);

    public TablePanelLibrary() {
        this((Map<String, String>)null);
    }

    protected TablePanelLibrary(Map<String, String> map) {
        super("TABLE", map);
        this.initPanels();
    }

    protected void initPanels() {
        this.addPanel(UIBundle.get("COLUMN_INFO_TITLE"), ColumnsTableEditorPanel.class, "f1_odbtacolumns_html", "columns");
        this.addPanel(UIBundle.get("SIMPLETABLE_TITLE"), SimpleCreateTablePanel.class, "f1_odbta_html", "columns");
        this.addPanel(UIBundle.get("COMMENT"), CommentPanel.class, "f1_odbtacomment_html", "Comment");
        this.addPanel(UIBundle.get("CONSTRAINTS_INFO_TITLE"), ConstraintsPanel.class, "f1_odbtapk_html", "constraints");
        this.addPanel(UIBundle.get("INDEX_PANEL_TITLE"), IndexesPanel.class, "f1_odbtaindexes_html", "indexes");
        this.addPanel(UIBundle.get("TABLE_PROPS_PANEL_TITLE"), OracleIOTPropertiesPanel.class, "f1_odbtaprops_html", "OracleIndexOrganizedTableProperties");
        this.addPanel(UIBundle.get("STORAGE_INFO_TITLE"), StoragePanel.class, "f1_odbtastoropts_html", "OracleStorageProperties", "OracleTableProperties");
        this.addPanel(DisplayNames.getPropertyDisplayName((String)"inMemory"), TableInMemoryPanel.class, "f1_odbtainmemory_html", "OracleInMemoryProperties", "OracleInMemoryColumnProperties");
        this.addPanel(UIBundle.get("PARTITIONS_MAIN_TAB"), TablePartitionPanel.class, "f1_odbtapart_html", "OracleTablePartitions");
        this.addPanel(UIBundle.get("EXTTAB_TITLE"), OracleExternalTablePropertiesPanel.class, "f1_odbtaextprops_html", "OracleExternalTableProperties");
    }

    @Override
    public Class<? extends Traversable> getHeader() {
        return TableInfoPanel.class;
    }

    @Override
    protected String getGeneralHelpID() {
        return "f1_offlinedbtageneral_html";
    }

    @Override
    protected String getHeaderHelpID() {
        return "f1_offlinedbtacreate_html";
    }

    @Override
    public boolean canEditObject(Table table, DBObjectProvider dBObjectProvider) {
        return true;
    }

    @Override
    protected List<String> getTitles(Table table, DBObjectProvider dBObjectProvider, boolean bl) {
        ArrayList<String> arrayList = null;
        Table.TableType tableType = (Table.TableType)table.getProperty("TableType", (Object)Table.TableType.NORMAL);
        if (!Boolean.TRUE.equals(table.getProperty("OBJECT TABLE"))) {
            arrayList = new ArrayList<String>();
            arrayList.add(UIBundle.get("COLUMN_INFO_TITLE"));
            arrayList.add(UIBundle.get("CONSTRAINTS_INFO_TITLE"));
            arrayList.add(UIBundle.get("INDEX_PANEL_TITLE"));
            arrayList.add(DisplayNames.getPropertyDisplayName((String)"inMemory"));
            arrayList.add(UIBundle.get("TABLE_PROPS_PANEL_TITLE"));
            arrayList.add(UIBundle.get("EXTTAB_TITLE"));
            arrayList.add(UIBundle.get("STORAGE_INFO_TITLE"));
            if (tableType != Table.TableType.EXTERNAL) {
                boolean bl2;
                boolean bl3 = bl2 = tableType == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP;
                if (!bl2) {
                    TablePanelLibrary.addPartitioningIfSupported(table, dBObjectProvider, bl, arrayList);
                }
            }
            arrayList.add(UIBundle.get("COMMENT"));
        }
        return arrayList;
    }

    @Override
    protected List<String> getSimpleTitles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(UIBundle.get("SIMPLETABLE_TITLE"));
        return arrayList;
    }

    @Override
    public Dimension getSize(boolean bl) {
        return DIALOG_SIZE;
    }

    @Override
    protected Table newDBObject(DBObjectProvider dBObjectProvider, Schema schema, DBObject dBObject) {
        Table table = (Table)super.newDBObject(dBObjectProvider, schema, dBObject);
        if (table.getColumns().length == 0) {
            Column column = (Column)dBObjectProvider.getObjectFactory().newObject(Column.class, (DBObject)table);
            String string = "COLUMN";
            if (dBObjectProvider.getDescriptor().getCasePolicy() == 1) {
                string = string.toLowerCase();
            }
            column.setName(string + "1");
            column.setDataTypeUsage(dBObjectProvider.getDescriptor().createDefaultTypeUsage());
            table.addColumn(column);
        }
        return table;
    }

    @Override
    protected void prepareObjectForNavigable(DBEditorConfig dBEditorConfig, Navigable navigable) throws DBException {
        super.prepareObjectForNavigable(dBEditorConfig, navigable);
        String string = navigable.getShortLabel();
        if ((UIBundle.get("COLUMN_INFO_TITLE").equals(string) || UIBundle.get("SIMPLETABLE_TITLE").equals(string)) && dBEditorConfig.getProvider().getPropertyManager().supportsProperty("TABLE", "constraints")) {
            DBUtil.ensureObjectBuilt((DBObject)dBEditorConfig.getUpdatedObject(), (String[])new String[]{"constraints"});
        }
    }

    static void addPartitioningIfSupported(Table table, DBObjectProvider dBObjectProvider, boolean bl, List<String> list) {
        boolean bl2;
        Table.TableType tableType = (Table.TableType)table.getProperty("TableType", (Object)Table.TableType.NORMAL);
        PropertyManager propertyManager = dBObjectProvider.getPropertyManager();
        boolean bl3 = bl2 = (!bl || tableType != Table.TableType.SHARDED && tableType != Table.TableType.DUPLICATED) && (propertyManager == null || propertyManager.supportsProperty(table.getClass(), "OracleTablePartitions"));
        if (!(!bl2 || bl && dBObjectProvider instanceof Database && table.getProperty("PARTITIONED TABLE") == null)) {
            list.add(UIBundle.get("PARTITIONS_MAIN_TAB"));
        }
    }
}

