/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.model;

import oracle.ide.db.model.ConnectionStoreNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectProviderNode;
import oracle.ide.db.model.DatabaseNode;
import oracle.ideimpl.db.model.ProviderNodeRecognizer;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.util.ModelUtil;

public abstract class DatabaseNodeRecognizer<T>
extends ProviderNodeRecognizer<T> {
    @Override
    public final String getProviderType(T t) {
        String string = this.getConnectionName(t);
        return ModelUtil.hasLength((String)string) ? "db" : null;
    }

    @Override
    public final Object getProviderIdentifier(T t) {
        String string = this.getConnectionName(t);
        return ModelUtil.hasLength((String)string) ? DatabaseFactory.encodeIdentifier((String)this.getStoreName(t), (String)string) : null;
    }

    @Override
    public final boolean isProviderNode(T t) {
        return this.isConnectionNode(t);
    }

    public abstract String getConnectionName(T var1);

    public abstract String getStoreName(T var1);

    public boolean isConnectionNode(T t) {
        return t instanceof DatabaseNode;
    }

    public boolean isStoreNode(T t) {
        return t instanceof ConnectionStoreNode && !(t instanceof DBObjectProviderNode) && !DBObjectNodeUtil.isConnectionNode(t);
    }

    static <T> DatabaseNodeRecognizer<T> createRecognizer(T t) {
        DatabaseNodeRecognizer databaseNodeRecognizer = null;
        if (t != null) {
            if (t instanceof DatabaseNode) {
                databaseNodeRecognizer = new DBNodeRecognizer();
            } else if (t instanceof DBObjectProviderNode) {
                if ("db".equals(((DBObjectProviderNode)t).getProviderType())) {
                    databaseNodeRecognizer = new DBProRecognizer();
                }
            } else if (t instanceof ConnectionStoreNode) {
                databaseNodeRecognizer = new DBStoreNodeRecognizer();
            }
        }
        return databaseNodeRecognizer;
    }

    public static <T> DatabaseNodeRecognizer<T> findRecognizer(T t) {
        ProviderNodeRecognizer<T> providerNodeRecognizer = ProviderNodeRecognizer.findRecognizer(t);
        return providerNodeRecognizer instanceof DatabaseNodeRecognizer ? (DatabaseNodeRecognizer)providerNodeRecognizer : null;
    }

    private static String decode(String string, boolean bl) {
        String string2 = string;
        if (ModelUtil.hasLength((String)string)) {
            String[] stringArray = DatabaseFactory.decodeIdentifier((String)string);
            string2 = bl ? stringArray[0] : stringArray[1];
        }
        return string2;
    }

    private static class DBStoreNodeRecognizer
    extends DatabaseNodeRecognizer<ConnectionStoreNode> {
        private DBStoreNodeRecognizer() {
        }

        @Override
        public String getConnectionName(ConnectionStoreNode connectionStoreNode) {
            return null;
        }

        @Override
        public String getStoreName(ConnectionStoreNode connectionStoreNode) {
            return connectionStoreNode.getStoreName();
        }
    }

    private static class DBProRecognizer
    extends DatabaseNodeRecognizer<DBObjectProviderNode> {
        private DBProRecognizer() {
        }

        @Override
        public String getConnectionName(DBObjectProviderNode dBObjectProviderNode) {
            return DatabaseNodeRecognizer.decode((String)dBObjectProviderNode.getProviderIdentifier(), false);
        }

        @Override
        public String getStoreName(DBObjectProviderNode dBObjectProviderNode) {
            String string = dBObjectProviderNode instanceof ConnectionStoreNode ? ((ConnectionStoreNode)((Object)dBObjectProviderNode)).getStoreName() : DatabaseNodeRecognizer.decode((String)dBObjectProviderNode.getProviderIdentifier(), true);
            return string;
        }
    }

    private static class DBNodeRecognizer
    extends DatabaseNodeRecognizer<DatabaseNode> {
        private DBNodeRecognizer() {
        }

        @Override
        public String getConnectionName(DatabaseNode databaseNode) {
            return databaseNode.getConnectionName();
        }

        @Override
        public String getStoreName(DatabaseNode databaseNode) {
            return databaseNode.getStoreName();
        }
    }
}

