/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.hive.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Table;
import oracle.javatools.db.hive.HiveBucketProperties;
import oracle.javatools.db.property.Property;

public class HiveBucketsPanel
extends BaseEditorPanel<Table> {
    public HiveBucketsPanel() {
        super("HiveBucketsPanel");
    }

    @Override
    protected void initialiseComponents() {
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        ComponentWrapper componentWrapper = this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HiveBucketProperties", "bucketColumns"}));
        componentWrapper.addListener(propertyChangeEvent -> this.columnsChanged(propertyChangeEvent));
        Component component = componentWrapper.getComponent();
        dBUILayoutHelper.add(component, 2, 1, true, this.isInFlatEditor());
        dBUILayoutHelper.nextRowWithGap();
        Component component2 = this.getSortColsWrapper().getComponent();
        dBUILayoutHelper.add(component2, 2, 1, true, true);
        dBUILayoutHelper.nextRowWithGap();
        if (this.isInFlatEditor()) {
            component.setPreferredSize(new Dimension(200, 100));
            component2.setPreferredSize(new Dimension(200, 100));
        }
        dBUILayoutHelper.add(this.getNumberWrapper());
        dBUILayoutHelper.layout();
    }

    private ComponentWrapper getSortColsWrapper() {
        return this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HiveBucketProperties", "bucketSortColumns"}));
    }

    private ComponentWrapper getNumberWrapper() {
        return this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HiveBucketProperties", "numberOfBuckets"}));
    }

    @Override
    protected void initialisePanel() {
        HiveBucketProperties hiveBucketProperties = (HiveBucketProperties)((Table)this.getUpdatedObject()).getProperty("HiveBucketProperties");
        this.checkEnabled(hiveBucketProperties == null ? null : hiveBucketProperties.getBucketColumns());
    }

    private void columnsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.isEntered()) {
            DBObjectID[] dBObjectIDArray = (DBObjectID[])propertyChangeEvent.getNewValue();
            if (dBObjectIDArray == null || dBObjectIDArray.length == 0) {
                this.getSortColsWrapper().resetPropertyValue(null);
                this.getNumberWrapper().resetPropertyValue(null);
            }
            this.checkEnabled(dBObjectIDArray);
        }
    }

    private void checkEnabled(DBObjectID[] dBObjectIDArray) {
        boolean bl = dBObjectIDArray != null && dBObjectIDArray.length != 0;
        this.getSortColsWrapper().setEnabled(bl);
        this.getNumberWrapper().setEnabled(bl);
    }
}

