/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.hive;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.db.panels.MDDEditorPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ideimpl.db.hive.panels.HiveBucketsPanel;
import oracle.ideimpl.db.hive.panels.HiveColumnsPanel;
import oracle.ideimpl.db.hive.panels.HivePartitionsPanel;
import oracle.ideimpl.db.hive.panels.HiveSkewPanel;
import oracle.ideimpl.db.hive.panels.HiveStoragePanel;
import oracle.ideimpl.db.hive.panels.TblPropertiesPanel;
import oracle.ideimpl.db.hive.resource.HiveUIBundle;
import oracle.ideimpl.db.jdbc.JdbcTablePanelLibrary;
import oracle.ideimpl.db.panels.CommentPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.hive.HivePartitionProperties;
import oracle.javatools.db.property.DisplayNames;

public class HiveTablePanelLibrary
extends JdbcTablePanelLibrary {
    @Override
    protected Traversable createMainPanel(Traversable traversable, Navigable[] navigableArray, String string) {
        return new MDDEditorPanel(traversable, navigableArray, string);
    }

    @Override
    protected void initPanels() {
        this.addPanel(UIBundle.get("COLUMN_INFO_TITLE"), HiveColumnsPanel.class, "f1_odbtacolumns_html", "columns");
        this.addPanel(UIBundle.get("STORAGE_INFO_TITLE"), HiveStoragePanel.class, "f1_odbtahivestorprops_html", "HiveStorageProperties");
        this.addPanel(UIBundle.get("PARTITIONS_MAIN_TAB"), HivePartitionsPanel.class, "f1_odbtahivepartitions_html", "HivePartitionProperties");
        this.addPanel(HiveUIBundle.get("BUCKETS"), HiveBucketsPanel.class, "f1_odbtahivebuckets_html", "HiveBucketProperties");
        this.addPanel(HiveUIBundle.get("SKEW"), HiveSkewPanel.class, "f1_odbtahiveskew_html", "HiveSkewProperties");
        this.addPanel(UIBundle.get("COMMENT"), CommentPanel.class, "f1_odbtacomment_html", "Comment");
        this.addPanel(DisplayNames.getPropertyDisplayName((String)"TBLPROPERTIES"), TblPropertiesPanel.class, "f1_odbtahivetblprops_html", "TBLPROPERTIES");
    }

    @Override
    protected List<String> getTitles(Table table, DBObjectProvider dBObjectProvider, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(UIBundle.get("COLUMN_INFO_TITLE"));
        if (!bl || !(dBObjectProvider instanceof Database) || this.hasPartitions(table)) {
            arrayList.add(UIBundle.get("PARTITIONS_MAIN_TAB"));
        }
        arrayList.add(HiveUIBundle.get("BUCKETS"));
        arrayList.add(HiveUIBundle.get("SKEW"));
        arrayList.add(UIBundle.get("STORAGE_INFO_TITLE"));
        arrayList.add(UIBundle.get("COMMENT"));
        arrayList.add(DisplayNames.getPropertyDisplayName((String)"TBLPROPERTIES"));
        return arrayList;
    }

    private boolean hasPartitions(Table table) {
        HivePartitionProperties hivePartitionProperties = (HivePartitionProperties)table.getProperty("HivePartitionProperties");
        return hivePartitionProperties != null && hivePartitionProperties.getPartitionColumns().length > 0;
    }
}

