/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.editors;

import java.awt.Component;
import java.io.IOException;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.db.ProviderOperator;
import oracle.ide.db.dialogs.BaseDBEditorFactory;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.panels.DBTraversable;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.editor.Editor;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.PropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.components.AsynchronousComponentWrapper;
import oracle.ideimpl.db.editors.DBObjectOverviewEditorPanel;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.ui.Header;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class DBObjectOverviewEditor
extends Editor {
    private static final String CURRENT_PAGE_KEY = "db-current-page";
    private final DBObjectListener m_proList = new ReenterListener();
    private final DBObjectListener m_newObjList = new CommitListener();
    private boolean m_updateInProgress;
    private Holder<Boolean> m_commitImmediately;
    private boolean m_reenterInProgress;
    private boolean m_entered;
    private boolean m_shown;
    private boolean m_listening;
    private PanelLibrary m_panelLib;
    private Traversable m_panel;
    private Namespace m_ns = new Namespace();
    private DBObjectNode m_node;
    private IOException m_openError;
    private DBEditorConfig m_editorConfig;
    private DBEditorConfig m_lastEditorConfig;

    public final DBEditorConfig getEditorConfig() {
        return this.m_editorConfig;
    }

    protected final PanelLibrary getPanelLibrary() {
        return this.m_panelLib;
    }

    protected final Namespace getDataContext() {
        return this.m_ns;
    }

    public Object getEditorAttribute(String string) {
        if ("background_color".equals(string)) {
            return UIManager.getColor("window");
        }
        if ("scrollable".equals(string)) {
            return Boolean.FALSE;
        }
        if ("horizontal_scrollbar_policy".equals(string)) {
            return 31;
        }
        if ("vertical_scrollbar_policy".equals(string)) {
            return 21;
        }
        return super.getEditorAttribute(string);
    }

    public Component getGUI() {
        if (this.m_panelLib == null || ModelUtil.areDifferent((Object)this.m_panelLib.getType(), (Object)this.m_node.getObjectType())) {
            this.m_panelLib = DBEditorFactoryRegistry.getEditFactory(this.m_node).getPanelLibrary(this.m_node.getProvider(), this.m_node.getObjectType());
        }
        if (this.m_panelLib != null && this.m_editorConfig != null && this.m_panel == null) {
            this.m_panel = this.createPanel();
            if (this.m_shown) {
                this.enterPanel();
            }
        }
        return this.m_panel == null ? this.getErrorGUI() : this.m_panel.getComponent();
    }

    public HelpInfo getHelpInfo() {
        HelpInfo helpInfo = null;
        if (this.m_panel != null) {
            String string = this.m_panel.getHelpID();
            if (string != null) {
                helpInfo = new HelpInfo(string);
            }
        } else {
            helpInfo = super.getHelpInfo();
        }
        return helpInfo;
    }

    private Component getErrorGUI() {
        JPanel jPanel = new JPanel();
        if (this.m_node != null) {
            DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(jPanel);
            Header header = new Header();
            header.setText(UIBundle.format("CANNOT_OPEN_EDITOR", this.m_node.getObjectName()));
            dBUILayoutHelper.add((Component)header, 1, 1, false, false);
            dBUILayoutHelper.pushLeft();
            IOException iOException = this.m_openError;
            if (iOException != null) {
                dBUILayoutHelper.nextRow();
                dBUILayoutHelper.add(new JLabel(iOException.getMessage()));
            }
            dBUILayoutHelper.pushUp();
            dBUILayoutHelper.layout();
        }
        return jPanel;
    }

    protected Traversable createPanel() {
        return new DBObjectOverviewEditorPanel(this.m_panelLib, this.m_ns);
    }

    public void open() {
        Context context = this.getContext();
        Node node = context.getNode();
        this.m_editorConfig = null;
        this.m_ns = null;
        this.m_openError = null;
        if (node instanceof DBObjectNode) {
            this.m_node = (DBObjectNode)node;
            try {
                node.open();
            }
            catch (IOException iOException) {
                this.m_openError = iOException;
            }
            if (this.m_node.getDBObject() == null) {
                this.m_panel = null;
                Object object = UIBundle.format("CANNOT_OPEN_EDITOR", this.m_node.getObjectName());
                if (this.m_openError != null) {
                    object = (String)object + ": " + this.m_openError.getMessage();
                }
                throw new OpenAbortedException((String)object);
            }
            DBEditorConfig dBEditorConfig = DBEditorConfig.getConfig(context);
            if (dBEditorConfig == null) {
                dBEditorConfig = DBEditorConfig.newEditConfig(this.m_node);
            }
            this.changeEditorConfig(dBEditorConfig);
        }
    }

    public void changeEditorConfig(DBEditorConfig dBEditorConfig) {
        if (this.m_panel != null) {
            this.exitPanel();
        }
        this.m_editorConfig = dBEditorConfig;
        BaseDBEditorFactory.setEditorType(this.m_editorConfig, DBEditorFactory.EditorType.EDIT_FLAT);
        BaseDBEditorFactory baseDBEditorFactory = (BaseDBEditorFactory)DBEditorFactoryRegistry.getEditFactory(this.m_node);
        PanelLibrary panelLibrary = baseDBEditorFactory.getPanelLibrary(this.m_node.getProvider(), this.m_node.getObjectType());
        if (this.m_ns == null) {
            this.m_ns = baseDBEditorFactory.createNamespace(this.m_editorConfig);
        } else {
            this.m_ns.put(DBEditorConfig.class.getName(), (Object)this.m_editorConfig);
        }
        this.m_ns.put(Context.class.getName(), (Object)this.getContext());
        this.m_ns.put(PanelLibrary.class.getName(), (Object)panelLibrary);
        if (this.m_panel != null) {
            if (this.m_panel instanceof DBObjectOverviewEditorPanel) {
                ((DBObjectOverviewEditorPanel)this.m_panel).resetCurrentPage();
            }
            this.enterPanel();
        }
    }

    public void saveSettings(StructuredPropertyAccess structuredPropertyAccess) {
        Navigable navigable;
        super.saveSettings(structuredPropertyAccess);
        if (this.m_panel instanceof DBObjectOverviewEditorPanel && (navigable = ((DBObjectOverviewEditorPanel)this.m_panel).getCurrentNavigable()) != null) {
            structuredPropertyAccess.setProperty(CURRENT_PAGE_KEY, navigable.getShortLabel());
            BaseEditorPanel baseEditorPanel = this.getBaseEditorPanel();
            if (baseEditorPanel != null) {
                baseEditorPanel.saveSettings((PropertyAccess)structuredPropertyAccess);
            }
        }
    }

    public void loadSettings(StructuredPropertyAccess structuredPropertyAccess) {
        super.loadSettings(structuredPropertyAccess);
        String string = structuredPropertyAccess.getProperty(CURRENT_PAGE_KEY, null);
        if (ModelUtil.hasLength((String)string)) {
            this.m_editorConfig.setStartPage(string);
            this.m_ns.put(PropertyAccess.class.getName(), (Object)structuredPropertyAccess);
        }
    }

    public void close() {
        this.exitPanel();
        super.close();
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public void deactivate() {
        super.deactivate();
        this.commitCurrentWrapper();
    }

    public void activate() {
        super.activate();
    }

    public void editorShown() {
        super.editorShown();
        if (!this.m_shown) {
            this.m_shown = true;
            if (this.m_lastEditorConfig != null) {
                this.reenter();
            } else {
                this.enterPanel();
            }
        }
    }

    public void editorHidden() {
        super.editorHidden();
        if (this.m_shown) {
            this.exitPanel();
            this.m_shown = false;
        }
    }

    public void prepareForSaving(boolean bl) {
        super.prepareForSaving(bl);
        if (bl) {
            this.commitCurrentWrapper();
        }
    }

    public Controller getController() {
        return new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                DBObjectOverviewEditor.this.commitCurrentWrapper();
                return DBObjectOverviewEditor.super.getController().handleEvent(ideAction, context);
            }

            public boolean update(IdeAction ideAction, Context context) {
                return DBObjectOverviewEditor.super.getController().update(ideAction, context);
            }
        };
    }

    protected void attachListeners() {
        if (!this.m_listening) {
            this.m_listening = true;
            this.m_editorConfig.getUpdatedObject().addObjectListener(this.m_newObjList);
            this.m_editorConfig.getProvider().addObjectListener(this.m_proList, this.m_editorConfig.getOriginalObject());
        }
    }

    protected void detachListeners() {
        if (this.m_listening) {
            this.m_editorConfig.getUpdatedObject().removeObjectListener(this.m_newObjList);
            this.m_editorConfig.getProvider().removeObjectListener(this.m_proList);
            this.m_listening = false;
        }
    }

    private void enterPanel() {
        if (this.m_panel != null && !this.m_entered) {
            this.prepareForEnter();
            this.m_entered = true;
            this.m_panel.onEntry(new TraversableContext(this.m_ns, 0));
            this.attachListeners();
            if (this.m_editorConfig != this.m_lastEditorConfig) {
                this.m_lastEditorConfig = this.m_editorConfig;
                if (this.m_editorConfig.getProperty() != null && this.m_panel instanceof DBTraversable) {
                    final DBTraversable dBTraversable = (DBTraversable)this.m_panel;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (dBTraversable.getComponent().isVisible()) {
                                dBTraversable.requestFocusForEditorConfig();
                            }
                        }
                    });
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void commitCurrentWrapper() {
        if (this.m_ns == null) return;
        if (this.m_commitImmediately == null) {
            Holder holder;
            this.m_commitImmediately = holder = new Holder((Object)false);
            try {
                AsynchronousComponentWrapper.commitCurrentWrapper(this.m_ns, false, false);
                if (!((Boolean)holder.get()).booleanValue()) return;
                this.commitToProvider();
                return;
            }
            finally {
                this.m_commitImmediately = null;
            }
        } else {
            DBLog.getLogger((Object)((Object)this)).fine("commitCurrentWrapper already in progress");
        }
    }

    private void exitPanel() {
        if (this.m_panel != null && this.m_entered) {
            try {
                this.m_panel.onExit(new TraversableContext(this.m_ns, 0));
                this.m_entered = false;
            }
            catch (TraversalException traversalException) {
                DBLog.getLogger((Object)((Object)this)).severe(traversalException.getMessage());
            }
        }
        this.detachListeners();
    }

    private void reenter() {
        if (this.m_panel != null && !this.isUpdateInProcess()) {
            this.m_reenterInProgress = true;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DBObjectOverviewEditor.this.m_reenterInProgress = false;
                    try {
                        DBObjectOverviewEditor.this.exitPanel();
                        DBObjectOverviewEditor.this.m_editorConfig.getOriginalObject().copyTo((DBObject)DBObjectOverviewEditor.this.m_editorConfig.getUpdatedObject(), true);
                        DBObjectOverviewEditor.this.enterPanel();
                    }
                    catch (Exception exception) {
                        DBLog.getLogger((Object)this).log(Level.SEVERE, "Error re-entering panel", exception);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public final boolean isUpdateInProcess() {
        return this.m_updateInProgress || this.m_reenterInProgress;
    }

    protected void processCommit(DBObjectChange dBObjectChange) {
        Holder<Boolean> holder = this.m_commitImmediately;
        if (holder != null) {
            holder.set((Object)true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DBObjectOverviewEditor.this.commitToProvider();
                }
            });
        }
    }

    protected void prepareForEnter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitToProvider() {
        boolean bl = false;
        this.m_updateInProgress = true;
        try {
            DBEditorConfig dBEditorConfig = this.m_editorConfig;
            if (dBEditorConfig != null) {
                ProviderOperator providerOperator = new ProviderOperator(dBEditorConfig.getProvider(), this.getContext());
                if (providerOperator.updateObjects(dBEditorConfig)) {
                    DBEditorFactory dBEditorFactory = DBEditorFactoryRegistry.getEditFactory(this.m_node);
                    if (dBEditorFactory instanceof BaseDBEditorFactory) {
                        ((BaseDBEditorFactory)dBEditorFactory).commitPerformed(dBEditorConfig, this.m_panelLib);
                    }
                } else {
                    bl = true;
                }
            }
        }
        finally {
            this.m_updateInProgress = false;
        }
        if (bl || this.reenterAfterCommmit()) {
            this.reenter();
        }
    }

    protected boolean reenterAfterCommmit() {
        return false;
    }

    public Component getDefaultFocusComponent() {
        BaseEditorPanel baseEditorPanel = this.getBaseEditorPanel();
        Component component = null;
        if (baseEditorPanel != null) {
            component = baseEditorPanel.getDefaultFocusComponent();
        }
        if (component == null) {
            component = super.getDefaultFocusComponent();
        }
        return component;
    }

    protected BaseEditorPanel getBaseEditorPanel() {
        return this.m_ns == null ? null : (BaseEditorPanel)this.m_ns.get(BaseEditorPanel.class);
    }

    private class ReenterListener
    extends DBObjectListener {
        private ReenterListener() {
        }

        public void objectUpdated(DBObjectChange dBObjectChange) {
            DBObjectOverviewEditor.this.reenter();
        }
    }

    private class CommitListener
    extends DBObjectListener {
        private CommitListener() {
        }

        public void objectUpdated(DBObjectChange dBObjectChange) {
            if (!DBObjectOverviewEditor.this.m_updateInProgress) {
                DBObjectOverviewEditor.this.m_updateInProgress = true;
                DBObjectOverviewEditor.this.processCommit(dBObjectChange);
            }
        }
    }
}

