/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIMnemonicBuilder;
import oracle.ideimpl.db.panels.partition.ExtendedPartitionType;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.util.ModelUtil;

public class ValuesPropertyPanel
extends JPanel {
    private final JLabel m_label = new JLabel();
    private final JTextField m_text = new JTextField();
    private final JCheckBox m_check = new JCheckBox();
    private ExtendedPartitionType m_type = ExtendedPartitionType.UNDEFINED;
    private DBObject m_partition;
    private final Collection<ChangeListener> m_listeners = new ArrayList<ChangeListener>();
    private static final String DEFAULT = "DEFAULT";
    private static final String MAXVALUE = "MAXVALUE";
    private static final String RANGE_OPTION = "RANGE_OPTION";
    private static final String LIST_OPTION = "LIST_OPTION";
    public static final String TEXTBOX_NAME = "PartitionVaues";
    public static final String CHECKBOX_NAME = "ValuesPropertyPanel.defaultCheckbox";

    public ValuesPropertyPanel() {
        this.setName("ValuesPropertyPanel");
        this.m_text.setName(TEXTBOX_NAME);
        this.m_check.setName(CHECKBOX_NAME);
        this.m_label.setLabelFor(this.m_text);
        DBUIMnemonicBuilder.addLabelOption(this.m_label, RANGE_OPTION, UIBundle.get("PARTITIONS_RANGE_VALUE_LABEL"));
        DBUIMnemonicBuilder.addLabelOption(this.m_check, RANGE_OPTION, UIBundle.get("PARTITIONS_RANGE_CHECKBOX"));
        DBUIMnemonicBuilder.addLabelOption(this.m_label, LIST_OPTION, UIBundle.get("PARTITIONS_LIST_VALUE_LABEL"));
        DBUIMnemonicBuilder.addLabelOption(this.m_check, LIST_OPTION, UIBundle.get("PARTITIONS_LIST_CHECKBOX"));
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this);
        dBUILayoutHelper.add(this.m_label, 1, 1, false, false);
        dBUILayoutHelper.add(this.m_text, 1, 1, true, false);
        dBUILayoutHelper.add(this.m_check, 1, 1, false, false);
        dBUILayoutHelper.layout();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValuesPropertyPanel.this.enableTextControl();
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                if (jCheckBox.isSelected()) {
                    if (ValuesPropertyPanel.this.m_type.isList()) {
                        ValuesPropertyPanel.this.m_text.setText(ValuesPropertyPanel.DEFAULT);
                    } else if (ValuesPropertyPanel.this.m_type.isRange()) {
                        ValuesPropertyPanel.this.m_text.setText(ValuesPropertyPanel.this.getValuesAsString(ValuesPropertyPanel.this.getMaxValuesAsArray()));
                    }
                } else {
                    ValuesPropertyPanel.this.m_text.setText(null);
                }
                ValuesPropertyPanel.this.notifyListeners();
            }
        };
        this.m_check.addActionListener(actionListener);
    }

    public void initialisePanel(DBObject dBObject) {
        this.m_partition = dBObject;
        this.m_type = ExtendedPartitionType.getType(dBObject);
        this.setLabelText(this.m_type);
    }

    public Document getDocument() {
        return this.m_text.getDocument();
    }

    public Object getValues() {
        if (this.m_type.isList() && this.m_check.isSelected()) {
            return new Object[]{DEFAULT};
        }
        if (this.m_type.isRange() && this.m_check.isSelected()) {
            return this.getMaxValuesAsArray();
        }
        String string = this.m_text.getText();
        List list = TablePartition.splitValues((String)string);
        Object[] objectArray = new Object[list.size()];
        int n = 0;
        for (String string2 : list) {
            objectArray[n++] = string2.trim();
        }
        return objectArray;
    }

    public void setValues(Object object) {
        if (object instanceof Object[]) {
            String string = this.getValuesAsString((Object[])object);
            if (this.m_type.isList()) {
                this.m_check.setSelected(DEFAULT.equalsIgnoreCase(string));
            } else if (this.m_type.isRange()) {
                this.m_check.setSelected(ModelUtil.hasLength((String)string) && this.getValuesAsString(this.getMaxValuesAsArray()).equalsIgnoreCase(string));
            }
            this.enableTextControl();
            this.m_text.setText(string);
        } else {
            this.m_text.setText(null);
        }
    }

    public void setLabelText(ExtendedPartitionType extendedPartitionType) {
        if (extendedPartitionType.isList()) {
            DBUIMnemonicBuilder.setLabelOption(this.m_label, LIST_OPTION);
            DBUIMnemonicBuilder.setLabelOption(this.m_check, LIST_OPTION);
        } else {
            DBUIMnemonicBuilder.setLabelOption(this.m_label, RANGE_OPTION);
            DBUIMnemonicBuilder.setLabelOption(this.m_check, RANGE_OPTION);
        }
    }

    private void enableTextControl() {
        this.m_text.setEnabled(this.isEnabled() && !this.m_check.isSelected());
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.m_label.setVisible(bl);
        this.m_text.setVisible(bl);
        this.m_check.setVisible(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_label.setEnabled(bl);
        this.m_text.setEnabled(bl);
        this.m_check.setEnabled(bl);
    }

    public Component[] getFocusComponents() {
        return new Component[]{this.m_text, this.m_check};
    }

    public final void addChangeListener(ChangeListener changeListener) {
        this.removeChangeListener(changeListener);
        this.m_listeners.add(changeListener);
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        this.m_listeners.remove(changeListener);
    }

    protected void notifyListeners() {
        for (ChangeListener changeListener : this.m_listeners) {
            changeListener.valuesChanged();
        }
    }

    private Object[] getMaxValuesAsArray() {
        OracleIndexPartitions oracleIndexPartitions;
        int n = 0;
        if (this.m_partition instanceof TablePartition) {
            oracleIndexPartitions = (OracleIndexPartitions)this.m_partition;
            Table table = (Table)DBUtil.findParentOfType((DBObject)oracleIndexPartitions, Table.class);
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
            if (oracleIndexPartitions.getObjectType() != OracleTablePartitions.ObjectType.PARTITION) {
                oracleTablePartitions = oracleTablePartitions.getSubpartitionModel();
            }
            n = oracleTablePartitions != null ? oracleTablePartitions.getPartitionColumns().length : 0;
        } else if (this.m_type == ExtendedPartitionType.INDEX_GLOBAL_RANGE) {
            oracleIndexPartitions = (OracleIndexPartitions)this.m_partition.getParent();
            n = oracleIndexPartitions != null ? oracleIndexPartitions.getGlobalPartitionColumns().length : 0;
        }
        oracleIndexPartitions = new Object[n];
        for (int i = 0; i < n; ++i) {
            oracleIndexPartitions[i] = MAXVALUE;
        }
        return oracleIndexPartitions;
    }

    private String getValuesAsString(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(objectArray[i]);
        }
        return stringBuilder.toString();
    }

    public static void updateIndexPartitionMaxValues(int n, Index index) {
        OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
        if (oracleIndexPartitions != null && oracleIndexPartitions.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
            for (IndexPartition indexPartition : oracleIndexPartitions.getPartitions()) {
                if (!ValuesPropertyPanel.areMaxValues(indexPartition.getValuesLessThan())) continue;
                ValuesPropertyPanel.applyNewMaxValues(n, (DBObject)indexPartition);
            }
        }
    }

    public static void updateTablePartitionMaxValues(int n, Table table, boolean bl) {
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
        if (oracleTablePartitions != null) {
            ValuesPropertyPanel.processMaxValsForTablePartitions(n, oracleTablePartitions.getPartitions(), bl);
        }
    }

    private static void applyNewMaxValues(int n, DBObject dBObject) {
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = MAXVALUE;
        }
        if (dBObject instanceof TablePartition) {
            ((TablePartition)dBObject).setValues(objectArray);
        } else if (dBObject instanceof IndexPartition) {
            ((IndexPartition)dBObject).setValuesLessThan(objectArray);
        }
    }

    private static void processMaxValsForTablePartitions(int n, TablePartition[] tablePartitionArray, boolean bl) {
        for (TablePartition tablePartition : tablePartitionArray) {
            if (bl) {
                OracleTablePartitions oracleTablePartitions = tablePartition.getPartitionLevelSubpartitions();
                if (oracleTablePartitions == null || oracleTablePartitions.getPartitionType() != OracleTablePartitions.PartitionType.RANGE) continue;
                TablePartition[] tablePartitionArray2 = oracleTablePartitions.getPartitions();
                ValuesPropertyPanel.processMaxValsForTablePartitions(n, tablePartitionArray2, false);
                continue;
            }
            if (tablePartition.getPartitionType() != OracleTablePartitions.PartitionType.RANGE || !ValuesPropertyPanel.areMaxValues(tablePartition.getValues())) continue;
            ValuesPropertyPanel.applyNewMaxValues(n, (DBObject)tablePartition);
        }
    }

    private static boolean areMaxValues(Object[] objectArray) {
        boolean bl = objectArray.length > 0;
        for (Object object : objectArray) {
            if (object instanceof String) {
                if (!MAXVALUE.equals(object)) {
                    bl = false;
                }
            } else if (object != TablePartition.RangeValue.MAXVALUE) {
                bl = false;
            }
            if (!bl) break;
        }
        return bl;
    }

    public static interface ChangeListener {
        public void valuesChanged();
    }
}

