/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.controls.DBObjectIDShuttlePanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.event.DBObjectProviderListener;
import oracle.javatools.ui.ResizeComponent;

public abstract class IdArrayWrapper
extends ComponentWrapper<DBObjectIDShuttlePanel> {
    private DBObjectProviderListener m_proListener = null;
    private boolean m_listenerDone = false;

    public IdArrayWrapper(Class<? extends DBObject> clazz, DBObjectFilter dBObjectFilter, boolean bl, Integer n) {
        super(new DBObjectIDShuttlePanel(clazz, dBObjectFilter, bl, n));
    }

    @Override
    protected Component createComponentForLayout() {
        JComponent jComponent = (JComponent)this.getActiveComponent();
        if (this.getComponentContext().isInFlatEditor()) {
            jComponent = new ResizeComponent(jComponent);
        }
        jComponent.putClientProperty("oracle.ideimpl.db.DBUILayoutHelper.SHUTTLE", true);
        return jComponent;
    }

    @Override
    public Component getDefaultFocusComponent() {
        Component component = ((DBObjectIDShuttlePanel)this.getActiveComponent()).getSelectedIDs().length == 0 ? ((DBObjectIDShuttlePanel)this.getActiveComponent()).getFromComponent() : ((DBObjectIDShuttlePanel)this.getActiveComponent()).getToComponent();
        if (component instanceof JScrollPane && !component.isFocusable()) {
            component = ((JScrollPane)component).getViewport().getView();
        }
        return component;
    }

    @Override
    public Object getPropertyValue() {
        return ((DBObjectIDShuttlePanel)this.getActiveComponent()).getSelectedIDs();
    }

    @Override
    protected Component getDefaultValidationComponent() {
        return ((DBObjectIDShuttlePanel)this.getActiveComponent()).getToLabel();
    }

    @Override
    public void setPropertyValue(Object object) {
        DBObjectID[] dBObjectIDArray = new DBObjectID[]{};
        if (object instanceof DBObjectID[]) {
            dBObjectIDArray = (DBObjectID[])object;
        }
        ((DBObjectIDShuttlePanel)this.getActiveComponent()).setSelectedIDs(dBObjectIDArray);
    }

    @Override
    protected void initialiseComponentListener() {
        ((DBObjectIDShuttlePanel)this.getActiveComponent()).addShuttleListener(new ShuttleListener(){

            public void shuttleItemsMoved(ShuttleEvent shuttleEvent) {
                IdArrayWrapper.this.fireChangeEvent();
            }

            public void shuttleItemsRemoved(ShuttleEvent shuttleEvent) {
                IdArrayWrapper.this.fireChangeEvent();
            }

            public void shuttleItemsReordered(ShuttleEvent shuttleEvent) {
                IdArrayWrapper.this.fireChangeEvent();
            }
        });
    }

    @Override
    protected void initialiseComponent() {
        ((DBObjectIDShuttlePanel)this.getActiveComponent()).initialiseIDs(this.getAvailableList());
    }

    protected abstract List<DBObject> getAvailableList();

    @Override
    protected void setActiveImpl(boolean bl) {
        boolean bl2;
        if (bl) {
            if (!this.m_listenerDone) {
                bl2 = true;
                if (this.getComponentContext().isInFlatEditor()) {
                    this.m_proListener = this.createProviderListenerForRefresh();
                }
                this.m_listenerDone = true;
            } else {
                bl2 = this.forceRefreshOnActivate();
            }
        } else {
            bl2 = false;
        }
        if (this.m_proListener != null) {
            this.getProvider().removeProviderListener(this.m_proListener);
            if (bl) {
                this.getProvider().addProviderListener(this.m_proListener);
            }
        }
        if (bl2) {
            this.refreshUI();
        }
    }

    protected boolean forceRefreshOnActivate() {
        return this.getComponentContext().isInFlatEditor();
    }

    protected abstract DBObjectProviderListener createProviderListenerForRefresh();

    protected final void refreshUI() {
        this.refreshUI(this.getAvailableList());
    }

    protected final void refreshUI(final List<DBObject> list) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.isActive()) {
                ((DBObjectIDShuttlePanel)this.getActiveComponent()).initialiseIDs(list, false);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdArrayWrapper.this.refreshUI(list);
                }
            });
        }
    }
}

