/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import javax.swing.JLabel;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.components.DBObjectIDComponentWrapper;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.components.BooleanPropertyComponentWrapper;
import oracle.ideimpl.db.components.DataTypeUsageWrapper;
import oracle.ideimpl.db.components.DatePropertyComponentWrapper;
import oracle.ideimpl.db.components.EnumPropertyComponentWrapper;
import oracle.ideimpl.db.components.ExternalChildIdArrayWrapper;
import oracle.ideimpl.db.components.IndexPartitionTypePropertyWrapper;
import oracle.ideimpl.db.components.InternalChildIdArrayWrapper;
import oracle.ideimpl.db.components.NumberPropertyComponentWrapper;
import oracle.ideimpl.db.components.PartitionTypePropertyWrapper;
import oracle.ideimpl.db.components.SchemaComponentWrapper;
import oracle.ideimpl.db.components.SizableNumberPropertyComponentWrapper;
import oracle.ideimpl.db.components.SystemObjectIdArrayWrapper;
import oracle.ideimpl.db.components.TextPropertyComponentWrapper;
import oracle.ideimpl.db.components.UnlimitedNumberComponentWrapper;
import oracle.ideimpl.db.components.UnlimitedSizableNumberComponentWrapper;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class ComponentFactoryImpl
extends ComponentFactory {
    public ComponentFactoryImpl(String string) {
        super(string);
    }

    public ComponentFactoryImpl(String string, ComponentFactory componentFactory) {
        super(string, componentFactory);
    }

    @Override
    public ComponentWrapper createWrapper(ComponentContext componentContext) {
        String string = Property.getLastProperty((String)componentContext.getPropertyName());
        PropertyInfo propertyInfo = componentContext.getPropertyInfo();
        ComponentWrapper componentWrapper = DatabaseUIExtensionHook.getHook().createComponentWrapper(componentContext);
        if (componentWrapper == null && propertyInfo != null) {
            DBObject dBObject = componentContext.getUpdatedObject();
            Class clazz = propertyInfo.getPropertyClass();
            if (clazz.isArray()) {
                if (clazz.getComponentType() == DBObjectID.class) {
                    if (dBObject instanceof MaterializedViewLog && "columnIDs".equals(string)) {
                        DBObjectFilter dBObjectFilter = new DBObjectFilter(){

                            public boolean accept(DBObject dBObject) {
                                return !ColumnConstraint.isConstrained((Column)((Column)dBObject), (String[])new String[]{"PKConstraint"}) && ((Column)dBObject).getVirtualExpressionSource() == null;
                            }
                        };
                        componentWrapper = new ExternalChildIdArrayWrapper(propertyInfo.getReferencedClass(), dBObjectFilter, null, false, "masterTableID", "columns");
                    } else if (dBObject instanceof Trigger && "columnIDs".equals(string)) {
                        componentWrapper = new ExternalChildIdArrayWrapper(propertyInfo.getReferencedClass(), null, 5, false, "baseObjectID", "columns");
                    } else if (dBObject instanceof LOBDescriptor && "columns".equals(string)) {
                        DBObjectFilter dBObjectFilter = new DBObjectFilter(){

                            public boolean accept(DBObject dBObject) {
                                return LOBDescriptor.isLOBColumn((Column)((Column)dBObject)) || LOBDescriptor.isVARRAYColumn((Column)((Column)dBObject));
                            }
                        };
                        componentWrapper = new InternalChildIdArrayWrapper(Column.class, dBObjectFilter, false);
                    } else if (propertyInfo.isInternalReference()) {
                        componentWrapper = new InternalChildIdArrayWrapper(propertyInfo.getReferencedClass(), null, false);
                    } else if (SystemObject.class.isAssignableFrom(propertyInfo.getReferencedClass())) {
                        DBObjectCriteria dBObjectCriteria = new DBObjectCriteria(propertyInfo.getReferencedClass(), new String[0]);
                        componentWrapper = new SystemObjectIdArrayWrapper((Class<? extends DBObject>)propertyInfo.getReferencedClass(), null, false, dBObjectCriteria);
                    }
                }
            } else if (String.class.isAssignableFrom(clazz) || string.equals("default")) {
                Collection collection = componentContext.getProvider().getPropertyManager().getAllowedPropertyValues(componentContext.getOriginalObject(), dBObject, string);
                componentWrapper = collection != null ? new EnumPropertyComponentWrapper() : TextPropertyComponentWrapper.createTextWrapper(componentContext);
            } else if (Boolean.class.isAssignableFrom(clazz) || clazz.equals(Boolean.TYPE)) {
                componentWrapper = propertyInfo.getNullBehaviour() == Nullable.NullBehaviour.NOT_NULLABLE || propertyInfo.getNullBehaviour() == Nullable.NullBehaviour.NULL_MEANS_FALSE ? new BooleanPropertyComponentWrapper() : new EnumPropertyComponentWrapper();
            } else if (Integer.class.isAssignableFrom(clazz) || clazz.equals(Integer.TYPE)) {
                componentWrapper = propertyInfo.isNumberPhysicalSize() ? new SizableNumberPropertyComponentWrapper() : (propertyInfo.isNumberUnlimited() ? new UnlimitedNumberComponentWrapper(propertyInfo.getNumberUnlimitedValue()) : new NumberPropertyComponentWrapper());
            } else if (BigInteger.class.isAssignableFrom(clazz)) {
                if (propertyInfo.isNumberUnlimited()) {
                    if (propertyInfo.isNumberPhysicalSize()) {
                        componentWrapper = new UnlimitedSizableNumberComponentWrapper();
                    } else {
                        componentWrapper = new UnlimitedNumberComponentWrapper(propertyInfo.getNumberUnlimitedValue());
                        ((UnlimitedNumberComponentWrapper)componentWrapper).setUseBigIntegers(true);
                    }
                } else if (propertyInfo.isNumberPhysicalSize()) {
                    componentWrapper = new SizableNumberPropertyComponentWrapper();
                } else {
                    componentWrapper = new NumberPropertyComponentWrapper();
                    ((NumberPropertyComponentWrapper)componentWrapper).setUseBigIntegers(true);
                }
            } else if (DBObjectID.class.isAssignableFrom(clazz)) {
                componentWrapper = new DBObjectIDComponentWrapper();
            } else if (Enum.class.isAssignableFrom(clazz)) {
                componentWrapper = OracleTablePartitions.PartitionType.class.isAssignableFrom(clazz) ? new PartitionTypePropertyWrapper() : (OracleIndexPartitions.PartitionType.class.isAssignableFrom(clazz) ? new IndexPartitionTypePropertyWrapper() : new EnumPropertyComponentWrapper());
            } else if (Date.class.isAssignableFrom(clazz)) {
                componentWrapper = new DatePropertyComponentWrapper();
            } else if (Schema.class.isAssignableFrom(clazz)) {
                componentWrapper = new SchemaComponentWrapper();
            } else if (DataTypeUsage.class.isAssignableFrom(clazz)) {
                componentWrapper = new DataTypeUsageWrapper();
            } else if (SQLFragment.class.isAssignableFrom(clazz)) {
                componentWrapper = TextPropertyComponentWrapper.createMultiLineSQLTextWrapper(propertyInfo);
            }
        }
        if (componentWrapper == null) {
            throw new IllegalArgumentException("Property \"" + string + "\" not supported by ComponentFactory");
        }
        componentWrapper.initialise(componentContext);
        return componentWrapper;
    }

    @Override
    public void registerComponent(JLabel jLabel, Component component, String string, String string2, String string3) {
        if (ModelUtil.hasLength((String)string3)) {
            Object object;
            DummyComponentWrapper dummyComponentWrapper = new DummyComponentWrapper(component, jLabel);
            if (this.getEditorConfig() == null) {
                object = new Namespace();
                object.put(DBEditorConfig.class.getName(), (Object)DBEditorConfig.newEmptyConfig(null));
                this.setDataContext((Namespace)object);
            }
            object = this.createComponentContext(string3, null, null);
            dummyComponentWrapper.initialise((ComponentContext)object);
            this.registerComponentWrapper(dummyComponentWrapper);
        }
        if (jLabel == null) {
            this.getResourceHelper().setName(component, string2);
        } else {
            this.getResourceHelper().resLabel(jLabel, component, string, string2);
        }
    }

    public void setUpdatedObject(DBObject dBObject) {
        for (ComponentWrapper componentWrapper : this.getComponentWrappers()) {
            if (!(componentWrapper instanceof DummyComponentWrapper)) continue;
            componentWrapper.getComponentContext().setUpdatedObject(dBObject);
        }
    }

    private class DummyComponentWrapper
    extends ComponentWrapper {
        private final JLabel m_label;

        public DummyComponentWrapper(Component component, JLabel jLabel) {
            super(component);
            this.m_label = jLabel;
        }

        @Override
        public Object getPropertyValue() {
            return null;
        }

        @Override
        public void setPropertyValue(Object object) {
        }

        @Override
        protected void initialiseComponentListener() {
        }

        @Override
        protected Component getDefaultValidationComponent() {
            return this.m_label;
        }

        @Override
        public JLabel getLabel() {
            return this.m_label;
        }
    }
}

