/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import oracle.ide.db.components.DBObjectIDComponentWrapper;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnSequenceProcessor;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.plsql.Trigger;

public class ColSeqTriggerComponentWrapper
extends DBObjectIDComponentWrapper {
    @Override
    protected boolean isFixedSchema() {
        return true;
    }

    @Override
    protected void setupObjectChooser(DBObjectChooser dBObjectChooser) {
        super.setupObjectChooser(dBObjectChooser);
        DBObjectFilter dBObjectFilter = new DBObjectFilter(){

            public boolean accept(DBObject dBObject) {
                SystemObject systemObject = ColSeqTriggerComponentWrapper.this.getComponentContext().getUpdatedSystemObject();
                if (dBObject instanceof Trigger) {
                    Trigger trigger = (Trigger)dBObject;
                    if (!systemObject.getID().equals(trigger.getBaseObjectID())) {
                        return false;
                    }
                    if (trigger.isStatementLevel()) {
                        return false;
                    }
                    for (String string : trigger.getEvents()) {
                        if (!"INSERT".equals(string)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
        dBObjectChooser.setFilter(dBObjectFilter);
    }

    @Override
    protected void initialiseNewObject(SystemObject systemObject) {
        Column column = (Column)this.getUpdatedObject();
        Trigger trigger = (Trigger)systemObject;
        String string = this.getProvider().getUniqueName("TRIGGER", (DBObject)trigger.getSchema(), column.getRelation().getName() + "_TRG");
        ColumnSequenceProcessor.initialiseTrigger((Trigger)trigger, (DBObjectProvider)this.getProvider(), (Table)((Table)column.getRelation()), (String)string);
    }

    @Override
    protected boolean isShowAddButton() {
        return true;
    }

    @Override
    protected DBObjectChooser createObjectChooser(DBObjectChooser dBObjectChooser, String ... stringArray) {
        DBObjectProvider dBObjectProvider = this.getProvider();
        Table table = (Table)this.getUpdatedObject().getParent();
        DBObjectLister dBObjectLister = dBObjectProvider.getDescriptor().getTriggerLister(dBObjectProvider);
        DBObjectCriteria dBObjectCriteria = new DBObjectCriteria((SystemObject)table);
        return new DBObjectChooser(dBObjectChooser, dBObjectLister, (DBObjectCriteria<SystemObject>)dBObjectCriteria, stringArray);
    }
}

