/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.awt.Component;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.dialogs.DBUIProgressBar;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.SwingUtils;

public class ProgressBarExecutionWrapper
extends StatementWrapper.ExecutionProxy {
    private LogPage m_page;

    private LogPage getLogPage() {
        if (this.m_page == null && Boolean.getBoolean("ide.db.logpage")) {
            this.m_page = new MessagePage(new ViewId("DatabaseLog", "Database Log"), OracleIcons.getIcon((String)"database.png"), true);
        }
        return this.m_page;
    }

    private boolean isSysPropDisabled() {
        String string = System.getProperty("ide.db.progressBar");
        return string != null && string.equalsIgnoreCase("false");
    }

    private void checkStatementDelay() {
        if (Boolean.getBoolean("ide.db.statementDelay")) {
            try {
                Thread.sleep(6000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public <T> T execute(StatementWrapper.ExecutionRunnable<T> executionRunnable) throws DBException {
        if (SwingUtilities.isEventDispatchThread() && !this.isSysPropDisabled()) {
            if (Boolean.getBoolean("ide.db.progressBarAlert")) {
                DBMessageDialog.showErrorDialog("ProgressBarExecutionWrapper called on.", (Object)this, Level.WARNING);
            }
            Component component = DBMessageDialog.getDialogParent();
            ProgressBar progressBar = new ProgressBar(component, UIBundle.format("EXEC_PB_TITLE", executionRunnable.getName()), null, true);
            R r = new R(executionRunnable, progressBar);
            progressBar.setRunnable((Runnable)r);
            progressBar.setDialogName("Progress Bar:" + DBUtil.createUUID());
            DBUIProgressBar.start(progressBar, "", "");
            if (progressBar.hasUserCancelled()) {
                executionRunnable.cancel();
                StatementWrapper.throwCancelledException();
            }
        } else {
            this.runAndLog(executionRunnable);
        }
        return (T)executionRunnable.getResult();
    }

    private void runAndLog(StatementWrapper.ExecutionRunnable executionRunnable) {
        executionRunnable.run();
        this.checkStatementDelay();
        try {
            LogPage logPage;
            final String string = executionRunnable.getName();
            final String string2 = executionRunnable.getLogText();
            if (string2 != null && (logPage = this.getLogPage()) != null) {
                SwingUtils.dispatch((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        logPage.log((Object)(string + ":\n" + string2.trim() + "\n\n"));
                    }
                });
            }
        }
        catch (Throwable throwable) {
            DBLog.getLogger((Object)((Object)this)).log(Level.SEVERE, throwable.getMessage(), throwable);
        }
    }

    private class R
    implements Runnable {
        private StatementWrapper.ExecutionRunnable m_r;
        private ProgressBar m_pb;

        R(StatementWrapper.ExecutionRunnable executionRunnable, ProgressBar progressBar) {
            this.m_r = executionRunnable;
            this.m_pb = progressBar;
        }

        @Override
        public void run() {
            try {
                ProgressBarExecutionWrapper.this.runAndLog(this.m_r);
            }
            finally {
                this.m_pb.setDoneStatus();
            }
        }
    }
}

