/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql.tester;

import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import oracle.ide.db.panels.sql.tester.MessageTesterComponent;
import oracle.ide.db.panels.sql.tester.TesterPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.sql.InvalidSQLException;
import oracle.javatools.util.Holder;

class TestSQLPanel
extends MessageTesterComponent {
    private final TesterPanel m_tester;
    private final JTextArea m_txtSQL;

    public TestSQLPanel(JTextArea jTextArea, TesterPanel testerPanel) {
        super("TestSQLPanel", UIBundle.get("TESTSQL_MSG_LABEL"));
        this.m_tester = testerPanel;
        this.m_txtSQL = jTextArea;
    }

    @Override
    public String getName() {
        return UIBundle.get("TESTSQL_TEST");
    }

    @Override
    public void testSQL(Database database, String string) {
        this.m_txtSQL.setText(null);
        if (database == null) {
            this.setMessageText(UIBundle.get("TESTSQL_CHOOSE_DB"));
        } else {
            this.runTest(database, string);
        }
    }

    @Override
    protected void doTestSQL(Database database, String string) {
        final Holder holder = new Holder((Object)string);
        final Holder holder2 = new Holder((Object)false);
        final Holder holder3 = new Holder((Object)UIBundle.get("TESTSQL_SUCCESS"));
        final Holder holder4 = new Holder();
        try {
            database.testSQLStatement(string);
            holder2.set((Object)true);
        }
        catch (InvalidSQLException invalidSQLException) {
            holder3.set((Object)invalidSQLException.getMessage());
            holder.set((Object)invalidSQLException.getSQLWithError());
            holder4.set((Object)invalidSQLException.getOffset());
        }
        catch (DBException dBException) {
            holder3.set((Object)dBException.getMessage());
        }
        this.m_tester.setResult((Boolean)holder2.get(), (String)holder3.get(), (Integer)holder4.get());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TestSQLPanel.this.m_tester.enableTabs((Boolean)holder2.get());
                TestSQLPanel.this.setMessageText((String)holder3.get());
                String string = (String)holder.get();
                Integer n = (Integer)holder4.get();
                MessageTesterComponent.setText(TestSQLPanel.this.m_txtSQL, string);
                if (n != null && string != null) {
                    int n2 = TestSQLPanel.this.getWordEnd(string, n);
                    if (n2 == n) {
                        int n3 = string.indexOf("^", (int)n);
                        if (n3 >= 0) {
                            TestSQLPanel.this.m_txtSQL.setCaretPosition(n3);
                        }
                    } else {
                        TestSQLPanel.this.m_txtSQL.setCaretPosition(n);
                        TestSQLPanel.this.m_txtSQL.moveCaretPosition(n2 + 1);
                    }
                    TestSQLPanel.this.m_txtSQL.requestFocusInWindow();
                }
            }
        });
    }

    private int getWordEnd(String string, int n) {
        int n2 = n;
        for (int i = n; i < string.length(); ++i) {
            n2 = i;
            if (Character.isWhitespace(string.charAt(i + 1))) break;
        }
        return n2;
    }
}

