/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.util.ModelUtil;

public class TemplateObjectsPanel
extends DefaultTraversablePanel
implements ListSelectionListener,
ActionListener,
ListCellRenderer {
    public static final String TEMPLATE_SCHEMA = UIBundle.get("TEMPLATE_DEFAULT_SCHEMA_NAME");
    private JLabel m_lblSchemaForTemplates = new JLabel();
    private DBObjectChooser m_schemaForTemplates = new DBObjectChooser("SCHEMA");
    private DefaultListModel m_typeModel = new DefaultListModel();
    private JScrollPane m_scrTypes = new JScrollPane();
    private JList m_typeList = new JList(this.m_typeModel);
    private JLabel m_typeLabel = new JLabel();
    private JComboBox m_typeCombo = new JComboBox();
    private final Map<String, UIHolder> m_UIMap = new HashMap<String, UIHolder>();
    private JCheckBox m_makeDefault = new JCheckBox();
    private HashMap<String, DBObject> m_defaultTemplates = new HashMap();
    private DBObjectProvider m_pro;
    private int m_lastTypeIndex = -1;
    private boolean m_pickOneMode = false;
    private boolean m_initialised = false;
    private DefaultListCellRenderer m_delegateLCR = new DefaultListCellRenderer();
    private DBUIResourceHelper m_resHelper = new DBUIResourceHelper("TemplateObjectsPanel");

    public TemplateObjectsPanel(boolean bl) {
        this.m_pickOneMode = bl;
        this.setLayout(new GridBagLayout());
        this.m_typeList.getSelectionModel().addListSelectionListener(this);
        this.m_typeList.setCellRenderer(this);
        this.m_typeCombo.setRenderer(this);
        this.m_schemaForTemplates.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser dBObjectChooser, DBObjectID dBObjectID) {
                Schema schema = (Schema)dBObjectChooser.getOrCreateDBObject();
                TemplateObjectsPanel.this.m_defaultTemplates.put("SCHEMA", (DBObject)schema);
            }
        });
        this.m_typeCombo.addActionListener(this);
        this.m_resHelper.resLabel(this.m_lblSchemaForTemplates, this.m_schemaForTemplates, UIBundle.get("TEMPLATE_SCHEMA"), "m_templateSchema");
        this.m_resHelper.resLabel(this.m_typeLabel, this.m_typeCombo, UIBundle.get("UDT_PANEL_LABEL_TYPE"), "m_typeCombo");
        this.m_resHelper.resButton(this.m_makeDefault, UIBundle.get("TEMPLATE_OBJECT_MAKE_DEFAULT"), "m_makeDefault");
        this.m_scrTypes.setVerticalScrollBarPolicy(20);
        this.m_typeList.setSelectionMode(0);
        this.m_scrTypes.getViewport().add((Component)this.m_typeList, null);
        if (this.m_pickOneMode) {
            this.add(this.m_typeLabel, this.gbc(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0)));
            this.add(this.m_typeCombo, this.gbc(3, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0)));
        } else {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.add((Component)this.m_lblSchemaForTemplates, this.gbc(1, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0)));
            jPanel.add((Component)this.m_schemaForTemplates, this.gbc(2, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 0, 0)));
            this.add(jPanel, this.gbc(1, 1, 3, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 10, 0)));
            this.add(this.m_scrTypes, this.gbc(1, 2, 1, 4, 0.0, 1.0, 18, 3, new Insets(10, 0, 0, 10)));
        }
        if (this.m_pickOneMode) {
            this.add(this.m_makeDefault, this.gbc(3, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0)));
        }
        this.add(Box.createVerticalGlue(), this.gbc(2, 6, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0)));
    }

    public void init(DBObjectProvider dBObjectProvider, HashMap<String, DBObject> hashMap) {
        if (!this.m_initialised) {
            Schema schema;
            this.m_pro = dBObjectProvider;
            this.m_defaultTemplates = hashMap;
            if (!this.m_pickOneMode || dBObjectProvider instanceof Database) {
                this.m_makeDefault.setVisible(false);
            }
            if (!this.m_pickOneMode && !(dBObjectProvider instanceof Database)) {
                schema = (Schema)this.m_defaultTemplates.get("SCHEMA");
                if (schema == null || schema.getID() == null) {
                    String string = TEMPLATE_SCHEMA;
                    try {
                        schema = this.m_pro.getSchema(string);
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                }
                this.m_schemaForTemplates.setProvider(this.m_pro);
                if (schema != null && schema.getID() != null) {
                    this.m_schemaForTemplates.setDBObject((DBObject)schema);
                }
                this.m_schemaForTemplates.setEditable(true);
                this.m_schemaForTemplates.getDBObjectCriteria().setUserOnly(true);
            }
            schema = new String[hashMap.size()];
            int n = 0;
            for (String string : hashMap.keySet()) {
                schema[n++] = string;
            }
            Arrays.sort((Object[])schema);
            for (Schema schema2 : schema) {
                UIHolder uIHolder = new UIHolder((String)schema2, this.m_pro);
                this.m_UIMap.put((String)schema2, uIHolder);
            }
            this.m_typeCombo.removeActionListener(this);
            for (Schema schema2 : schema) {
                if ("SCHEMA".equals(schema2)) continue;
                this.m_typeModel.addElement(schema2);
                this.m_typeCombo.addItem(schema2);
            }
            this.m_typeCombo.addActionListener(this);
            this.m_typeList.setSelectedIndex(0);
            this.m_lastTypeIndex = 0;
            this.typeChange();
            if (this.m_pickOneMode) {
                this.m_typeCombo.setSelectedItem("TABLE");
            }
            this.m_initialised = true;
        }
    }

    public HashMap<String, DBObject> commit() {
        String string = this.m_schemaForTemplates.getDBObject() == null ? null : this.m_schemaForTemplates.getDBObject().getName();
        Schema schema = null;
        try {
            if (string != null && string.length() > 0 && (schema = this.m_pro.getSchema(string = this.m_pro.getInternalName(string))) == null) {
                schema = new Schema(string);
                this.m_pro.createSchema(schema, false);
            }
        }
        catch (DBException dBException) {
            DBLog.getLogger((Object)this).warning("Couldn't create schema: " + dBException.getMessage());
        }
        this.m_defaultTemplates.put("SCHEMA", (DBObject)schema);
        if (this.m_pickOneMode) {
            String string2 = (String)this.m_typeModel.get(this.m_lastTypeIndex);
            SystemObject systemObject = (SystemObject)this.m_defaultTemplates.get(string2);
            if (!(this.m_pro instanceof Database) && this.m_makeDefault.isSelected()) {
                this.m_pro.setDefaultTemplateForType(string2, (DBObject)systemObject);
            }
            if (systemObject == null) {
                systemObject = (SystemObject)Metadata.getInstance().newInstance(string2);
            }
            this.m_defaultTemplates.clear();
            this.m_defaultTemplates.put(string2, (DBObject)systemObject);
        }
        return this.m_defaultTemplates;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.m_lastTypeIndex = ((ListSelectionModel)listSelectionEvent.getSource()).getMinSelectionIndex();
        this.typeChange();
    }

    private void typeChange() {
        String string3;
        String string2 = (String)this.m_typeModel.get(this.m_lastTypeIndex);
        for (String string3 : this.m_defaultTemplates.keySet()) {
            this.m_UIMap.get(string3).setVisible(false);
        }
        this.m_UIMap.get(string2).setVisible(true);
        Class clazz = Metadata.getInstance().getObjectClass(string2);
        if (SchemaObject.class.isAssignableFrom(clazz)) {
            this.m_lblSchemaForTemplates.setEnabled(true);
            this.m_schemaForTemplates.setEnabled(true);
        } else {
            this.m_lblSchemaForTemplates.setEnabled(false);
            this.m_schemaForTemplates.setEnabled(false);
        }
        string3 = UIBundle.format("TEMPLATE_OBJECT_MAKE_DEFAULT", DBTypeDisplayRegistry.getDisplayName(string2));
        this.m_resHelper.resButton(this.m_makeDefault, string3, "m_makeDefault");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setListeners(false);
        if (actionEvent.getSource() == this.m_typeCombo) {
            this.m_typeList.setSelectedIndex(this.m_typeCombo.getSelectedIndex());
            this.m_lastTypeIndex = this.m_typeCombo.getSelectedIndex();
        }
        this.setListeners(true);
    }

    private void setListeners(boolean bl) {
        if (bl) {
            this.m_typeCombo.addActionListener(this);
        } else {
            this.m_typeCombo.removeActionListener(this);
        }
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        String string = (String)object;
        string = this.m_pickOneMode ? DBTypeDisplayRegistry.getSingularDisplayName(string) : DBTypeDisplayRegistry.getDisplayName(string);
        JLabel jLabel = (JLabel)this.m_delegateLCR.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        jLabel.setIcon(DBTypeDisplayRegistry.getNodeIcon((String)object));
        return jLabel;
    }

    private void addButton(JPanel jPanel, JButton jButton, GridBagConstraints gridBagConstraints, String string, String string2, String string3) {
        this.m_resHelper.setName(jButton, string3);
        jButton.setToolTipText(string);
        if (ModelUtil.hasLength((String)string2)) {
            jButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        }
        IconicButtonUI.install((AbstractButton)jButton);
        jPanel.add((Component)jButton, gridBagConstraints);
    }

    public final void setComponentsEnabledStatus(boolean bl) {
        this.m_lblSchemaForTemplates.setEnabled(bl);
        this.m_schemaForTemplates.setEnabled(bl);
        this.m_scrTypes.setEnabled(bl);
        this.m_typeList.setEnabled(bl);
        this.m_typeLabel.setEnabled(bl);
        this.m_typeCombo.setEnabled(bl);
        this.m_makeDefault.setEnabled(bl);
    }

    private class UIHolder {
        private final String m_type;
        private final JLabel m_schemaLabel;
        private final DBObjectChooser m_schemaChooser;
        private final JLabel m_templateLabel;
        private final DBObjectChooser m_templateChooser;

        UIHolder(final String string, DBObjectProvider dBObjectProvider) {
            this.m_type = string;
            this.m_schemaLabel = new JLabel();
            this.m_templateLabel = new JLabel();
            this.m_schemaChooser = new DBObjectChooser("SCHEMA");
            this.m_schemaChooser.setProvider(dBObjectProvider);
            this.m_schemaChooser.getDBObjectCriteria().setUserOnly(true);
            Class clazz = Metadata.getInstance().getObjectClass(string);
            if (SchemaObject.class.isAssignableFrom(clazz)) {
                this.m_templateChooser = new DBObjectChooser(this.m_schemaChooser, string);
            } else {
                this.m_templateChooser = new DBObjectChooser(string);
                this.m_schemaChooser.setEnabled(false);
                this.m_schemaLabel.setEnabled(false);
            }
            this.m_templateChooser.setProvider(dBObjectProvider);
            this.m_templateChooser.setEditable(false);
            this.m_templateChooser.setNullText(" ");
            this.m_templateChooser.setDBObject(TemplateObjectsPanel.this.m_defaultTemplates.get(string));
            this.m_templateChooser.addChangeListener(new DBObjectChooser.ChangeListener(){

                @Override
                public void chooserChanged(DBObjectChooser dBObjectChooser, DBObjectID dBObjectID) {
                    DBObject dBObject = dBObjectChooser.getDBObject();
                    TemplateObjectsPanel.this.m_defaultTemplates.put(string, dBObject);
                }
            });
            TemplateObjectsPanel.this.m_resHelper.resLabel(this.m_schemaLabel, this.m_schemaChooser, UIBundle.get("LABEL_SCHEMA"), "schema." + string);
            TemplateObjectsPanel.this.m_resHelper.resLabel(this.m_templateLabel, this.m_templateChooser, UIBundle.get("LABEL_NAME"), "template." + string);
            TemplateObjectsPanel.this.add(this.m_schemaLabel, TemplateObjectsPanel.this.gbc(2, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0)));
            TemplateObjectsPanel.this.add(this.m_schemaChooser, TemplateObjectsPanel.this.gbc(3, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0)));
            TemplateObjectsPanel.this.add(this.m_templateLabel, TemplateObjectsPanel.this.gbc(2, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0)));
            TemplateObjectsPanel.this.add(this.m_templateChooser, TemplateObjectsPanel.this.gbc(3, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0)));
            this.setVisible(false);
        }

        void setVisible(boolean bl) {
            this.m_schemaLabel.setVisible(bl);
            this.m_schemaChooser.setVisible(bl);
            this.m_templateLabel.setVisible(bl);
            this.m_templateChooser.setVisible(bl);
            if (bl) {
                this.m_schemaChooser.resetCaches();
                this.m_templateChooser.resetCaches();
                Class clazz = Metadata.getInstance().getObjectClass(this.m_type);
                if (SchemaObject.class.isAssignableFrom(clazz)) {
                    SchemaObject schemaObject = (SchemaObject)TemplateObjectsPanel.this.m_defaultTemplates.get(this.m_type);
                    if (schemaObject != null) {
                        this.m_schemaChooser.setDBObject((DBObject)schemaObject.getSchema());
                        this.m_templateChooser.setDBObject((DBObject)schemaObject);
                    } else {
                        this.m_schemaChooser.setDBObject(null);
                        this.m_templateChooser.setDBObject(null);
                    }
                } else {
                    SystemObject systemObject = (SystemObject)TemplateObjectsPanel.this.m_defaultTemplates.get(this.m_type);
                    this.m_templateChooser.setDBObject((DBObject)systemObject);
                }
            }
        }
    }
}

