/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.controls.DBObjectSourcePicker;
import oracle.ide.db.controls.DBObjectTypePicker;
import oracle.ide.db.controls.NameFilterField;
import oracle.ide.db.controls.SchemaObjectTargetPicker;
import oracle.ide.db.panels.SkippingTraversable;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.NameController;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.DatabaseIdePreferences;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.util.ModelUtil;

public class SelectDBObjectsPanel
extends SkippingTraversable
implements ShuttleListener {
    private static final Collection<String> OBJECT_TYPES_TO_IGNORE = Arrays.asList("SCHEMA", "RECYCLEBIN");
    public static final String SELECTED_OBJECTS = "SelectDBObjectsPanel.SELECTED_OBJECTS";
    public static final String SETTINGS_KEY = SelectDBObjectsPanel.class.getName();
    private static final String SETTINGS_AUTO_QUERY_KEY = "autoQuery";
    private static final String SETTINGS_QUERY_KEY = "query";
    private static final String SETTINGS_FILTER_KEY = "filter";
    private static final String SETTINGS_SCHEMA_KEY = "schema";
    private static final String SETTINGS_CONNECTION_KEY = "connection";
    private WizardCallbacks m_callBacks;
    private boolean m_entered;
    private boolean m_init;
    private boolean m_incDBLinks = true;
    private Schema m_publicSchema;
    private DBObjectProvider m_pro;
    private SchemaObjectTargetPicker m_chosen;
    private DBObjectSourcePicker m_from;
    private Collection<String> m_selectedTypes;
    private Timer m_timer;
    private final Listener m_listener = new Listener();
    private final JPanel m_centerPanel = new JPanel();
    private final JLabel m_filterLabel = new JLabel();
    private final NameFilterField m_filter = new NameFilterField();
    private final JCheckBox m_autoQuery = new JCheckBox();
    private final JLabel m_schemasLabel = new JLabel();
    private final DBObjectChooser m_schemas = new DBObjectChooser("SCHEMA");
    private final JButton m_query = new JButton();
    private final DBUIResourceHelper m_reshelp = new DBUIResourceHelper(this.getPanelName());
    private final Shuttle m_shuttle = new Shuttle();
    private final JLabel m_typeLabel = new JLabel();
    private final JButton m_typeButton = new JButton();
    private final DBObjectTypePicker m_typePicker = new DBObjectTypePicker();

    public SelectDBObjectsPanel() {
        try {
            this.layoutComponents();
            this.addListeners();
        }
        catch (Exception exception) {
            DBLog.getLogger((Object)((Object)this)).log(Level.SEVERE, "Layout failed", exception);
        }
    }

    protected String getPanelName() {
        return "SelectDBObjectsPanel";
    }

    protected void layoutComponents() {
        this.m_centerPanel.setLayout(new GridBagLayout());
        JPanel jPanel = this.getRow1();
        this.m_centerPanel.add((Component)jPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel2 = this.getRow2();
        this.m_centerPanel.add((Component)jPanel2, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_reshelp.setName((Component)this.m_shuttle, "Shuttle");
        this.m_centerPanel.add((Component)this.m_shuttle, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.setLayout(new BorderLayout(5, 5));
        this.add(this.m_centerPanel, "Center");
    }

    private JPanel getRow1() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.m_reshelp.resLabel(this.m_schemasLabel, this.m_schemas, UIBundle.get("PICKER_SCHEMA"), "Schema");
        jPanel.add((Component)this.m_schemasLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel.add((Component)this.m_schemas, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 15), 0, 0));
        jPanel.add((Component)this.m_typeLabel, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_reshelp.resButton(this.m_typeButton, UIBundle.get("PICKER_FILTER_TYPES"), "FilterTypes");
        jPanel.add((Component)this.m_typeButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        return jPanel;
    }

    private JPanel getRow2() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.m_reshelp.resLabel(this.m_filterLabel, this.m_filter, UIBundle.get("PICKER_FILTER"), "Filter");
        jPanel.add((Component)this.m_filterLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_filter.setText("%");
        jPanel.add((Component)this.m_filter, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_reshelp.resButton(this.m_autoQuery, UIBundle.get("PICKER_AUTO_QUERY"), "AutoQuery");
        jPanel.add((Component)this.m_autoQuery, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 5), 0, 0));
        this.m_reshelp.resButton(this.m_query, UIBundle.get("PICKER_QUERY"), "Query");
        jPanel.add((Component)this.m_query, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        return jPanel;
    }

    protected final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected NameController getNameController() {
        return null;
    }

    protected DBObjectSourcePicker getFromPicker() {
        if (this.m_from == null) {
            this.m_from = new DBObjectSourcePicker(this.m_pro, false, true);
        }
        return this.m_from;
    }

    protected ItemPicker getToPicker() {
        if (this.m_chosen == null) {
            NameController nameController = this.getNameController();
            this.m_chosen = new SchemaObjectTargetPicker(nameController);
            if (nameController != null) {
                this.m_shuttle.addShuttleListener((ShuttleListener)this.m_chosen);
            }
        }
        return this.m_chosen;
    }

    protected boolean canFinish() {
        return false;
    }

    protected boolean canAlwaysNext() {
        return false;
    }

    @Deprecated
    protected boolean canRenameObjects() {
        return false;
    }

    protected String[] getAvailableTypes() {
        ItemPicker itemPicker = this.getToPicker();
        if (itemPicker instanceof SchemaObjectTargetPicker) {
            DBObjectProvider dBObjectProvider = this.m_pro;
            DBObjectProvider dBObjectProvider2 = ((SchemaObjectTargetPicker)itemPicker).getProvider();
            if (dBObjectProvider != null) {
                Collection<String> collection;
                Collection<String> collection2 = this.getSelectableObjectTypes(dBObjectProvider);
                if (dBObjectProvider2 == null) {
                    collection = collection2;
                } else {
                    collection = new ArrayList<String>();
                    Collection<String> collection3 = this.getSelectableObjectTypes(dBObjectProvider2);
                    for (String string : collection2) {
                        if (!collection3.contains(string)) continue;
                        collection.add(string);
                    }
                }
                return collection.toArray(new String[collection.size()]);
            }
        }
        return new String[]{"TABLE", "VIEW"};
    }

    protected Collection<String> getSelectableObjectTypes(DBObjectProvider dBObjectProvider) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : dBObjectProvider.listObjectTypes()) {
            if (OBJECT_TYPES_TO_IGNORE.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    protected String getProviderKey() {
        return "oracle.javatools.db.DBObjectProvider";
    }

    @Override
    public final void onEntry(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        this.m_callBacks = traversableContext.getWizardCallbacks();
        if (this.isSkipping()) {
            return;
        }
        boolean bl = false;
        DBObjectProvider dBObjectProvider = this.getProvider(traversableContext);
        if (this.m_pro != dBObjectProvider) {
            bl = true;
        }
        this.m_pro = dBObjectProvider;
        if (this.m_pro != null) {
            ItemPicker itemPicker = this.getToPicker();
            if (itemPicker instanceof Traversable) {
                ((Traversable)itemPicker).onEntry(traversableContext);
            }
            this.init(bl, traversableContext);
            this.entered();
        }
    }

    public final void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this.m_pro != null) {
            ItemPicker itemPicker = this.getToPicker();
            if (itemPicker instanceof Traversable) {
                ((Traversable)itemPicker).onExit(traversableContext);
            }
            this.exited();
            this.commit(traversableContext);
            this.saveSettings();
        }
    }

    private void entered() {
        this.m_entered = true;
    }

    private void exited() {
        this.m_entered = false;
        this.saveSettings();
    }

    protected DBObjectProvider getProvider(TraversableContext traversableContext) {
        return (DBObjectProvider)traversableContext.get(this.getProviderKey());
    }

    protected void commit(TraversableContext traversableContext) throws TraversalException {
        traversableContext.put(SELECTED_OBJECTS, this.getSelectedObjects());
    }

    protected Object getSelectedObjects() {
        Object[] objectArray = null;
        ItemPicker itemPicker = this.getToPicker();
        if (itemPicker instanceof SchemaObjectTargetPicker) {
            ListModel listModel = ((SchemaObjectTargetPicker)itemPicker).getList().getModel();
            int n = listModel.getSize();
            objectArray = new SchemaObjectDescriptor[n];
            for (int i = 0; i < n; ++i) {
                ((SchemaObjectDescriptor[])objectArray)[i] = (SchemaObjectDescriptor)listModel.getElementAt(i);
            }
        } else {
            objectArray = itemPicker.getAllSelectableItems();
        }
        return objectArray;
    }

    protected void setIncludePublicSchema(boolean bl) {
        this.m_publicSchema = bl ? new Schema("PUBLIC") : null;
    }

    public void setIncludeDatabaseLinks(boolean bl) {
        this.m_incDBLinks = bl;
        if (this.m_schemas != null) {
            this.m_schemas.setShowDBLinkButton(bl);
        }
    }

    protected void init(boolean bl, TraversableContext traversableContext) {
        Object object;
        boolean bl2 = bl;
        if (!this.m_init) {
            this.m_init = true;
            bl2 = true;
            this.m_schemas.setShowDBLinkButton(this.m_incDBLinks);
        }
        this.m_typePicker.setAvailableTypes(this.m_pro, true, this.getAvailableTypes());
        this.m_filter.setDescriptor(this.m_pro.getDescriptor());
        this.loadSettings();
        if (bl2) {
            object = (Schema)traversableContext.get("oracle.javatools.db.Schema");
            this.getFromPicker().setProvider(this.m_pro);
            if (object == null) {
                try {
                    object = this.m_pro.getDefaultSchema();
                }
                catch (DBException dBException) {
                    DBLog.getLogger((Object)((Object)this)).warning(UIBundle.format("PICKER_SCHEMA_LOAD_ERR", dBException.getMessage()));
                }
            }
            this.m_schemas.setProvider(this.m_pro);
            this.m_schemas.setDBObject((DBObject)object);
            this.loadSchemaSetting();
            this.selectTypes();
        }
        this.checkWizardButtons();
        object = new JLabel();
        JLabel jLabel = new JLabel();
        DBObjectSourcePicker dBObjectSourcePicker = this.getFromPicker();
        ItemPicker itemPicker = this.getToPicker();
        this.m_shuttle.setFromPicker((ItemPicker)dBObjectSourcePicker);
        this.m_shuttle.setToPicker(itemPicker);
        this.m_reshelp.setName(dBObjectSourcePicker.getComponent(), "From");
        this.m_reshelp.setName(itemPicker.getComponent(), "To");
        this.m_shuttle.add((Component)object, (Object)"FromHeader");
        this.m_shuttle.add((Component)jLabel, (Object)"ToHeader");
        dBObjectSourcePicker.setTitleLabel(UIBundle.get("PICKER_AVAILABLE"), this.getPanelName());
        if (itemPicker.getComponent() instanceof ComponentWithTitlebar) {
            ComponentWithTitlebar componentWithTitlebar = (ComponentWithTitlebar)itemPicker.getComponent();
            this.m_reshelp.resLabel(jLabel, componentWithTitlebar.getComponent(), UIBundle.get("PICKER_SELECTED"), "Selected");
            componentWithTitlebar.setLabel(jLabel);
        }
        if (bl2 && this.m_autoQuery.isSelected()) {
            this.fireQuery();
        }
        if (this.m_callBacks != null) {
            if (this.m_autoQuery.isSelected()) {
                if (!this.getToPicker().isSelectableItemPresent()) {
                    this.m_callBacks.wizardSetInitialFocus((Component)this.getFromPicker().getTree());
                }
            } else {
                this.m_callBacks.wizardSetInitialFocus((Component)this.m_query);
            }
        }
    }

    protected void fireQuery() {
        this.getTimer().stop();
        DBObjectSourcePicker dBObjectSourcePicker = this.getFromPicker();
        if (dBObjectSourcePicker != null && this.m_selectedTypes != null) {
            Schema schema = (Schema)this.m_schemas.getDBObject();
            String string = this.m_filter.getFilter();
            String[] stringArray = this.m_selectedTypes.toArray(new String[this.m_selectedTypes.size()]);
            this.setupQuery(dBObjectSourcePicker, schema, string, stringArray);
            this.getTimer().stop();
            dBObjectSourcePicker.query();
            this.m_shuttle.setEnabled(true);
        }
    }

    protected void setupQuery(DBObjectSourcePicker dBObjectSourcePicker, Schema schema, String string, String[] stringArray) {
        dBObjectSourcePicker.setSchema(schema);
        dBObjectSourcePicker.setTypes(stringArray);
        dBObjectSourcePicker.setFilter(string);
    }

    private void selectTypes() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.stripMnemonic((String)UIBundle.get("PICKER_TYPES")));
        this.m_selectedTypes = this.m_typePicker.getSelectedTypes();
        for (String string : this.m_selectedTypes) {
            stringBuilder.append(" ");
            stringBuilder.append(DBTypeDisplayRegistry.getDisplayName(string));
        }
        DBObjectRenderer.setToolTipText(this.m_typeButton, stringBuilder.toString());
        if (this.m_selectedTypes.equals(this.m_typePicker.getDefaultSelection())) {
            this.m_typeLabel.setText(UIBundle.get("PICKER_TYPEFILTER_OFF"));
        } else {
            this.m_typeLabel.setText(UIBundle.get("PICKER_TYPEFILTER_ON"));
        }
    }

    private Timer getTimer() {
        if (this.m_timer == null) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SelectDBObjectsPanel.this.fireQuery();
                }
            };
            this.m_timer = new Timer(2000, actionListener);
            this.m_timer.setRepeats(false);
        }
        return this.m_timer;
    }

    protected String getSettingsKey() {
        return SETTINGS_KEY;
    }

    protected PropertyStorage getPropertyStorage() {
        return DatabaseIdePreferences.getPreferences();
    }

    protected void loadSettings() {
        HashStructure hashStructure = this.getSettings();
        if (hashStructure != null) {
            boolean bl = hashStructure.getBoolean(SETTINGS_AUTO_QUERY_KEY, false);
            this.m_autoQuery.setSelected(bl);
            this.m_query.setEnabled(!bl);
            ArrayList<String> arrayList = new ArrayList<String>();
            Collection<String> collection = this.m_typePicker.getAvailableTypes();
            for (String string : collection) {
                if (!hashStructure.getBoolean(SETTINGS_QUERY_KEY + string, true)) continue;
                arrayList.add(string);
            }
            this.m_typePicker.setSelectedTypes(arrayList.isEmpty() ? collection : arrayList);
            if (this.useSavedFilterAndSchema()) {
                this.m_filter.setFilter(hashStructure.getString(SETTINGS_FILTER_KEY));
            }
        } else {
            this.setDefaultSettings();
        }
    }

    private void loadSchemaSetting() {
        HashStructure hashStructure = this.getSettings();
        if (hashStructure != null) {
            String string;
            String string2 = this.getConnectionName();
            if (this.useSavedFilterAndSchema() && ModelUtil.hasLength((String)(string = hashStructure.getString(SETTINGS_SCHEMA_KEY)))) {
                try {
                    Schema schema = this.m_pro.getSchema(string);
                    this.m_schemas.setDBObject((DBObject)schema);
                }
                catch (DBException dBException) {
                    DBLog.getLogger((Object)((Object)this)).warning(UIBundle.format("PICKER_SCHEMA_LOAD_ERR", dBException.getMessage()));
                }
            }
        }
    }

    private boolean useSavedFilterAndSchema() {
        String string;
        String string2;
        HashStructure hashStructure = this.getSettings();
        return hashStructure != null && ModelUtil.hasLength((String)(string2 = this.getConnectionName())) && string2.equals(hashStructure.getString(SETTINGS_CONNECTION_KEY)) && ModelUtil.hasLength((String)(string = this.getUserName())) && string.equals(hashStructure.getString(SETTINGS_SCHEMA_KEY));
    }

    private HashStructure getSettings() {
        String string = this.getSettingsKey();
        HashStructure hashStructure = null;
        if (string != null) {
            PropertyStorage propertyStorage = this.getPropertyStorage();
            hashStructure = propertyStorage.getProperties().getHashStructure(string);
        }
        return hashStructure;
    }

    protected void setDefaultSettings() {
        boolean bl = !(this.m_pro instanceof Database);
        this.m_autoQuery.setSelected(bl);
        this.m_query.setEnabled(!bl);
        Collection<String> collection = DatabaseUIExtensionHook.getHook().getDefaultObjectTypeFilter();
        if (collection != null) {
            this.m_typePicker.setSelectedTypes(collection);
        }
    }

    protected void saveSettings() {
        String string = this.getSettingsKey();
        if (string != null) {
            PropertyStorage propertyStorage = this.getPropertyStorage();
            HashStructure hashStructure = propertyStorage.getProperties().getOrCreateHashStructure(string);
            hashStructure.putBoolean(SETTINGS_AUTO_QUERY_KEY, this.m_autoQuery.isSelected());
            Collection<String> collection = this.m_typePicker.getSelectedTypes();
            if (collection.equals(this.m_typePicker.getDefaultSelection())) {
                collection = null;
            }
            for (String string2 : this.m_typePicker.getAvailableTypes()) {
                String string3 = SETTINGS_QUERY_KEY + string2;
                if (collection == null || collection.contains(string2)) {
                    hashStructure.remove(string3);
                    continue;
                }
                hashStructure.putBoolean(string3, false);
            }
            hashStructure.putString(SETTINGS_CONNECTION_KEY, this.getConnectionName());
            hashStructure.putString(SETTINGS_FILTER_KEY, this.m_filter.getFilter());
            Schema schema = (Schema)this.m_schemas.getDBObject();
            if (schema != null) {
                hashStructure.putString(SETTINGS_SCHEMA_KEY, schema.getName());
            }
        }
    }

    private String getConnectionName() {
        String string = null;
        if (this.m_pro instanceof Database) {
            string = ((Database)this.m_pro).getConnectionName();
        }
        return string;
    }

    private String getUserName() {
        String string = null;
        if (this.m_pro instanceof Database) {
            try {
                string = ((Database)this.m_pro).getUserName();
            }
            catch (DBException dBException) {
                DBLog.getLogger((Object)((Object)this)).warning(UIBundle.format("PICKER_SCHEMA_LOAD_ERR", dBException.getMessage()));
            }
        }
        return string;
    }

    protected void checkWizardButtons() {
        ItemPicker itemPicker;
        if (this.m_callBacks != null && (itemPicker = this.getToPicker()) != null) {
            Boolean bl;
            Transferable[] transferableArray = itemPicker.getAllSelectableItems();
            boolean bl2 = transferableArray != null && transferableArray.length > 0;
            Boolean bl3 = bl = this.canFinish() && bl2 ? Boolean.TRUE : Boolean.FALSE;
            Boolean bl4 = this.canAlwaysNext() ? Boolean.TRUE : (bl2 ? Boolean.TRUE : Boolean.FALSE);
            this.m_callBacks.wizardEnableButtons(null, bl4, bl);
        }
    }

    private void showFilterTypesDialog() {
        if (this.m_typePicker.showFilterTypesDialog(this.m_typeButton)) {
            this.selectTypes();
            if (this.m_autoQuery.isSelected()) {
                this.fireQuery();
            }
        }
    }

    @Override
    protected String getTraversableName() {
        return null;
    }

    public final Shuttle getShuttle() {
        return this.m_shuttle;
    }

    protected final WizardCallbacks getWizardCallbacks() {
        return this.m_callBacks;
    }

    public void shuttleItemsMoved(ShuttleEvent shuttleEvent) {
        this.checkWizardButtons();
    }

    public void shuttleItemsRemoved(ShuttleEvent shuttleEvent) {
        this.checkWizardButtons();
    }

    public void shuttleItemsReordered(ShuttleEvent shuttleEvent) {
    }

    private void addListeners() {
        this.m_shuttle.addShuttleListener((ShuttleListener)this);
        this.m_schemas.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser dBObjectChooser, DBObjectID dBObjectID) {
                if (SelectDBObjectsPanel.this.m_autoQuery.isSelected()) {
                    SelectDBObjectsPanel.this.fireQuery();
                }
            }
        });
        this.m_typeButton.addActionListener(this.m_listener);
        this.m_filter.getDocument().addDocumentListener(this.m_listener);
        this.m_filter.addKeyListener(this.m_listener);
        this.m_autoQuery.addItemListener(this.m_listener);
        this.m_query.addActionListener(this.m_listener);
    }

    private class Listener
    implements ActionListener,
    ItemListener,
    DocumentListener,
    KeyListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SelectDBObjectsPanel.this.m_entered) {
                Object object = actionEvent.getSource();
                if (object == SelectDBObjectsPanel.this.m_query) {
                    SelectDBObjectsPanel.this.fireQuery();
                } else if (object == SelectDBObjectsPanel.this.m_typeButton) {
                    SelectDBObjectsPanel.this.showFilterTypesDialog();
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object;
            if (SelectDBObjectsPanel.this.m_entered && (object = itemEvent.getSource()) == SelectDBObjectsPanel.this.m_autoQuery) {
                switch (itemEvent.getStateChange()) {
                    case 1: {
                        SelectDBObjectsPanel.this.m_query.setEnabled(false);
                        SelectDBObjectsPanel.this.getTimer().restart();
                        break;
                    }
                    case 2: {
                        SelectDBObjectsPanel.this.m_query.setEnabled(true);
                    }
                }
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (SelectDBObjectsPanel.this.m_entered && SelectDBObjectsPanel.this.m_autoQuery.isSelected()) {
                SelectDBObjectsPanel.this.getTimer().restart();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (SelectDBObjectsPanel.this.m_entered && SelectDBObjectsPanel.this.m_autoQuery.isSelected()) {
                SelectDBObjectsPanel.this.getTimer().restart();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            if (SelectDBObjectsPanel.this.m_entered && SelectDBObjectsPanel.this.m_autoQuery.isSelected()) {
                SelectDBObjectsPanel.this.getTimer().restart();
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                SelectDBObjectsPanel.this.fireQuery();
                keyEvent.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

