/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.model;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.model.BaseDBObjectNode;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFactory;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public abstract class BaseDBObjectTextNode
extends TextNode
implements DBObjectNode {
    private SourceObject m_bufferObject;
    private SourceObject m_tempObject;
    private boolean m_tempSaved;
    private int m_lastChangeId;
    private Reference<BaseDBObjectTextNode> m_companionNode;

    @Override
    public String getProviderType() {
        return "db";
    }

    @Override
    public DBObject getDBObject() {
        return this.findProviderDBObject();
    }

    @Override
    public DBObjectProvider getProvider() {
        return BaseDBObjectNode.findProvider(this);
    }

    public Icon getIcon() {
        Icon icon = DBTypeDisplayRegistry.getNodeIcon(DBObjectNodeUtil.normalizeType(this));
        if (icon != null) {
            return icon;
        }
        return super.getIcon();
    }

    public String getShortLabel() {
        String string = this.getObjectName();
        if (ModelUtil.hasLength((String)string)) {
            return string;
        }
        return super.getShortLabel();
    }

    public int getLine(int n) {
        LineMap lineMap;
        int n2 = 0;
        TextBuffer textBuffer = this.acquireTextBuffer();
        LineMap lineMap2 = lineMap = textBuffer == null ? null : textBuffer.getLineMap();
        if (lineMap != null) {
            n2 = lineMap.getLineFromOffset(n) + 1;
        }
        return n2;
    }

    protected void openImpl() throws IOException {
        TextBuffer textBuffer;
        super.openImpl();
        if (!"db".equals(this.getProviderType()) && (textBuffer = this.tryAcquireTextBuffer()) != null) {
            try {
                this.m_lastChangeId = textBuffer.getChangeId();
            }
            finally {
                this.releaseTextBuffer();
            }
        }
    }

    @Deprecated
    public final SourceObject getDBObject(boolean bl) {
        return this.getDBObjectFromBuffer();
    }

    public final SourceObject getDBObjectFromBuffer() {
        Holder holder = new Holder();
        this.runUnderWriteLock(() -> holder.set((Object)this.getDBObjectFromBufferImpl()));
        return (SourceObject)holder.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceObject getDBObjectFromBufferImpl() {
        Object object;
        DBObjectProvider dBObjectProvider = this.getProvider();
        String string = this.getObjectType();
        if (string != null && dBObjectProvider != null) {
            object = this.m_tempObject == null || this.m_tempSaved ? this.getDBObject() : null;
            if (object == null) {
                this.m_bufferObject = this.getTempObject();
            } else if (object instanceof SourceObject) {
                this.m_bufferObject = (SourceObject)object;
                this.m_tempObject = null;
            } else {
                this.m_bufferObject = null;
            }
        } else {
            this.m_bufferObject = null;
        }
        if (this.m_bufferObject != null && (object = this.tryAcquireTextBuffer()) != null) {
            try {
                int n;
                if (this.isOpen() && (n = object.getChangeId()) != this.m_lastChangeId) {
                    String string2 = object.getString(0, object.getLength());
                    this.updateSource(this.m_bufferObject, string2);
                    this.m_lastChangeId = n;
                }
            }
            finally {
                this.releaseTextBuffer();
            }
        }
        return this.m_bufferObject;
    }

    @Deprecated
    public final void cancelCurrentBuild() {
    }

    protected SourceObject findProviderDBObject() {
        return (SourceObject)BaseDBObjectNode.findDBObject(this);
    }

    protected void updateSource(SourceObject sourceObject, String string) {
        sourceObject.setSource(string);
    }

    private SourceObject getTempObject() {
        if (this.m_tempObject == null) {
            String string = this.getObjectType();
            Class clazz = Metadata.getInstance().getObjectClass(string);
            if (clazz != null && SourceObject.class.isAssignableFrom(clazz)) {
                DBObjectProvider dBObjectProvider = this.getProvider();
                DBObjectFactory dBObjectFactory = dBObjectProvider.getObjectFactory();
                this.m_tempObject = (SourceObject)dBObjectFactory.newObject(clazz, (DBObject)new Schema(this.getSchemaName()), this.getObjectName(), false, false);
                this.m_tempObject.setID(TemporaryObjectID.createID((DBObject)this.m_tempObject));
                this.addNodeListener(new NodeListener(){

                    public void nodeClosed(NodeEvent nodeEvent) {
                        NodeFactory.uncache((URL)BaseDBObjectTextNode.this.getURL());
                        BaseDBObjectTextNode.this.removeNodeListener(this);
                    }

                    public void nodeSaved(NodeEvent nodeEvent) {
                        BaseDBObjectTextNode.this.removeNodeListener(this);
                        BaseDBObjectTextNode.this.m_tempSaved = true;
                    }
                });
            }
        }
        return this.m_tempObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetBuffer(SourceObject sourceObject) {
        if (this.isOpen()) {
            TextBuffer textBuffer = this.acquireTextBuffer();
            try {
                textBuffer.writeLock();
                try {
                    textBuffer.beginEdit();
                    try {
                        textBuffer.removeToEnd(0);
                        String string = sourceObject.getSource();
                        if (string != null) {
                            textBuffer.append(string.toCharArray());
                        }
                        this.m_lastChangeId = textBuffer.getChangeId();
                    }
                    finally {
                        textBuffer.endEdit();
                    }
                }
                finally {
                    textBuffer.writeUnlock();
                }
            }
            finally {
                this.releaseTextBuffer();
            }
        }
    }

    void setCompanionNode(BaseDBObjectTextNode baseDBObjectTextNode) {
        this.m_companionNode = baseDBObjectTextNode == null ? null : new WeakReference<BaseDBObjectTextNode>(baseDBObjectTextNode);
    }

    BaseDBObjectTextNode getCompanionNode() {
        BaseDBObjectTextNode baseDBObjectTextNode = null;
        Reference<BaseDBObjectTextNode> reference = this.m_companionNode;
        if (reference != null) {
            baseDBObjectTextNode = reference.get();
        }
        return baseDBObjectTextNode;
    }
}

