/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.insight.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.ide.db.insight.model.ColumnInsightDataProvider;
import oracle.ide.db.insight.model.DBInsightContext;
import oracle.ide.db.insight.model.DBInsightData;
import oracle.ide.db.insight.model.DataTypeProvider;
import oracle.ide.db.insight.model.DeclarativeSQLQueryParentLocator;
import oracle.ide.db.insight.model.FunctionProvider;
import oracle.ide.db.insight.model.InsightDataProvider;
import oracle.ide.db.insight.model.ParentLocator;
import oracle.ide.db.insight.model.PlSqlInsightDataProvider;
import oracle.ide.db.insight.model.ReservedWordInsightDataProvider;
import oracle.ide.db.insight.model.SQLFromObjectProvider;
import oracle.ide.db.insight.model.SQLParentLocator;
import oracle.ide.db.insight.model.SchemaObjectInsightDataProvider;
import oracle.ide.db.insight.model.SchemaProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlDatum;
import oracle.javatools.db.plsql.PlSqlIdentifier;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.PlSqlVariable;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.token.Token;

public final class DBInsightProvider {
    private final DBInsightContext m_insightContext;
    private final Class<? extends ParentLocator> m_parentLocatorClass;
    private final List<Class<? extends InsightDataProvider>> m_insightDataProviderClasses;
    private Map<String, DBInsightData> m_data;
    private Boolean m_makeLower;
    private String m_searchString;
    private int m_replacementStart;
    private int m_replacementEnd;
    private DBObjectProvider m_pro;
    private String m_text;
    private Schema m_schema;
    private Integer m_offset;
    private Class<? extends DBObject> m_targetObjectClass;
    private Class<? extends DBObject> m_parentScopeClass;
    private DBObject m_contextObjectAtOffset;
    private String m_language;
    private boolean m_userOnly;

    public DBInsightProvider(DBInsightContext dBInsightContext) throws CancelledException {
        this(dBInsightContext, null, null);
    }

    public DBInsightProvider(DBInsightContext dBInsightContext, Class<? extends ParentLocator> clazz, List<Class<? extends InsightDataProvider>> list) throws CancelledException {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Cannot request insight on EDT");
        }
        if (dBInsightContext == null) {
            throw new IllegalArgumentException("No context");
        }
        if (dBInsightContext.getProvider() == null) {
            throw new IllegalArgumentException("No DBObjectProvider in the context");
        }
        if (dBInsightContext.getText() == null) {
            throw new IllegalArgumentException("No text in the context");
        }
        this.m_insightContext = dBInsightContext;
        this.m_parentLocatorClass = clazz;
        this.m_insightDataProviderClasses = list;
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void init() throws CancelledException {
        boolean bl;
        Object object;
        Object object2;
        InsightDataProvider insightDataProvider;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object8;
        PlSqlParser plSqlParser;
        PlSqlSourceObject plSqlSourceObject;
        Object object9;
        String string;
        PlSqlToken plSqlToken;
        Integer n;
        Integer n2;
        Object object10;
        Boolean bl2;
        this.m_data = new HashMap<String, DBInsightData>();
        this.m_pro = this.m_insightContext.getProvider();
        this.m_targetObjectClass = this.m_insightContext.getTargetObjectClass();
        this.m_parentScopeClass = this.m_insightContext.getParentScopeClass();
        this.m_language = this.m_insightContext.getLanguage();
        if (this.m_language == null) {
            this.m_language = "SQL";
        }
        this.m_userOnly = (bl2 = this.m_insightContext.getUserOnly()) == null ? this.m_pro instanceof Database : bl2;
        this.m_searchString = "";
        if (this.m_insightContext.getSchema() != null) {
            this.m_schema = this.m_insightContext.getSchema();
        } else {
            object10 = null;
            try {
                object10 = this.m_pro.getDefaultSchema();
            }
            catch (CancelledException cancelledException) {
                throw cancelledException;
            }
            catch (DBException dBException) {
                object10 = null;
            }
            this.m_schema = object10;
        }
        object10 = this.m_insightContext.getRangeStart();
        if (object10 == null) {
            object10 = 0;
        }
        if ((n2 = this.m_insightContext.getRangeEnd()) == null) {
            n2 = this.m_insightContext.getText().length();
        }
        this.m_text = this.m_insightContext.getText().substring((Integer)object10, n2);
        String string2 = System.getProperty("line.separator");
        if (string2.length() > 1 && this.m_text.contains(string2)) {
            this.m_text = this.m_text.replace(string2, "\n");
        }
        this.m_offset = (n = this.m_insightContext.getSearchOffset()) == null ? n2 : n;
        if (this.m_offset < (Integer)object10 || this.m_offset > n2) {
            throw new IllegalStateException("offset not within the specied range");
        }
        DBObject dBObject = this.m_insightContext.getContextObject();
        DBObject dBObject2 = dBObject;
        if (dBObject2 == null) {
            plSqlToken = null;
            try {
                string = this.m_schema == null ? null : this.m_schema.getName();
                object9 = PlSqlIdentifier.getPlSqlIdentifier((String)this.m_text, (String)string, (boolean)false);
                if (object9 != null && object9.getPlsqlType() != null) {
                    plSqlToken = (PlSqlSourceObject)this.m_pro.getObjectFactory().newObject(Metadata.getInstance().getObjectClass(object9.getPlsqlType().toString()), (DBObject)this.m_schema, null, false, false);
                    plSqlToken.setSource(this.m_text);
                }
            }
            catch (Exception exception) {
                plSqlToken = null;
            }
            dBObject2 = plSqlToken;
        }
        plSqlToken = null;
        string = null;
        if (dBObject2 instanceof PlSqlSourceObject) {
            plSqlSourceObject = (PlSqlSourceObject)dBObject2;
            plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)plSqlSourceObject, (DBObjectProvider)this.m_pro);
            object9 = plSqlParser != null ? plSqlParser.getTokenAtOffset(0) : null;
        } else {
            plSqlSourceObject = null;
            plSqlParser = null;
            object9 = PlSqlTokenizer.tokenize((String)this.m_text, (String[])new String[0]);
        }
        if (object9 == null) {
            this.m_replacementStart = this.m_offset;
            this.m_replacementEnd = this.m_offset;
        } else {
            PlSqlToken plSqlToken2;
            plSqlToken = (PlSqlToken)object9.getTokenAt(this.m_offset - (Integer)object10 - 1);
            if (this.m_offset - (Integer)object10 >= this.m_text.length()) {
                plSqlToken2 = plSqlToken;
                object8 = (PlSqlToken)plSqlToken2.getNextToken();
            } else {
                object8 = (PlSqlToken)object9.getTokenAt(this.m_offset - (Integer)object10);
                plSqlToken2 = (PlSqlToken)object8.getPrevCodeToken();
            }
            if (plSqlToken2.matches("%")) {
                string = (PlSqlToken)plSqlToken2.getPrevCodeToken();
                this.m_replacementStart = string.getStart() + (Integer)object10;
                this.m_replacementEnd = plSqlToken2.getEnd() + (Integer)object10 + 1;
                if (((PlSqlToken)plSqlToken2.getNextToken()).isCode(true)) {
                    this.m_replacementEnd = ((PlSqlToken)plSqlToken2.getNextToken()).getEnd() + (Integer)object10 + 1;
                }
            } else if (plSqlToken != null && plSqlToken.isWord()) {
                String object72;
                this.m_replacementStart = plSqlToken.getStart() + (Integer)object10;
                this.m_replacementEnd = plSqlToken.getEnd() + (Integer)object10 + 1;
                if (((PlSqlToken)plSqlToken.getNextToken()).matches("%")) {
                    this.m_replacementEnd = ((PlSqlToken)plSqlToken.getNextToken()).getEnd() + (Integer)object10 + 1;
                    if (((PlSqlToken)((PlSqlToken)plSqlToken.getNextToken()).getNextToken()).isCode(true)) {
                        this.m_replacementEnd = ((PlSqlToken)((PlSqlToken)plSqlToken.getNextToken()).getNextToken()).getEnd() + (Integer)object10 + 1;
                    }
                }
                this.m_searchString = (object72 = this.m_text.substring(this.m_replacementStart - (Integer)object10, this.m_offset - (Integer)object10)).startsWith("\"") ? object72.substring(1) : this.m_pro.getInternalName(object72);
                if (((PlSqlToken)plSqlToken.getPrevCodeToken()).matches(".")) {
                    string = (PlSqlToken)((PlSqlToken)plSqlToken.getPrevCodeToken()).getPrevCodeToken();
                }
            } else {
                if (object8.isWord()) {
                    this.m_replacementStart = object8.getStart() + (Integer)object10;
                    this.m_replacementEnd = object8.getEnd() + (Integer)object10 + 1;
                } else {
                    this.m_replacementStart = this.m_offset;
                    this.m_replacementEnd = this.m_offset;
                }
                if (plSqlToken2.matches(".")) {
                    string = (PlSqlToken)plSqlToken2.getPrevCodeToken();
                }
            }
        }
        if (plSqlToken != null) {
            object8 = plSqlToken.getType();
            if (plSqlToken.matches("..") || object8 == Token.Type.MULTI_LINE_COMMENT || object8 == Token.Type.SINGLE_LINE_COMMENT || object8 == Token.Type.SINGLE_QUOTED_STRING) {
                return;
            }
        }
        if (plSqlSourceObject != null) {
            if (plSqlParser == null || plSqlParser.getEndOffsetOfObject() <= this.m_offset) {
                return;
            }
            this.m_contextObjectAtOffset = ((DBObjectPlSqlFragment)plSqlSourceObject).getChildAtOffset(this.m_offset.intValue());
            if (this.m_targetObjectClass == null) {
                for (object8 = this.m_contextObjectAtOffset; object8 != null && !(object8 instanceof PlSqlCodeFragment); object8 = object8.getParent()) {
                }
                if (object8 instanceof PlSqlCodeFragment) {
                    int n3 = ((PlSqlCodeFragment)object8).getStartOffset();
                    int n4 = ((PlSqlCodeFragment)object8).getEndOffset();
                    object6 = plSqlParser.getTokenAtOffset(n3);
                    object5 = plSqlParser.getTokenAtOffset(this.getOffset() - 1);
                    object4 = object5;
                    if (object5.getStart() > n3 && object5.matches(".")) {
                        object4 = (PlSqlToken)object5.getPrevCodeToken();
                    }
                    while (((PlSqlToken)object4.getPrevCodeToken()).matches(".") && object4.getStart() >= n3) {
                        object4 = (PlSqlToken)((PlSqlToken)object4.getPrevCodeToken()).getPrevCodeToken();
                    }
                    object5 = object4;
                    if (object5 != object6 && (object3 = ((DBObjectPlSqlFragment)plSqlSourceObject).getDeclarationAtOffset(this.m_offset.intValue())) != null) {
                        if (object3 instanceof PlSqlParameter) {
                            this.m_targetObjectClass = DataType.class;
                        } else if (object3 instanceof PlSqlVariable) {
                            this.m_targetObjectClass = DataTypeUsage.class;
                        } else if ("STATEMENT".equals(object3.getType())) {
                            this.m_targetObjectClass = DBObject.class;
                            insightDataProvider = new PlSqlSearch("{SELECT|WITH} {^INTO}... <into INTO>");
                            object2 = plSqlParser.getTokenAtOffset(n4);
                            if (insightDataProvider.matches((PlSqlToken)object6, (PlSqlToken)object2) && insightDataProvider.getNamedMatchStartToken("into").getStart() <= this.m_offset) {
                                object = new PlSqlSearch("{SELECT|WITH} {^FROM}... <from FROM>");
                                if (object.matches((PlSqlToken)object6, object2)) {
                                    if (object.getNamedMatchEndToken("from").getEnd() >= this.m_offset) {
                                        this.m_targetObjectClass = PlSqlDatum.class;
                                    }
                                } else {
                                    this.m_targetObjectClass = PlSqlDatum.class;
                                }
                            }
                        }
                    }
                }
            }
        } else if (dBObject2 != null) {
            this.m_contextObjectAtOffset = dBObject2;
        } else if (dBObject != null) {
            this.m_contextObjectAtOffset = dBObject;
        } else if (this.m_schema != null) {
            this.m_contextObjectAtOffset = this.m_schema;
        } else {
            DBLog.getLogger((Object)this).fine("Unable to identify a valid value for m_contextObjectAtOffset");
        }
        if (this.m_insightContext.getCasePolicy() == DBInsightContext.CasePolicy.LOWER) {
            this.m_makeLower = Boolean.TRUE;
        } else if (this.m_insightContext.getCasePolicy() == DBInsightContext.CasePolicy.UPPER || plSqlToken == null) {
            this.m_makeLower = Boolean.FALSE;
        } else {
            object8 = plSqlToken;
            while (!object8.isEndMarker() && !object8.isCode(true)) {
                object8 = (PlSqlToken)object8.getPrevCodeToken();
            }
            String string3 = object8.isEndMarker() ? "X" : object8.getSource();
            this.m_makeLower = string3.equals(string3.toLowerCase());
        }
        object8 = new ArrayList();
        if (this.m_insightDataProviderClasses == null) {
            object8.add(new ColumnInsightDataProvider());
            object8.add(new SchemaProvider());
            if (!(this.m_contextObjectAtOffset instanceof SQLQuery) || this.m_targetObjectClass == FromObject.class) {
                object8.add(new SchemaObjectInsightDataProvider());
            }
            if (this.m_contextObjectAtOffset instanceof DBObjectPlSqlFragment) {
                object8.add(new PlSqlInsightDataProvider());
            }
            if (this.m_targetObjectClass != null && (DataType.class.isAssignableFrom(this.m_targetObjectClass) || DataTypeUsage.class.isAssignableFrom(this.m_targetObjectClass))) {
                object8.add(new DataTypeProvider());
            } else {
                object8.add(new FunctionProvider());
                object8.add(new SQLFromObjectProvider());
            }
            if (this.m_insightContext.isIncludeReservedWords()) {
                object8.add(new ReservedWordInsightDataProvider());
            }
        } else {
            for (Class<? extends InsightDataProvider> clazz : this.m_insightDataProviderClasses) {
                try {
                    object8.add(clazz.newInstance());
                }
                catch (Exception exception) {
                    DBLog.getLogger((Object)this).severe("Failed to instantiate insightDataProvider: " + exception.getMessage());
                }
            }
        }
        Object object11 = object8.iterator();
        while (object11.hasNext()) {
            InsightDataProvider insightDataProvider2 = (InsightDataProvider)object11.next();
            insightDataProvider2.setDBInsightProvider(this);
        }
        if (this.m_parentLocatorClass == null) {
            object11 = dBObject instanceof SQLQuery && ((SQLQuery)dBObject).isDeclarative() ? new DeclarativeSQLQueryParentLocator() : (dBObject instanceof SQLQuery || dBObject instanceof SQLQueryOwner || dBObject instanceof PlSqlSourceObject || dBObject == null ? new SQLParentLocator() : new ParentLocator());
        } else {
            void var15_32;
            void var15_30;
            Object var15_28 = null;
            try {
                ParentLocator parentLocator = this.m_parentLocatorClass.newInstance();
            }
            catch (Exception exception) {
                DBLog.getLogger((Object)this).severe("Failed to instantiate parentLocator: " + exception.getMessage());
            }
            if (var15_30 == null) {
                ParentLocator parentLocator = new ParentLocator();
            }
            object11 = var15_32;
        }
        ((ParentLocator)object11).setDBInsightProvider(this);
        DBObject dBObject3 = this.m_contextObjectAtOffset == null ? null : DBUtil.getUppermostParent((DBObject)this.m_contextObjectAtOffset);
        object6 = new ArrayList();
        while (string != null && string.isCode()) {
            object6.add(0, this.m_pro.getInternalName(string.getSource()));
            if (((PlSqlToken)string.getPrevCodeToken()).matches(".") && ((PlSqlToken)((PlSqlToken)string.getPrevCodeToken()).getPrevCodeToken()).isCode(true)) {
                string = (PlSqlToken)((PlSqlToken)string.getPrevCodeToken()).getPrevCodeToken();
                continue;
            }
            if (((PlSqlToken)string.getPrevCodeToken()).matches(":") && object6.size() == 1 && dBObject3 instanceof Trigger) {
                object5 = (Trigger)dBObject3;
                object4 = new ArrayList();
                object3 = object5.getReferencingNewAs();
                if (object3 == null) {
                    object3 = "NEW";
                }
                object4.add(object3);
                object2 = object5.getReferencingOldAs();
                if (object2 == null) {
                    object2 = "OLD";
                }
                object4.add(object2);
                if (object4.contains(object6.get(0)) && (insightDataProvider = object5.getBaseObjectID()) != null) {
                    String string3;
                    object6.clear();
                    object = DBUtil.getSchemaName((DBObjectID)insightDataProvider);
                    if (object != null) {
                        object6.add(object);
                    }
                    if ((string3 = DBUtil.getDBObjectName((DBObjectID)insightDataProvider)) != null) {
                        object6.add(string3);
                    }
                }
            }
            string = null;
        }
        object5 = null;
        if (object6.size() > 0 && (object5 = ((ParentLocator)object11).getParent((List<String>)object6)) == null) {
            return;
        }
        if (object5 instanceof Synonym) {
            object5 = DBUtil.getSynonymReference((Synonym)((Synonym)object5));
        }
        boolean bl3 = bl = object5 != null;
        if (object5 == null) {
            object5 = this.m_contextObjectAtOffset;
        }
        int n3 = 0;
        while (true) {
            ++n3;
            object2 = object8.iterator();
            while (object2.hasNext()) {
                insightDataProvider = (InsightDataProvider)object2.next();
                insightDataProvider.setOrder(n3 * 10);
                insightDataProvider.addItems((DBObject)object5);
            }
            if (bl || object5 == null || this.m_parentScopeClass != null && this.m_parentScopeClass.isAssignableFrom(object5.getClass())) break;
            if (object5 instanceof Index && ((Index)object5).getTable() != null) {
                object5 = ((Index)object5).getTable();
                continue;
            }
            if (object5 instanceof SchemaObject) {
                object5 = ((SchemaObject)object5).getSchema();
                continue;
            }
            object5 = object5.getParent();
        }
    }

    public String getMatchingText() {
        return this.m_searchString;
    }

    public List<DBInsightData> getInsightData() {
        ArrayList<DBInsightData> arrayList = new ArrayList<DBInsightData>();
        arrayList.addAll(this.m_data.values());
        Collections.sort(arrayList, new InsightComparator());
        return arrayList;
    }

    final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    final Schema getSchema() {
        return this.m_schema;
    }

    final String getText() {
        return this.m_text;
    }

    final Integer getOffset() {
        return this.m_offset;
    }

    final DBObject getContextObjectAtOffset() {
        return this.m_contextObjectAtOffset;
    }

    final DBInsightContext.FilterMode getFilterMode() {
        return this.m_insightContext.getFilterMode();
    }

    final Class<? extends DBObject> getTargetObjectClass() {
        return this.m_targetObjectClass;
    }

    final Class<? extends DBObject> getParentScopeClass() {
        return this.m_parentScopeClass;
    }

    final DBInsightContext getInsightContext() {
        return this.m_insightContext;
    }

    final Class<? extends ParentLocator> getParentLocatorClass() {
        return this.m_parentLocatorClass;
    }

    final List<Class<? extends InsightDataProvider>> getInsightDataProviderClasses() {
        return this.m_insightDataProviderClasses;
    }

    final Boolean getMakeLower() {
        return this.m_makeLower;
    }

    final int getReplacementStart() {
        return this.m_replacementStart;
    }

    final int getReplacementEnd() {
        return this.m_replacementEnd;
    }

    final String getLanguage() {
        return this.m_language;
    }

    final boolean isUserOnly() {
        return this.m_userOnly;
    }

    final void addItem(DBInsightData dBInsightData) {
        String string = dBInsightData.getName();
        if (!this.m_data.containsKey(string)) {
            this.m_data.put(string, dBInsightData);
        }
    }

    public static DBObject resolveIDForInsight(DBObjectID dBObjectID) throws CancelledException {
        DBObject dBObject = null;
        if (dBObjectID != null) {
            try {
                dBObject = dBObjectID.resolveID();
            }
            catch (CancelledException cancelledException) {
                throw cancelledException;
            }
            catch (DBException dBException) {
                DBLog.getLogger(DBInsightProvider.class).fine(dBException.getMessage());
            }
        }
        return dBObject;
    }

    private static class InsightComparator
    implements Comparator<DBInsightData> {
        private InsightComparator() {
        }

        @Override
        public int compare(DBInsightData dBInsightData, DBInsightData dBInsightData2) {
            int n;
            int n2 = 0;
            int n3 = dBInsightData.getOrder();
            int n4 = n3 < (n = dBInsightData2.getOrder()) ? -1 : (n2 = n3 == n ? 0 : 1);
            if (n2 == 0) {
                n2 = dBInsightData.getDescription().compareTo(dBInsightData2.getDescription());
            }
            if (n2 == 0) {
                n2 = dBInsightData.getName().compareTo(dBInsightData2.getName());
            }
            return n2;
        }
    }
}

