/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.insight.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import oracle.ide.config.Preferences;
import oracle.ide.db.insight.completion.DBCompletionModel;
import oracle.ide.db.insight.completion.DBInsightCellRenderer;
import oracle.ide.db.insight.model.DBInsightContext;
import oracle.ide.db.insight.model.DBInsightData;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.insight.completion.CompletionContext;
import oracle.ide.insight.completion.CompletionProvider;
import oracle.ide.insight.completion.ui.InsightViewCustomizer;
import oracle.ide.insight.options.InsightOptions;
import oracle.ide.model.Node;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBObject;

class DBCompletionProvider
implements CompletionProvider<DBCompletionModel> {
    private final DBInsightContext m_insightContext;

    DBCompletionProvider(DBInsightContext dBInsightContext) {
        this.m_insightContext = dBInsightContext;
    }

    public DBCompletionModel getModel(CompletionContext completionContext) {
        InsightOptions insightOptions;
        JTextComponent jTextComponent = completionContext.getTextComponent();
        this.m_insightContext.setSearchOffset(jTextComponent.getCaretPosition());
        this.m_insightContext.setText(jTextComponent.getText());
        Node node = completionContext.getContext().getNode();
        if (node instanceof BaseDBObjectTextNode) {
            insightOptions = ((BaseDBObjectTextNode)node).getDBObjectFromBuffer();
            this.m_insightContext.setContextObject((DBObject)insightOptions);
        }
        if (!(insightOptions = InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences())).isCompleteFiltered()) {
            this.m_insightContext.setFilterMode(null);
        } else if (insightOptions.isFilterByContains()) {
            this.m_insightContext.setFilterMode(DBInsightContext.FilterMode.CONTAINS);
        } else {
            this.m_insightContext.setFilterMode(DBInsightContext.FilterMode.STARTS_WITH);
        }
        try {
            return new DBCompletionModel(this.m_insightContext, jTextComponent);
        }
        catch (CancelledException cancelledException) {
            return null;
        }
    }

    public DBCompletionModel updateModel(CompletionContext completionContext, DBCompletionModel dBCompletionModel) {
        return this.getModel(completionContext);
    }

    public Collection<Character> getTriggerCharacters() {
        ArrayList<Character> arrayList = new ArrayList<Character>();
        arrayList.add(Character.valueOf('.'));
        return arrayList;
    }

    public boolean isExactMatch(DBCompletionModel dBCompletionModel) {
        List<DBInsightData> list = dBCompletionModel.getMatchingItems();
        return list != null && list.size() == 1;
    }

    public void customizeView(InsightViewCustomizer insightViewCustomizer) {
        DBInsightCellRenderer dBInsightCellRenderer = new DBInsightCellRenderer(insightViewCustomizer);
        insightViewCustomizer.setRenderer((ListCellRenderer)((Object)dBInsightCellRenderer));
    }

    public String getDisplayName() {
        return null;
    }
}

