/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.panels.TemplateObjectsPanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.util.Holder;

public class TemplateObjectChooser {
    private TemplateObjectChooser() {
    }

    public static SystemObject getTemplate(DBObjectProvider dBObjectProvider, String[] stringArray) {
        String string2;
        final Holder holder = new Holder();
        HashMap<String, DBObject> hashMap = new HashMap<String, DBObject>();
        for (String string2 : stringArray) {
            hashMap.put(string2, dBObjectProvider.getDefaultTemplateForType(string2));
        }
        final TemplateObjectChooserPanel templateObjectChooserPanel = new TemplateObjectChooserPanel();
        templateObjectChooserPanel.setPreferredSize(new Dimension(400, 300));
        templateObjectChooserPanel.setHelpID("f1_dbchoosetemplateobject_html");
        templateObjectChooserPanel.init(dBObjectProvider, hashMap);
        Namespace namespace = new Namespace();
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), UIBundle.get("TEMPLATE_OBJECT_CHOOSER_TITLE"), (Traversable)templateObjectChooserPanel, namespace);
        string2 = tDialogLauncher.initDialog();
        string2.setContent((Component)((Object)templateObjectChooserPanel));
        string2.setResizable(true);
        string2.setName("Choose Template Object");
        VetoableChangeListener vetoableChangeListener = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                HashMap<String, DBObject> hashMap;
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent) && (hashMap = templateObjectChooserPanel.commit()) != null && hashMap.size() > 0) {
                    for (DBObject dBObject : hashMap.values()) {
                        if (!(dBObject instanceof SystemObject) || dBObject instanceof Schema) continue;
                        holder.set((Object)((SystemObject)dBObject));
                        break;
                    }
                }
            }
        };
        string2.addVetoableChangeListener(vetoableChangeListener);
        boolean bl = tDialogLauncher.showDialog();
        return (SystemObject)holder.get();
    }

    private static class TemplateObjectChooserPanel
    extends DefaultTraversablePanel {
        private JWrappedLabel m_hint = new JWrappedLabel();
        private TemplateObjectsPanel m_templateObjectsPanel = new TemplateObjectsPanel(true);

        public TemplateObjectChooserPanel() {
            this.layoutComponents();
        }

        private void layoutComponents() {
            this.setLayout(new GridBagLayout());
            this.m_hint.setText(UIBundle.get("TEMPLATE_OBJECT_CHOOSER_HINT"));
            this.add((Component)this.m_hint, this.gbc(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 10, 10)));
            this.add((Component)((Object)this.m_templateObjectsPanel), this.gbc(1, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 0, 10)));
        }

        private void init(DBObjectProvider dBObjectProvider, HashMap<String, DBObject> hashMap) {
            if (!(dBObjectProvider instanceof Database)) {
                this.m_hint.setText(UIBundle.get("TEMPLATE_OBJECT_CHOOSER_HINT_OFFLINE"));
                this.validate();
                this.repaint();
            }
            this.m_templateObjectsPanel.init(dBObjectProvider, hashMap);
        }

        private HashMap<String, DBObject> commit() {
            return this.m_templateObjectsPanel.commit();
        }
    }
}

