/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Metadata;

public final class DBEditorConfig {
    private final DBObjectProvider m_provider;
    private Schema m_schema;
    private Schema[] m_schemaList;
    private String m_objectType;
    private SystemObject m_updatedObject;
    private SystemObject m_originalObject;
    private SchemaObject m_contextObject;
    private DBObject m_childObject;
    private DBObjectNode m_node;
    private String m_property;
    private boolean m_commitToProvider = true;
    private boolean m_allowReplace;
    private boolean m_alwaysAllowReplace;
    private boolean m_backgroundTask;
    private boolean m_editable = true;
    private boolean m_childEditOnly;
    private String m_startPage;
    private DBEditorFactory.EditorType m_editorType;
    private Result m_dialogResult = Result.IN_PROGRESS;
    private DBException m_exception;

    private DBEditorConfig(DBObjectProvider dBObjectProvider) {
        this.m_provider = dBObjectProvider;
    }

    public DBObjectProvider getProvider() {
        return this.m_provider;
    }

    public void setReplaceAlwaysAllowed(boolean bl) {
        this.m_alwaysAllowReplace = bl;
    }

    public void setReplaceAllowed(boolean bl) {
        this.m_allowReplace = bl;
    }

    public boolean isReplaceAllowed() {
        return this.m_alwaysAllowReplace || this.m_allowReplace;
    }

    public void setCommitToProvider(boolean bl) {
        this.m_commitToProvider = bl;
    }

    public boolean isCommitToProvider() {
        return this.m_commitToProvider;
    }

    void setEditorType(DBEditorFactory.EditorType editorType) {
        this.m_editorType = editorType;
    }

    public DBEditorFactory.EditorType getEditorType() {
        return this.m_editorType;
    }

    public boolean isInFlatEditor() {
        return this.m_editorType == DBEditorFactory.EditorType.EDIT_FLAT;
    }

    public void setStartPage(String string) {
        this.m_startPage = string;
    }

    public String getStartPage() {
        return this.m_startPage;
    }

    public void setChildObject(DBObject dBObject) {
        this.checkInitFromNode();
        this.m_childObject = dBObject;
        this.checkChildIsFromUpdated();
    }

    private void checkChildIsFromUpdated() {
        DBObject dBObject;
        if (this.m_childObject != null && this.m_originalObject != null && this.m_updatedObject != null && DBUtil.getPropertyPath((DBObject)this.m_originalObject, (DBObject)this.m_childObject) != null && (dBObject = DBUtil.findChildInCopy((DBObject)this.m_originalObject, (DBObject)this.m_updatedObject, (DBObject)this.m_childObject)) != null) {
            this.m_childObject = dBObject;
        }
    }

    public DBObject getChildObject() {
        this.checkInitFromNode();
        return this.m_childObject;
    }

    public void setProperty(String string) {
        this.m_property = string;
    }

    public String getProperty() {
        return this.m_property;
    }

    public void setSchema(Schema schema) {
        this.m_schema = schema;
    }

    public Schema getSchema() {
        this.checkInitFromNode();
        if (this.m_schema == null) {
            try {
                this.m_schema = this.m_provider.getDefaultSchema();
            }
            catch (DBException dBException) {
                DBLog.getLogger((Object)this).warning(dBException.getMessage());
            }
        }
        return this.m_schema;
    }

    public void setSchemaList(Schema[] schemaArray) {
        this.m_schemaList = schemaArray;
    }

    public Schema[] getSchemaList() {
        if (this.m_schemaList == null) {
            try {
                this.m_schemaList = this.m_provider.listSchemas();
            }
            catch (DBException dBException) {
                Throwable throwable = dBException.getCause();
                if (throwable instanceof SQLException) {
                    SQLErrorDialog.showErrorDialog(DBMessageDialog.getDialogParent(), UIBundle.get("DBOBJECT_LIST_SCHEMAS_ERROR"), (SQLException)throwable);
                }
                DBExceptionDialog.showErrorDialog(DBMessageDialog.getDialogParent(), UIBundle.get("DBOBJECT_LIST_SCHEMAS_ERROR"), dBException);
            }
        }
        return this.m_schemaList;
    }

    private void checkDetails(DBObject dBObject) {
        if (this.m_objectType == null && dBObject != null) {
            this.m_objectType = dBObject.getType();
        }
        if (this.m_schema == null && dBObject instanceof SchemaObject) {
            this.setSchema(((SchemaObject)dBObject).getSchema());
        }
    }

    @Deprecated
    public void setNewObject(SystemObject systemObject) {
        this.setUpdatedObject(systemObject);
    }

    public void setUpdatedObject(SystemObject systemObject) {
        this.m_updatedObject = systemObject;
        this.checkDetails((DBObject)systemObject);
        if (systemObject != null && this.m_originalObject == null) {
            this.m_originalObject = (SystemObject)TemporaryObjectID.getOriginalObject((DBObject)systemObject);
        }
        this.checkChildIsFromUpdated();
    }

    @Deprecated
    public SystemObject getNewObject() {
        return this.getUpdatedObject();
    }

    public SystemObject getUpdatedObject() {
        SystemObject systemObject;
        this.checkInitFromNode();
        if (this.m_updatedObject == null && (systemObject = this.getOriginalObject()) != null) {
            this.setUpdatedObject((SystemObject)DBUtil.makeTemporaryCopy((DBObject)systemObject));
        }
        return this.m_updatedObject;
    }

    public void setOriginalObject(SystemObject systemObject) {
        this.m_originalObject = systemObject;
        this.checkDetails((DBObject)systemObject);
    }

    public SystemObject getOriginalObject() {
        this.checkInitFromNode();
        return this.m_originalObject;
    }

    public boolean isEdit() {
        return this.m_node != null || this.m_originalObject != null;
    }

    @Deprecated
    public List<SystemObject> getAdditionalObjects() {
        return Collections.emptyList();
    }

    public void setUseBackgroundTask(boolean bl) {
        this.m_backgroundTask = bl;
    }

    public boolean isUseBackgroundTask() {
        return this.m_backgroundTask;
    }

    public void setEditable(boolean bl) {
        this.m_editable = bl;
    }

    public boolean isEditable() {
        return this.m_editable;
    }

    public void setChildEditOnly(boolean bl) {
        this.m_childEditOnly = bl;
    }

    public boolean isChildEditOnly() {
        return this.m_childEditOnly;
    }

    public void setResult(Result result) {
        this.m_dialogResult = result;
    }

    public Result getResult() {
        return this.m_dialogResult;
    }

    public void setException(DBException dBException) {
        this.m_exception = dBException;
    }

    public DBException getException() {
        return this.m_exception;
    }

    public void setObjectType(String string) {
        this.m_objectType = string;
    }

    public String getObjectType() {
        if (this.m_objectType == null && this.m_node != null) {
            this.m_objectType = DBObjectNodeUtil.normalizeType(this.m_node);
        }
        return this.m_objectType;
    }

    public String getOriginalObjectName() {
        String string = null;
        if (this.m_node != null) {
            string = this.m_node.getObjectName();
        } else if (this.m_updatedObject != null) {
            string = this.m_updatedObject.getName();
        }
        return string;
    }

    public DBObjectNode getOriginalObjectNode() {
        return this.m_node;
    }

    public SchemaObject getContextObject() {
        return this.m_contextObject;
    }

    @Deprecated
    public Table getIndexParent() {
        SchemaObject schemaObject = this.getContextObject();
        if (schemaObject instanceof Table) {
            return (Table)schemaObject;
        }
        return null;
    }

    private void checkInitFromNode() {
        if (this.m_node != null && this.m_originalObject == null) {
            this.initEditFromObject(this.m_node.getDBObject(), true);
        }
    }

    private void initEditFromObject(DBObject dBObject, boolean bl) {
        DBObject dBObject2;
        SystemObject systemObject;
        Schema schema = DBUtil.getSchema((DBObject)dBObject);
        this.setSchema(schema);
        if (dBObject instanceof SystemObject) {
            systemObject = (SystemObject)dBObject;
            dBObject2 = null;
        } else {
            systemObject = DBUtil.getSystemObject((DBObject)dBObject);
            dBObject2 = dBObject;
        }
        this.setOriginalObject(systemObject);
        if (systemObject != null) {
            this.setChildObject(dBObject2);
            if (dBObject2 != null && bl) {
                this.setChildEditOnly(true);
                this.setObjectType(dBObject.getType());
            }
        }
    }

    public static DBEditorConfig newEditConfig(DBObjectNode dBObjectNode) {
        DBEditorConfig dBEditorConfig = new DBEditorConfig(dBObjectNode.getProvider());
        dBEditorConfig.m_node = dBObjectNode;
        return dBEditorConfig;
    }

    public static DBEditorConfig newEditConfig(DBObjectProvider dBObjectProvider, DBObject dBObject) {
        DBEditorConfig dBEditorConfig = new DBEditorConfig(dBObjectProvider);
        dBEditorConfig.initEditFromObject(dBObject, true);
        return dBEditorConfig;
    }

    public static DBEditorConfig newEditConfig(BaseObjectID baseObjectID, boolean bl) throws DBException {
        DBEditorConfig dBEditorConfig = null;
        DBObject dBObject = baseObjectID.resolveID();
        if (dBObject != null) {
            DBObjectProvider dBObjectProvider = baseObjectID.getProvider();
            dBEditorConfig = new DBEditorConfig(dBObjectProvider);
            dBEditorConfig.initEditFromObject(dBObject, bl);
        }
        return dBEditorConfig;
    }

    public static DBEditorConfig newCreateConfig(DBObjectTypeNode dBObjectTypeNode) {
        DBObjectProvider dBObjectProvider = null;
        try {
            dBObjectProvider = DBObjectProviderFactory.findOrCreateProvider((String)dBObjectTypeNode.getProviderType(), (Object)dBObjectTypeNode.getProviderIdentifier());
        }
        catch (DBException dBException) {
            DBLog.getLogger(DBEditorConfig.class).warning(dBException.getMessage());
        }
        return DBEditorConfig.newCreateConfig(dBObjectProvider, DBObjectNodeUtil.normalizeType(dBObjectTypeNode), DBObjectNodeUtil.getSchema(dBObjectTypeNode, true));
    }

    public static DBEditorConfig newCreateConfig(DBObjectProvider dBObjectProvider, String string, Schema schema) {
        DBEditorConfig dBEditorConfig = new DBEditorConfig(dBObjectProvider);
        dBEditorConfig.setSchema(schema);
        dBEditorConfig.setObjectType(string);
        return dBEditorConfig;
    }

    public static DBEditorConfig newCreateConfig(DBObjectProvider dBObjectProvider, DBObject dBObject) {
        DBEditorConfig dBEditorConfig = new DBEditorConfig(dBObjectProvider);
        dBEditorConfig.setSchema(DBUtil.getSchema((DBObject)dBObject));
        if (dBObject instanceof SystemObject) {
            dBEditorConfig.setUpdatedObject((SystemObject)dBObject);
        } else {
            dBEditorConfig.setUpdatedObject(DBUtil.getSystemObject((DBObject)dBObject));
            dBEditorConfig.setOriginalObject(null);
            dBEditorConfig.setObjectType(dBObject.getType());
            dBEditorConfig.setChildObject(dBObject);
            dBEditorConfig.setChildEditOnly(true);
        }
        return dBEditorConfig;
    }

    public static DBEditorConfig newCreateConfig(DBObjectProvider dBObjectProvider, String string, DBObject dBObject) {
        DBEditorConfig dBEditorConfig = new DBEditorConfig(dBObjectProvider);
        dBEditorConfig.setSchema(DBUtil.getSchema((DBObject)dBObject));
        dBEditorConfig.setObjectType(string);
        if (dBObject instanceof SystemObject) {
            if (Metadata.getInstance().isTypeOf(SystemObject.class, string)) {
                if (dBObject instanceof SchemaObject) {
                    dBEditorConfig.m_contextObject = (SchemaObject)dBObject;
                }
            } else {
                dBEditorConfig.setChildEditOnly(true);
                dBEditorConfig.setOriginalObject((SystemObject)dBObject);
            }
        }
        return dBEditorConfig;
    }

    public static DBEditorConfig newEmptyConfig(DBObjectProvider dBObjectProvider) {
        return new DBEditorConfig(dBObjectProvider);
    }

    public static void setConfig(Context context, DBEditorConfig dBEditorConfig) {
        context.setProperty(DBEditorConfig.class.getName(), (Object)dBEditorConfig);
    }

    public static DBEditorConfig getConfig(Context context) {
        return (DBEditorConfig)context.getProperty(DBEditorConfig.class.getName());
    }

    public static DBEditorConfig newClonedConfig(DBEditorConfig dBEditorConfig) {
        DBEditorConfig dBEditorConfig2 = DBEditorConfig.newEmptyConfig(dBEditorConfig.getProvider());
        dBEditorConfig2.m_allowReplace = dBEditorConfig.m_allowReplace;
        dBEditorConfig2.m_alwaysAllowReplace = dBEditorConfig.m_alwaysAllowReplace;
        dBEditorConfig2.m_backgroundTask = dBEditorConfig.m_backgroundTask;
        dBEditorConfig2.m_childEditOnly = dBEditorConfig.m_childEditOnly;
        dBEditorConfig2.m_childObject = dBEditorConfig.m_childObject;
        dBEditorConfig2.m_commitToProvider = dBEditorConfig.m_commitToProvider;
        dBEditorConfig2.m_editable = dBEditorConfig.m_editable;
        dBEditorConfig2.m_contextObject = dBEditorConfig.m_contextObject;
        dBEditorConfig2.m_node = dBEditorConfig.m_node;
        dBEditorConfig2.m_objectType = dBEditorConfig.m_objectType;
        dBEditorConfig2.m_originalObject = dBEditorConfig.m_originalObject;
        dBEditorConfig2.m_property = dBEditorConfig.m_property;
        dBEditorConfig2.m_schema = dBEditorConfig.m_schema;
        dBEditorConfig2.m_schemaList = dBEditorConfig.m_schemaList;
        dBEditorConfig2.m_startPage = dBEditorConfig.m_startPage;
        dBEditorConfig2.m_updatedObject = dBEditorConfig.m_updatedObject;
        return dBEditorConfig2;
    }

    public static enum Result {
        ERROR,
        FAILED,
        CANCELLED,
        IN_PROGRESS,
        SUCCESS;

    }
}

