/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.ide.db.DBObjectTransferable;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.controls.DBObjectListPicker;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.NameController;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.SystemObject;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.util.ModelUtil;

public class SchemaObjectTargetPicker
extends DBObjectListPicker
implements DocumentListener,
ListSelectionListener,
ShuttleListener,
Traversable {
    private JPanel m_panel;
    private JLabel m_label;
    private JTextField m_newName;
    private ComponentWithTitlebar m_compTitleBar = new ComponentWithTitlebar();
    private int m_current = -1;
    private boolean m_commitPending;
    private boolean m_ignoreList;
    private boolean m_ignoreField;
    private DBObjectProvider m_provider;
    private NameController m_nameController;

    public SchemaObjectTargetPicker() {
        this(new JList());
    }

    public SchemaObjectTargetPicker(NameController nameController) {
        this(new JList());
        this.m_nameController = nameController;
    }

    public SchemaObjectTargetPicker(JList jList) {
        super(jList);
    }

    private void setupNamePanel() {
        this.m_panel = new JPanel();
        this.m_label = new JLabel();
        this.getList().addListSelectionListener(this);
        this.m_panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0);
        gridBagConstraints.gridwidth = 2;
        this.m_panel.add(super.getComponent(), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.m_panel.add((Component)this.m_label, gridBagConstraints);
        if (this.m_nameController != null) {
            this.m_newName = new JTextField();
            ResourceUtils.resLabel((JLabel)this.m_label, (Component)this.m_newName, (String)this.m_nameController.getNameLabel());
            this.m_newName.getDocument().addDocumentListener(this);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.m_panel.add((Component)this.m_newName, gridBagConstraints);
        }
    }

    public JLabel getLabel() {
        return this.m_label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateName() {
        if (this.m_nameController != null) {
            this.m_ignoreField = true;
            try {
                this.m_newName.setText(null);
                SchemaObjectDescriptor schemaObjectDescriptor = (SchemaObjectDescriptor)this.getList().getSelectedValue();
                Object[] objectArray = this.getList().getSelectedValues();
                if (schemaObjectDescriptor != null && objectArray != null && objectArray.length == 1) {
                    this.m_newName.setEnabled(true);
                    String string = schemaObjectDescriptor.getOtherName();
                    if (!ModelUtil.hasLength((String)string)) {
                        string = this.m_nameController.getDefaultName(schemaObjectDescriptor.getType(), schemaObjectDescriptor.getName());
                        schemaObjectDescriptor.setOtherName(string);
                    }
                    this.m_newName.setText(this.m_nameController.getExternalName(string));
                    this.m_current = this.getList().getSelectedIndex();
                } else {
                    this.m_newName.setEnabled(false);
                    this.m_newName.setText(null);
                    this.m_current = -1;
                }
            }
            finally {
                this.m_commitPending = false;
                this.m_ignoreField = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commitName(boolean bl) {
        SchemaObjectDescriptor schemaObjectDescriptor;
        if (this.m_current > -1 && this.m_commitPending && (schemaObjectDescriptor = (SchemaObjectDescriptor)this.getList().getModel().getElementAt(this.m_current)) != null) {
            Collection collection;
            boolean bl2;
            boolean bl3 = false;
            String string = this.m_newName.getText().trim();
            String string2 = schemaObjectDescriptor.getOtherName();
            if (this.m_nameController != null) {
                try {
                    this.m_nameController.validateName(schemaObjectDescriptor.getType(), string);
                }
                catch (InvalidNameException invalidNameException) {
                    if (bl) {
                        MessageDialog.error((Component)this.getList(), (Object)invalidNameException.getMessage(), (String)UIBundle.get("PICKER_NAME_TITLE"), null);
                    }
                    bl3 = true;
                }
            }
            String string3 = this.m_nameController.getInternalName(string);
            if (!bl3 && ModelUtil.areDifferent((Object)string3, (Object)string2) && !this.m_nameController.canHaveDuplicateNames() && (bl2 = (collection = this.getExistingNames(schemaObjectDescriptor)).contains(string3))) {
                if (bl) {
                    MessageDialog.error((Component)this.getList(), (Object)UIBundle.format("PICKER_DUP_NAME", schemaObjectDescriptor.getName()), (String)UIBundle.get("PICKER_NAME_TITLE"), null);
                }
                bl3 = true;
            }
            if (bl3) {
                this.m_ignoreList = true;
                try {
                    this.getList().setSelectedIndex(this.m_current);
                    this.m_newName.requestFocusInWindow();
                }
                finally {
                    this.m_ignoreList = false;
                }
                return false;
            }
            if (ModelUtil.hasLength((String)string3) && ModelUtil.areDifferent((Object)string3, (Object)string2)) {
                schemaObjectDescriptor.setOtherName(string3);
            } else {
                schemaObjectDescriptor.setOtherName(null);
            }
            this.getList().repaint();
        }
        return true;
    }

    private Collection getExistingNames(SchemaObjectDescriptor schemaObjectDescriptor) {
        ArrayList<String> arrayList = new ArrayList<String>();
        DefaultListModel defaultListModel = (DefaultListModel)this.getList().getModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            SchemaObjectDescriptor schemaObjectDescriptor2 = (SchemaObjectDescriptor)defaultListModel.get(i);
            if (schemaObjectDescriptor != null && schemaObjectDescriptor == schemaObjectDescriptor2) continue;
            arrayList.add(schemaObjectDescriptor2.getName());
        }
        return arrayList;
    }

    public Component getComponent() {
        if (this.m_panel == null && this.m_nameController != null) {
            this.setupNamePanel();
        }
        if (this.m_panel != null) {
            return this.m_panel;
        }
        this.m_compTitleBar.setComponent((JComponent)((JScrollPane)super.getComponent()));
        return this.m_compTitleBar;
    }

    @Override
    public boolean addSelectedItems(Transferable[] transferableArray) {
        if (!this.commitName(false)) {
            return false;
        }
        ListModel listModel = this.getList().getModel();
        if (!(listModel instanceof DefaultListModel)) {
            return false;
        }
        DefaultListModel defaultListModel = new DefaultListModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            defaultListModel.addElement(listModel.getElementAt(i));
        }
        ListSelectionModel listSelectionModel = this.getList().getSelectionModel();
        this.m_ignoreList = true;
        listSelectionModel.clearSelection();
        this.m_ignoreList = false;
        int n = defaultListModel.getSize();
        int n2 = 0;
        for (int i = 0; i < transferableArray.length; ++i) {
            if (!(transferableArray[i] instanceof DBObjectTransferable)) continue;
            this.cachePath((DBObjectTransferable)transferableArray[i]);
            DBObject dBObject = ((DBObjectTransferable)transferableArray[i]).getDBObject();
            if (!(dBObject instanceof SystemObject)) continue;
            SchemaObjectDescriptor schemaObjectDescriptor = new SchemaObjectDescriptor((SystemObject)dBObject);
            int n3 = defaultListModel.getSize();
            defaultListModel.add(n3, schemaObjectDescriptor);
            ++n2;
        }
        this.getList().setModel(defaultListModel);
        if (n2 > 0) {
            this.m_ignoreList = true;
            listSelectionModel.setSelectionInterval(n, n + n2 - 1);
            this.m_ignoreList = false;
            this.checkSchemas();
        }
        return true;
    }

    @Override
    public void removeSelectedItems() {
        this.m_current = -1;
        super.removeSelectedItems();
        this.checkSchemas();
    }

    @Override
    public void removeAllSelectableItems() {
        this.m_current = -1;
        super.removeAllSelectableItems();
        this.checkSchemas();
    }

    private void checkSchemas() {
        ListCellRenderer listCellRenderer = this.getRenderer();
        if (listCellRenderer instanceof DBObjectRenderer) {
            boolean bl = false;
            String string = null;
            ListModel listModel = this.getList().getModel();
            for (int i = 0; i < listModel.getSize(); ++i) {
                SchemaObjectDescriptor schemaObjectDescriptor = (SchemaObjectDescriptor)listModel.getElementAt(i);
                String string2 = schemaObjectDescriptor.getSchema();
                if (string2 == null) continue;
                if (string == null) {
                    string = string2;
                    continue;
                }
                if (string2.equals(string)) continue;
                bl = true;
                break;
            }
            ((DBObjectRenderer)listCellRenderer).setShowSchema(bl);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (!this.commitName(true)) {
            throw new TraversalException(null);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_provider = (DBObjectProvider)traversableContext.get("TargetDBObjectProvider");
        if (this.m_newName != null) {
            this.populateName();
        }
        this.checkSchemas();
    }

    public DBObjectProvider getProvider() {
        return this.m_provider;
    }

    public String getHelpID() {
        return null;
    }

    public Object getExitTransition() {
        return null;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this.m_ignoreField) {
            this.m_commitPending = true;
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (!this.m_ignoreField) {
            this.m_commitPending = true;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (!this.m_ignoreField) {
            this.m_commitPending = true;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.m_ignoreList && this.commitName(true)) {
            this.populateName();
        }
    }

    public void shuttleItemsMoved(ShuttleEvent shuttleEvent) {
        if (this.getList().getSelectedIndex() != this.m_current) {
            this.populateName();
        }
    }

    public void shuttleItemsRemoved(ShuttleEvent shuttleEvent) {
        this.populateName();
    }

    public void shuttleItemsReordered(ShuttleEvent shuttleEvent) {
        this.populateName();
    }

    public void setTitleLabel(JLabel jLabel) {
        this.m_compTitleBar.setLabel(jLabel);
    }

    public void setTitleControlBar(ControlBar controlBar) {
        this.m_compTitleBar.setControlBar(controlBar);
    }
}

