/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.db.util.LiveValidationController;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.event.DBObjectPropertyListener;
import oracle.javatools.db.validators.ValidationException;

public class NameTextField
extends JTextField {
    private boolean m_listening;
    private Timer m_timer;
    private LiveValidationController m_vController;
    private String m_originalName;
    private String m_currentName;
    private Schema m_originalSchema;
    private Schema m_currentSchema;
    private DBObject m_dbObject;
    private DBObjectProvider m_pro;
    private String m_errorMessage;
    private DBObjectListener m_objListener = new DBObjectPropertyListener(new String[]{"schema"}){

        protected void propertyChanged(DBObject dBObject, String string, PropertyChangeEvent propertyChangeEvent) {
            NameTextField.this.commitName();
        }
    };

    public NameTextField() {
        this(true);
    }

    public NameTextField(boolean bl) {
        this.setColumns(30);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                NameTextField.this.commitName();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                NameTextField.this.commitName();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                NameTextField.this.commitName();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                NameTextField.this.showNameError(NameTextField.this.commitIdentifier(true));
            }
        });
        if (bl) {
            this.m_vController = new LiveValidationController(this);
        }
    }

    public void commitName() {
        if (this.m_listening) {
            if (this.m_errorMessage != null) {
                this.showNameError(this.commitIdentifier());
            }
            this.getTimer().restart();
        }
    }

    public void init(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        this.init(dBObject, null, dBObjectProvider);
    }

    public void init(DBObject dBObject, DBObject dBObject2, DBObjectProvider dBObjectProvider) {
        if (dBObject2 != null) {
            this.m_originalName = dBObject2.getName();
            this.m_originalSchema = dBObject2 instanceof SchemaObject ? ((SchemaObject)dBObject2).getSchema() : null;
        } else if (dBObject != null) {
            this.m_originalName = dBObject.getName();
            this.m_originalSchema = dBObject instanceof SchemaObject ? ((SchemaObject)dBObject).getSchema() : null;
        } else {
            this.m_originalName = null;
            this.m_originalSchema = null;
        }
        this.setCurrentNameAndSchema(this.m_originalName, this.m_originalSchema);
        this.m_pro = dBObjectProvider;
        if (this.m_dbObject != dBObject) {
            this.removeObjectListener();
            this.m_dbObject = dBObject;
            if (dBObject instanceof SchemaObject) {
                dBObject.addObjectListener(this.m_objListener);
            }
        }
        if (dBObject != null) {
            this.setText(dBObjectProvider.getExternalName(dBObject.getName(), dBObject.getType()));
            this.m_listening = true;
        } else {
            this.setText(null);
            this.m_listening = false;
        }
    }

    public void commit() throws TraversalException {
        this.m_listening = true;
        this.m_errorMessage = this.commitIdentifier();
        if (this.m_errorMessage != null) {
            throw new TraversalException(this.m_errorMessage);
        }
        this.m_listening = false;
        this.removeObjectListener();
    }

    private void removeObjectListener() {
        if (this.m_dbObject instanceof SchemaObject) {
            this.m_dbObject.removeObjectListener(this.m_objListener);
        }
    }

    public void initialiseObjectListener() {
        this.removeObjectListener();
        if (this.m_dbObject instanceof SchemaObject) {
            this.m_dbObject.addObjectListener(this.m_objListener);
        }
    }

    protected Timer getTimer() {
        if (this.m_timer == null) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NameTextField.this.showNameError(NameTextField.this.commitIdentifier());
                }
            };
            this.m_timer = new Timer(1500, actionListener);
            this.m_timer.setRepeats(false);
        }
        return this.m_timer;
    }

    private String commitIdentifier() {
        return this.commitIdentifier(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String commitIdentifier(boolean bl) {
        this.getTimer().stop();
        if (this.m_dbObject != null && this.m_listening) {
            String string = this.m_dbObject.getType();
            String string2 = this.getText();
            String string3 = this.m_pro.getInternalName(string2, string);
            boolean bl2 = this.hasNameChanged(string3);
            if (bl2) {
                try {
                    this.m_pro.validateName(string, string2);
                    this.m_dbObject.setName(string3);
                }
                catch (ValidationException validationException) {
                    String string4 = validationException.getLocalizedMessage();
                    return string4;
                }
                finally {
                    this.m_currentName = string3;
                }
            }
            if (bl && this.m_errorMessage == null) {
                this.m_listening = false;
                this.setText(this.m_pro.getExternalName(string3, this.m_dbObject.getType()));
                this.m_listening = true;
            }
            if (this.m_dbObject instanceof SystemObject) {
                String string5;
                Schema schema;
                if (!bl2 && this.m_dbObject instanceof SchemaObject && (schema = ((SchemaObject)this.m_dbObject).getSchema()) != null) {
                    if (this.hasSchemaChanged(schema)) {
                        this.m_currentSchema = schema;
                        bl2 = true;
                    } else {
                        return this.m_errorMessage;
                    }
                }
                boolean bl3 = this.isSameAsOriginal(this.m_dbObject);
                if (bl2 && !bl3 && !string3.equals(string5 = this.m_pro.getUniqueName(string, (DBObject)DBUtil.getSchema((DBObject)this.m_dbObject), string3))) {
                    return UIBundle.get("DBOBJECT_CREATE_OBJ_EXISTS");
                }
            }
        }
        return null;
    }

    protected void showNameError(String string) {
        if (this.m_vController != null) {
            this.m_errorMessage = string;
            this.m_vController.showError(string);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.m_vController != null) {
            this.m_vController.hidePopup();
        }
        super.setEnabled(bl);
    }

    private void setCurrentNameAndSchema(String string, Schema schema) {
        this.m_currentName = string;
        this.m_currentSchema = schema;
    }

    private boolean hasNameChanged(String string) {
        String string2 = this.m_dbObject.getType();
        boolean bl = this.m_currentName == null || !this.m_pro.getDescriptor().areNamesEqual(string, this.m_currentName, string2, false);
        return bl;
    }

    private boolean hasSchemaChanged(Schema schema) {
        boolean bl = this.m_currentSchema == null || !this.m_pro.getDescriptor().areNamesEqual(schema.getName(), this.m_currentSchema.getName(), "SCHEMA", false);
        return bl;
    }

    private boolean isSameAsOriginal(DBObject dBObject) {
        Schema schema;
        String string = dBObject.getType();
        boolean bl = this.m_pro.getDescriptor().areNamesEqual(dBObject.getName(), this.m_originalName, string, false);
        if (bl && this.m_originalSchema != null && dBObject instanceof SchemaObject && (schema = ((SchemaObject)dBObject).getSchema()) != null) {
            bl = this.m_pro.getDescriptor().areNamesEqual(schema.getName(), this.m_originalSchema.getName(), "SCHEMA", false);
        }
        return bl;
    }
}

