/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.controls.DBObjectPicker;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.dialogs.ProgressBar;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class DBObjectSourcePicker
extends DBObjectPicker {
    private String[] m_types;
    private DBObjectProvider m_pro;
    private Schema m_schema;
    private String m_filter;
    private final JPanel m_component = new JPanel();
    private JWrappedLabel m_emptyLabel;

    public DBObjectSourcePicker(DBObjectProvider dBObjectProvider, boolean bl, boolean bl2) {
        super(bl, bl2);
        this.m_pro = dBObjectProvider;
        this.showEmptyUI();
    }

    private void showEmptyUI() {
        if (this.m_emptyLabel == null) {
            this.m_emptyLabel = new JWrappedLabel(UIBundle.get("PICKER_EMPTY"));
            this.m_component.removeAll();
            this.m_component.setLayout(new GridBagLayout());
            this.m_component.setBorder(BorderFactory.createEtchedBorder());
            this.m_component.add((Component)this.m_emptyLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.m_component.validate();
        }
    }

    public void setProvider(DBObjectProvider dBObjectProvider) {
        if (this.m_pro != dBObjectProvider) {
            this.m_pro = dBObjectProvider;
            this.m_top.removeAllChildren();
            this.m_treeModel.reload();
            this.showEmptyUI();
        }
    }

    protected DBObjectProvider getProvider() {
        return this.m_pro;
    }

    public void setTypes(String[] stringArray) {
        this.m_types = stringArray;
    }

    public void setSchema(Schema schema) {
        this.m_schema = schema;
    }

    public boolean setFilter(String string) {
        if (!ModelUtil.areEqual((Object)this.m_filter, (Object)string)) {
            this.m_filter = string;
            return true;
        }
        return false;
    }

    public void query() {
        boolean bl;
        Holder holder;
        Object object;
        if (this.m_pro instanceof Database) {
            object = new ProgressBar(DBMessageDialog.getDialogParent(), UIBundle.get("PICKER_PROGRESS_TITLE"), null, true);
            holder = new Holder();
            Runnable runnable = new Runnable((ProgressBar)object){
                final /* synthetic */ ProgressBar val$bar;
                {
                    this.val$bar = progressBar;
                }

                @Override
                public void run() {
                    holder.set((Object)Thread.currentThread());
                    try {
                        DBObjectSourcePicker.this.doQuery(this.val$bar);
                    }
                    finally {
                        holder.set(null);
                        this.val$bar.setDoneStatus();
                    }
                }
            };
            object.setRunnable(runnable);
            object.start(UIBundle.get("PICKER_PROGRESS_TEXT"), null);
            if (object.hasUserCancelled()) {
                bl = false;
                Thread thread = (Thread)holder.get();
                if (thread != null) {
                    StatementWrapper.cancelExecution((Thread)thread);
                }
            } else {
                bl = true;
            }
        } else {
            this.doQuery(null);
            bl = true;
        }
        if (bl) {
            this.m_treeModel.setRoot(this.m_top);
            this.m_treeModel.reload();
            if (this.m_emptyLabel != null) {
                this.m_component.removeAll();
                object = new DBUIResourceHelper(this.getComponentNamePrefix());
                holder = (ComponentWithTitlebar)super.getComponent();
                ((DBUIResourceHelper)object).setName(holder.getComponent(), "Tree");
                this.m_component.add((Component)holder, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.m_component.setBorder(null);
                this.m_component.validate();
                this.m_emptyLabel = null;
            }
        }
    }

    protected String getComponentNamePrefix() {
        return "DBObjectSourcePicker";
    }

    private void doQuery(ProgressBar progressBar) {
        DBException dBException = null;
        try {
            if (this.m_types != null && this.m_types.length > 0) {
                if (progressBar != null && progressBar.hasUserCancelled()) {
                    return;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (String object : this.m_types) {
                    if (Metadata.getInstance().isTypeOf(SchemaObject.class, object)) {
                        arrayList2.add(object);
                        continue;
                    }
                    if (object.equals("SCHEMA")) continue;
                    arrayList.add(object);
                }
                ArrayList arrayList3 = new ArrayList();
                if (!arrayList2.isEmpty()) {
                    DBObjectCriteria dBObjectCriteria = DBObjectCriteria.createTypeCriteria(arrayList2);
                    dBObjectCriteria.setSchema(this.m_schema);
                    dBObjectCriteria.setNameLike(this.m_filter);
                    if (this.m_schema != null && this.m_schema.getID() instanceof BaseObjectID) {
                        dBObjectCriteria.setDatabaseName(((BaseObjectID)this.m_schema.getID()).getDatabaseName());
                    }
                    arrayList3.addAll(this.m_pro.listObjects(dBObjectCriteria));
                }
                if (progressBar != null && progressBar.hasUserCancelled()) {
                    return;
                }
                if (!arrayList.isEmpty()) {
                    DBObjectCriteria dBObjectCriteria = DBObjectCriteria.createTypeCriteria(arrayList);
                    dBObjectCriteria.setNameLike(this.m_filter);
                    arrayList3.addAll(this.m_pro.listObjects(dBObjectCriteria));
                }
                if (progressBar != null && progressBar.hasUserCancelled()) {
                    return;
                }
                SystemObject[] systemObjectArray = this.filterAndSort(arrayList3.toArray(new SystemObject[arrayList3.size()]));
                this.m_top = new DefaultMutableTreeNode("DB_OBJECTS");
                for (int i = 0; i < systemObjectArray.length; ++i) {
                    if (progressBar != null && progressBar.hasUserCancelled()) {
                        return;
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode = this.m_nodeMaker.createTreeNode((DBObject)systemObjectArray[i]);
                    this.m_top.add(defaultMutableTreeNode);
                }
            }
        }
        catch (DBException dBException2) {
            dBException = dBException2;
        }
        if (progressBar != null) {
            progressBar.setDoneStatus();
        }
        if (!(dBException == null || progressBar != null && progressBar.hasUserCancelled() || dBException instanceof CancelledException)) {
            DBExceptionDialog.showErrorDialog(DBMessageDialog.getDialogParent(), UIBundle.get("QUERY_FAILED"), dBException);
        }
    }

    protected SystemObject[] filterAndSort(SystemObject[] systemObjectArray) {
        Arrays.sort(systemObjectArray, DBUtil.getNameComparator());
        return systemObjectArray;
    }

    @Override
    public Component getComponent() {
        return this.m_component;
    }
}

