/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.components;

import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.util.Namespace;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.util.ModelUtil;

public final class ComponentContext {
    private DBObject m_originalObject;
    private DBObject m_updatedObject;
    private boolean m_inTable;
    private boolean m_isButton;
    private PropertyInfo m_propInfo;
    private final String m_propName;
    private String m_basePath;
    private Namespace m_dataContext;
    private ComponentContext m_parentComponentContext;
    private final String m_owningPanelName;

    ComponentContext(String string, DBObject dBObject, DBObject dBObject2, Namespace namespace, String string2) {
        this.m_propName = string;
        this.m_originalObject = dBObject;
        this.m_updatedObject = dBObject2;
        this.m_dataContext = namespace;
        this.m_owningPanelName = string2;
        if (this.m_originalObject == null && this.m_updatedObject == null) {
            DBEditorConfig dBEditorConfig = this.getEditorConfig();
            this.m_originalObject = dBEditorConfig.getChildObject();
            this.m_updatedObject = dBEditorConfig.getChildObject();
        }
    }

    public DBObject getOriginalObject() {
        return this.m_originalObject;
    }

    public void setUpdatedObject(DBObject dBObject) {
        this.m_updatedObject = dBObject;
        this.m_originalObject = null;
        if (dBObject != null) {
            DBObjectID dBObjectID = dBObject.getID();
            if (dBObjectID instanceof TemporaryObjectID) {
                this.m_originalObject = TemporaryObjectID.findOriginalObject((TemporaryObjectID)((TemporaryObjectID)dBObjectID));
            } else if (dBObjectID != null) {
                throw new IllegalStateException("updatedObject must have a TemopraryObjectID");
            }
        }
    }

    public DBObject getUpdatedObject() {
        return this.m_updatedObject;
    }

    public SystemObject getUpdatedSystemObject() {
        return this.getEditorConfig().getUpdatedObject();
    }

    public SystemObject getOriginalSystemObject() {
        return this.getEditorConfig().getOriginalObject();
    }

    public boolean isInFlatEditor() {
        return this.getEditorConfig().isInFlatEditor();
    }

    public void setInTable(boolean bl) {
        this.m_inTable = bl;
    }

    public boolean isInTable() {
        return this.m_inTable;
    }

    public void setButtonContext(boolean bl) {
        this.m_isButton = bl;
    }

    public boolean isButtonContext() {
        return this.m_isButton;
    }

    public PropertyInfo getPropertyInfo() {
        if (this.m_propInfo == null) {
            PropertyManager propertyManager = this.getProvider().getPropertyManager();
            SystemObject systemObject = this.getUpdatedSystemObject();
            this.m_propInfo = systemObject == null ? propertyManager.findPropertyInfo(this.getUpdatedObject().getClass(), this.getPropertyName()) : propertyManager.findPropertyInfo(systemObject.getClass(), this.getFullPropertyPath());
        }
        return this.m_propInfo;
    }

    public DBEditorConfig getEditorConfig() {
        return (DBEditorConfig)this.m_dataContext.find(DBEditorConfig.class);
    }

    void setDataContext(Namespace namespace) {
        this.m_dataContext = namespace;
    }

    public Namespace getDataContext() {
        return this.m_dataContext;
    }

    public ComponentContext getParentComponentContext() {
        return this.m_parentComponentContext;
    }

    public void setParentComponentContext(ComponentContext componentContext) {
        this.m_parentComponentContext = componentContext;
    }

    public DBObjectProvider getProvider() {
        return this.getEditorConfig().getProvider();
    }

    public String getOwningPanelName() {
        if (this.m_owningPanelName != null) {
            return this.m_owningPanelName;
        }
        if (this.m_parentComponentContext != null) {
            return this.m_parentComponentContext.getOwningPanelName();
        }
        return null;
    }

    public String getPropertyName() {
        return this.m_propName;
    }

    public String getBasePath() {
        return this.m_basePath;
    }

    public void setBasePath(String string) {
        this.m_basePath = string;
    }

    public String getFullPropertyPath() {
        String string = this.getBasePath();
        String string2 = this.getPropertyName();
        if (ModelUtil.hasLength((String)string)) {
            string2 = Property.createPath((String[])new String[]{string, string2});
        }
        return string2;
    }
}

