/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.triggers;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import org.jdesktop.animation.timing.TimingController;
import org.jdesktop.animation.timing.triggers.ComponentFocusEvent;
import org.jdesktop.animation.timing.triggers.Trigger;
import org.jdesktop.animation.timing.triggers.TriggerEvent;
import org.jdesktop.animation.timing.triggers.TriggerListener;

public class ComponentFocusTrigger
extends Trigger {
    public ComponentFocusTrigger(TimingController timingController, Component component, Trigger.TriggerAction triggerAction, ComponentFocusEvent componentFocusEvent) {
        this.setupListener(timingController, component, triggerAction, componentFocusEvent);
    }

    public ComponentFocusTrigger(TimingController timingController, Component component, ComponentFocusEvent componentFocusEvent, TimingController timingController2) {
        super(timingController, component, componentFocusEvent, timingController2);
    }

    @Override
    protected void setupListener(TimingController timingController, Object object, Trigger.TriggerAction triggerAction, TriggerEvent triggerEvent) {
        try {
            ComponentFocusListener componentFocusListener = new ComponentFocusListener(timingController, triggerAction, (ComponentFocusEvent)triggerEvent);
            this.setupListener(object, componentFocusListener, "addFocusListener", FocusListener.class);
        }
        catch (Exception exception) {
            System.out.println("Exception creating focus listener for object " + object + ": " + exception);
        }
    }

    private class ComponentFocusListener
    extends TriggerListener
    implements FocusListener {
        ComponentFocusEvent event;

        protected ComponentFocusListener(TimingController timingController, Trigger.TriggerAction triggerAction, ComponentFocusEvent componentFocusEvent) {
            super(timingController, triggerAction);
            this.event = componentFocusEvent;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (this.event == ComponentFocusEvent.FOCUS_IN) {
                this.pullTrigger();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (this.event == ComponentFocusEvent.FOCUS_OUT) {
                this.pullTrigger();
            }
        }
    }
}

