/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.triggers;

import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.animation.timing.TimingController;
import org.jdesktop.animation.timing.triggers.ButtonStateEvent;
import org.jdesktop.animation.timing.triggers.Trigger;
import org.jdesktop.animation.timing.triggers.TriggerEvent;
import org.jdesktop.animation.timing.triggers.TriggerListener;

public class ButtonStateTrigger
extends Trigger {
    public ButtonStateTrigger(TimingController timingController, AbstractButton abstractButton, Trigger.TriggerAction triggerAction, ButtonStateEvent buttonStateEvent) {
        this.setupListener(timingController, abstractButton, triggerAction, buttonStateEvent);
    }

    public ButtonStateTrigger(TimingController timingController, AbstractButton abstractButton, ButtonStateEvent buttonStateEvent, TimingController timingController2) {
        super(timingController, abstractButton, buttonStateEvent, timingController2);
    }

    @Override
    protected void setupListener(TimingController timingController, Object object, Trigger.TriggerAction triggerAction, TriggerEvent triggerEvent) {
        try {
            ButtonModel buttonModel = ((AbstractButton)object).getModel();
            ButtonStateListener buttonStateListener = new ButtonStateListener(timingController, triggerAction, (ButtonStateEvent)triggerEvent, buttonModel);
            this.setupListener(buttonModel, buttonStateListener, "addChangeListener", ChangeListener.class);
        }
        catch (Exception exception) {
            System.out.println("Exception creating change listener for object " + object + ": " + exception);
        }
    }

    private class ButtonStateListener
    extends TriggerListener
    implements ChangeListener {
        boolean armed;
        boolean rollover;
        ButtonStateEvent event;

        protected ButtonStateListener(TimingController timingController, Trigger.TriggerAction triggerAction, ButtonStateEvent buttonStateEvent, ButtonModel buttonModel) {
            super(timingController, triggerAction);
            this.event = buttonStateEvent;
            this.armed = buttonModel.isArmed();
            this.rollover = buttonModel.isRollover();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            boolean bl;
            ButtonModel buttonModel = (ButtonModel)changeEvent.getSource();
            boolean bl2 = this.armed != buttonModel.isArmed();
            boolean bl3 = bl = this.rollover != buttonModel.isRollover();
            if (bl2) {
                if (this.event == ButtonStateEvent.ARMED && buttonModel.isArmed() || this.event == ButtonStateEvent.DISARMED && !buttonModel.isArmed()) {
                    this.pullTrigger();
                }
                this.armed = buttonModel.isArmed();
            }
            if (bl) {
                if (this.event == ButtonStateEvent.ROLLOVER && buttonModel.isRollover() || this.event == ButtonStateEvent.ROLLOFF && !buttonModel.isRollover()) {
                    this.pullTrigger();
                }
                this.rollover = buttonModel.isRollover();
            }
        }
    }
}

