/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jdesktop.animation.timing.interpolation.KeyValuesColor;
import org.jdesktop.animation.timing.interpolation.KeyValuesDimension;
import org.jdesktop.animation.timing.interpolation.KeyValuesDouble;
import org.jdesktop.animation.timing.interpolation.KeyValuesFloat;
import org.jdesktop.animation.timing.interpolation.KeyValuesInt;
import org.jdesktop.animation.timing.interpolation.KeyValuesPoint;
import org.jdesktop.animation.timing.interpolation.KeyValuesRectangle;

public abstract class KeyValues<T> {
    protected ArrayList<T> values = new ArrayList();
    protected Object startValue;

    protected KeyValues() {
    }

    protected KeyValues(Object[] objectArray) {
        if (objectArray.length == 1) {
            this.values.add(null);
        }
    }

    protected KeyValues(float[] fArray) {
        if (fArray.length == 1) {
            this.values.add(null);
        }
    }

    protected KeyValues(int[] nArray) {
        if (nArray.length == 1) {
            this.values.add(null);
        }
    }

    protected KeyValues(double[] dArray) {
        if (dArray.length == 1) {
            this.values.add(null);
        }
    }

    public int getSize() {
        return this.values.size();
    }

    public static KeyValues createKeyValues(int ... nArray) {
        return new KeyValuesInt(nArray);
    }

    public static KeyValues createKeyValues(float ... fArray) {
        return new KeyValuesFloat(fArray);
    }

    public static KeyValues createKeyValues(double ... dArray) {
        return new KeyValuesDouble(dArray);
    }

    public static KeyValues createKeyValues(Point ... pointArray) {
        return new KeyValuesPoint(pointArray);
    }

    public static KeyValues createKeyValues(Dimension ... dimensionArray) {
        return new KeyValuesDimension(dimensionArray);
    }

    public static KeyValues createKeyValues(Rectangle ... rectangleArray) {
        return new KeyValuesRectangle(rectangleArray);
    }

    public static KeyValues createKeyValues(Color ... colorArray) {
        return new KeyValuesColor(colorArray);
    }

    public abstract Class<?> getType();

    public void setStartValue(Object object) {
        if (this.isToAnimation()) {
            this.startValue = object;
        }
    }

    boolean isToAnimation() {
        return this.values.get(0) == null;
    }

    public abstract void setValue(Object var1, Method var2, int var3, int var4, float var5);

    public abstract void setValue(Object var1, Method var2, int var3);
}

