/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Timer;
import org.jdesktop.animation.timing.Cycle;
import org.jdesktop.animation.timing.Envelope;
import org.jdesktop.animation.timing.TimingEvent;
import org.jdesktop.animation.timing.TimingListener;
import org.jdesktop.animation.timing.TimingTarget;

public class TimingController
implements TimingTarget {
    private Timer timer;
    private ArrayList<TimingTarget> targets = new ArrayList();
    private long startTime;
    private long currentStartTime;
    private int currentCycle = 0;
    private Direction direction = Direction.FORWARD;
    private boolean intRepeatCount;
    private ArrayList<TimingListener> listeners = new ArrayList();
    private Envelope envelope;
    private Cycle cycle;
    private float acceleration = 0.0f;
    private float deceleration = 0.0f;
    public static final int INFINITE = -1;

    public TimingController(Cycle cycle, Envelope envelope) {
        this(cycle, envelope, null);
    }

    public TimingController(Cycle cycle, Envelope envelope, TimingTarget timingTarget) {
        this.cycle = cycle;
        this.envelope = envelope;
        if (timingTarget != null) {
            this.targets.add(timingTarget);
        }
        this.intRepeatCount = Math.rint(envelope.getRepeatCount()) == envelope.getRepeatCount();
        TimerTarget timerTarget = new TimerTarget();
        this.timer = new Timer(cycle.getResolution(), timerTarget);
        this.timer.setInitialDelay(envelope.getBegin());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
    }

    public TimingController(int n, TimingTarget timingTarget) {
        this(new Cycle(n, 10), new Envelope(1.0, 0, Envelope.RepeatBehavior.FORWARD, Envelope.EndBehavior.HOLD), timingTarget);
    }

    public void setAcceleration(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Acceleration value cannot lie outside [0,1] range");
        }
        if (f > 1.0f - this.deceleration) {
            throw new IllegalArgumentException("Acceleration value cannot be greater than (1 - deceleration)");
        }
        this.acceleration = f;
    }

    public void setDeceleration(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Deceleration value cannot lie outside [0,1] range");
        }
        if (f > 1.0f - this.acceleration) {
            throw new IllegalArgumentException("Deceleration value cannot be greater than (1 - acceleration)");
        }
        this.deceleration = f;
    }

    public float getAcceleration() {
        return this.acceleration;
    }

    public float getDeceleration() {
        return this.deceleration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTarget(TimingTarget timingTarget) {
        if (timingTarget != null) {
            ArrayList<TimingTarget> arrayList = this.targets;
            synchronized (arrayList) {
                this.targets.add(timingTarget);
            }
        }
    }

    public void addTimingListener(TimingListener timingListener) {
        if (timingListener != null) {
            this.listeners.add(timingListener);
        }
    }

    public Cycle getCycle() {
        return this.cycle;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public void setCycle(Cycle cycle) {
        this.cycle = cycle;
        this.timer.setDelay(cycle.getResolution());
    }

    public void setEnvelope(Envelope envelope) {
        this.envelope = envelope;
    }

    public void start() {
        this.begin();
        this.currentStartTime = this.startTime = System.nanoTime() / 1000000L + (long)this.envelope.getBegin();
        this.timer.start();
    }

    public boolean isRunning() {
        return this.timer.isRunning();
    }

    public void stop() {
        this.timer.stop();
        this.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timingEvent(long l, long l2, float f) {
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            for (int i = 0; i < this.targets.size(); ++i) {
                TimingTarget timingTarget = this.targets.get(i);
                timingTarget.timingEvent(l, l2, f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin() {
        Object object;
        int n;
        ArrayList<Object> arrayList = this.targets;
        synchronized (arrayList) {
            for (n = 0; n < this.targets.size(); ++n) {
                object = this.targets.get(n);
                object.begin();
            }
        }
        arrayList = this.listeners;
        synchronized (arrayList) {
            for (n = 0; n < this.listeners.size(); ++n) {
                object = this.listeners.get(n);
                object.timerStarted(new TimingEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        Object object;
        int n;
        ArrayList<Object> arrayList = this.targets;
        synchronized (arrayList) {
            for (n = 0; n < this.targets.size(); ++n) {
                object = this.targets.get(n);
                object.end();
            }
        }
        arrayList = this.listeners;
        synchronized (arrayList) {
            for (n = 0; n < this.listeners.size(); ++n) {
                object = this.listeners.get(n);
                object.timerStopped(new TimingEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void repeat() {
        ArrayList<TimingListener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                TimingListener timingListener = this.listeners.get(i);
                timingListener.timerRepeated(new TimingEvent(this));
            }
        }
    }

    private void timingEventPreprocessor(long l, long l2, float f) {
        if (this.acceleration != 0.0f || this.deceleration != 0.0f) {
            float f2 = f;
            float f3 = 1.0f / (1.0f - this.acceleration / 2.0f - this.deceleration / 2.0f);
            if (f < this.acceleration) {
                float f4 = f3 * (f / this.acceleration) / 2.0f;
                f *= f4;
            } else if (f > 1.0f - this.deceleration) {
                float f5 = f - (1.0f - this.deceleration);
                float f6 = f5 / this.deceleration;
                f = f3 * (1.0f - this.acceleration / 2.0f - this.deceleration + f5 * (2.0f - f6) / 2.0f);
            } else {
                f = f3 * (f - this.acceleration / 2.0f);
            }
            if (f < 0.0f) {
                f = 0.0f;
            } else if (f > 1.0f) {
                f = 1.0f;
            }
        }
        this.timingEvent(l, l2, f);
    }

    private class TimerTarget
    implements ActionListener {
        private TimerTarget() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            long l = System.nanoTime() / 1000000L;
            long l2 = l - TimingController.this.currentStartTime;
            long l3 = l - TimingController.this.startTime;
            double d = (double)l3 / (double)TimingController.this.cycle.getDuration();
            if (TimingController.this.envelope.getRepeatCount() != -1.0 && d >= TimingController.this.envelope.getRepeatCount()) {
                switch (TimingController.this.envelope.getEndBehavior()) {
                    case HOLD: {
                        float f = TimingController.this.intRepeatCount ? (TimingController.this.direction == Direction.BACKWARD ? 0.0f : 1.0f) : Math.min(1.0f, (float)l2 / (float)TimingController.this.cycle.getDuration());
                        TimingController.this.timingEventPreprocessor(l2, l3, f);
                        break;
                    }
                    case RESET: {
                        TimingController.this.timingEventPreprocessor(l2, l3, 0.0f);
                    }
                }
                TimingController.this.stop();
            } else if (TimingController.this.cycle.getDuration() != -1 && l2 > (long)TimingController.this.cycle.getDuration()) {
                long l4 = l2 % (long)TimingController.this.cycle.getDuration();
                float f = (float)l4 / (float)TimingController.this.cycle.getDuration();
                TimingController.this.currentStartTime = l - l4;
                if (TimingController.this.envelope.getRepeatBehavior() == Envelope.RepeatBehavior.REVERSE) {
                    boolean bl;
                    boolean bl2 = bl = (int)(l2 / (long)TimingController.this.cycle.getDuration()) % 2 > 0;
                    if (bl) {
                        TimingController.this.direction = TimingController.this.direction == Direction.FORWARD ? Direction.BACKWARD : Direction.FORWARD;
                    }
                    if (TimingController.this.direction == Direction.BACKWARD) {
                        f = 1.0f - f;
                    }
                }
                TimingController.this.timingEventPreprocessor(l4, l3, f);
                TimingController.this.repeat();
            } else {
                float f = 0.0f;
                if (TimingController.this.cycle.getDuration() != -1) {
                    f = (float)l2 / (float)TimingController.this.cycle.getDuration();
                    if (TimingController.this.direction == Direction.BACKWARD) {
                        f = 1.0f - f;
                    }
                    f = Math.min(f, 1.0f);
                    f = Math.max(f, 0.0f);
                }
                TimingController.this.timingEventPreprocessor(l2, l3, f);
            }
        }
    }

    public static enum Direction {
        FORWARD,
        BACKWARD;

    }
}

