/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.tree.lazy;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.javatools.ui.tree.lazy.LazyProgressNode;

public final class LazyProgressController {
    private Set<LazyProgressNode> fetchingNodes = new HashSet<LazyProgressNode>();
    private transient Set<PropertyChangeListener> propertyChangeListeners = new CopyOnWriteArraySet<PropertyChangeListener>();
    private JTree tree;
    public static final String PROPERTY_PROGRESS_ACTIVE = "progressActive";

    public LazyProgressController(JTree tree) {
        this.tree = tree;
    }

    synchronized void addFetchingNode(LazyProgressNode node) {
        this.fetchingNodes.add(node);
        if (this.fetchingNodes.size() > 0) {
            this.fireProgressChange(true);
        }
    }

    synchronized void removeFetchingNode(LazyProgressNode node) {
        this.fetchingNodes.remove(node);
        if (this.fetchingNodes.size() == 0) {
            this.fireProgressChange(false);
        }
    }

    public void cancelProgress() {
        for (Object o : this.fetchingNodes.toArray()) {
            LazyProgressNode lazyProgressNode = (LazyProgressNode)o;
            lazyProgressNode.cancel();
            MutableTreeNode parent = (MutableTreeNode)lazyProgressNode.getParent();
            lazyProgressNode.removeFromParent();
            DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
            TreePath path = new TreePath(model.getPathToRoot(parent));
            this.tree.collapsePath(path);
            parent.insert(lazyProgressNode, 0);
        }
    }

    public synchronized boolean isProgressActive() {
        return this.fetchingNodes.size() > 0;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    private void fireProgressChange(boolean progressActive) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, PROPERTY_PROGRESS_ACTIVE, !progressActive, progressActive);
        Iterator<PropertyChangeListener> iterator = this.propertyChangeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().propertyChange(evt);
        }
    }
}

