/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.tree;

import java.awt.Component;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ReflectiveTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Method textMethod;
    private Object[] textParameterValues;
    private Class[] textParameterClasses;
    private String textMethodName;
    private Method iconMethod;
    private Object[] iconParameterValues;
    private Class[] iconParameterClasses;
    private String iconMethodName;

    public ReflectiveTreeCellRenderer(String textMethodName) {
        this.textMethodName = textMethodName;
    }

    public ReflectiveTreeCellRenderer(String textMethodName, Class[] textParameterClasses, Object[] textParameterValues) {
        this.textMethodName = textMethodName;
        this.textParameterClasses = textParameterClasses;
        this.textParameterValues = textParameterValues;
    }

    public ReflectiveTreeCellRenderer(String textMethodName, String iconMethodName) {
        this.textMethodName = textMethodName;
        this.iconMethodName = iconMethodName;
    }

    public ReflectiveTreeCellRenderer(String textMethodName, Class[] textParameterClasses, Object[] textParameterValues, String iconMethodName, Class[] iconParameterClasses, Object[] iconParameterValues) {
        this.textMethodName = textMethodName;
        this.textParameterClasses = textParameterClasses;
        this.textParameterValues = textParameterValues;
        this.iconMethodName = iconMethodName;
        this.iconParameterClasses = iconParameterClasses;
        this.iconParameterValues = iconParameterValues;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, cellHasFocus);
        try {
            Object ret;
            if (this.textMethod == null && this.textMethodName != null && value != null) {
                this.textMethod = value.getClass().getMethod(this.textMethodName, this.textParameterClasses);
            }
            if (this.iconMethod == null && this.iconMethodName != null && value != null) {
                this.iconMethod = value.getClass().getMethod(this.iconMethodName, this.iconParameterClasses);
            }
            if (this.textMethod != null && (ret = this.textMethod.invoke(value, this.textParameterValues)) != null) {
                label.setText(ret.toString());
            }
            if (this.iconMethod != null && (ret = this.iconMethod.invoke(value, this.iconParameterValues)) != null) {
                label.setIcon((Icon)ret);
            }
        }
        catch (Exception e) {
            Logger.getLogger("global").log(Level.SEVERE, "Cannot render tree item: " + value, e);
        }
        return label;
    }
}

