/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.themes;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.javatools.ui.themes.Theme;
import oracle.javatools.ui.themes.ThemeEvent;
import oracle.javatools.ui.themes.ThemeListener;

public final class Themes {
    private static Theme _activeTheme;
    private static Theme _defaultTheme;
    private static CopyOnWriteArrayList<ThemeListener> _listeners;

    private Themes() {
    }

    public static void addThemeListener(ThemeListener tl) {
        if (tl == null) {
            throw new NullPointerException("tl is null");
        }
        _listeners.add(tl);
    }

    public static void removeThemeListener(ThemeListener tl) {
        _listeners.remove(tl);
    }

    private static void fireThemeChanged() {
        ThemeEvent e = new ThemeEvent(Themes.class);
        for (ThemeListener tl : _listeners) {
            tl.themeChanged(e);
        }
    }

    public static boolean isThemed() {
        return _activeTheme != null;
    }

    public static Theme getActiveTheme() {
        return _activeTheme == null ? Themes.getDefaultTheme() : _activeTheme;
    }

    public static void setActiveTheme(Theme t) {
        _activeTheme = t;
        Themes.fireThemeChanged();
    }

    public static void setDefaultTheme(Theme t) {
        _defaultTheme = t;
    }

    private static Theme getDefaultTheme() {
        if (_defaultTheme == null) {
            return new Theme(new Properties());
        }
        return _defaultTheme;
    }

    public static void paintBackground(Graphics g, String part, String state, Rectangle rect) {
        Themes.getActiveTheme().getStateProperties(part, state).getPainter("bg").paint(g, rect.x, rect.y, rect.width, rect.height);
    }

    static {
        _listeners = new CopyOnWriteArrayList();
    }
}

