/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.simplestyle;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import javax.swing.UIManager;

public class StyledTextAttribute {
    private HashMap<AttributeType, Object> attrMap = new HashMap();
    public static final StyledTextAttribute defaultStyledTextAttribute = new StyledTextAttribute();

    public StyledTextAttribute() {
        this.attrMap.put(AttributeType.FONT, UIManager.getFont("Label.font"));
        this.attrMap.put(AttributeType.FOREGROUND, UIManager.getColor("Label.foreground"));
    }

    public StyledTextAttribute(Font font, Color foreground) {
        this.attrMap.put(AttributeType.FONT, font);
        this.attrMap.put(AttributeType.FOREGROUND, foreground);
    }

    public Object getAttribute(AttributeType type) {
        return this.attrMap.get((Object)type);
    }

    public void addAttribute(AttributeType type, Object value) {
        this.attrMap.put(type, value);
    }

    public String toString() {
        String s = this.attrMap.toString();
        return s;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StyledTextAttribute)) {
            return false;
        }
        return this.attrMap.equals(((StyledTextAttribute)o).attrMap);
    }

    public int hashCode() {
        return this.attrMap.hashCode();
    }

    public static enum AttributeType {
        FONT,
        FOREGROUND;

    }
}

