/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.segmented;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;
import oracle.javatools.ui.segmented.SegmentButton;
import oracle.javatools.ui.segmented.SegmentedControl;

public class SegmentedControlUI
extends PanelUI {
    private static final SegmentedControlUI ui = new SegmentedControlUI();
    private static int CORNER_ARC = 8;
    private static Stroke thinStroke = new BasicStroke(0.5f);
    private static Stroke thickStroke = new BasicStroke(1.0f);
    private static Stroke thickerStroke = new BasicStroke(1.5f);
    private final Color dark = new Color(0, 0, 0, 70);
    private final Color light = new Color(0, 0, 0, 0);
    private int lastHeight = 0;
    private Paint backgroundPaint;

    private SegmentedControlUI() {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SegmentedControl sc = (SegmentedControl)c;
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.lastHeight != sc.getHeight()) {
            this.lastHeight = sc.getHeight();
            this.backgroundPaint = new GradientPaint(0.0f, 0.0f, new Color(0, 0, 0, 0), 0.0f, sc.getHeight(), new Color(0, 0, 0, 50));
        }
        if (sc.hasFocus() && sc.getSelectionType() == SegmentedControl.SelectionType.SINGLE) {
            this.paintFocusBorder(g2, sc);
        }
        this.paintBackground(g2, sc);
        this.paintSelection(g2, sc);
        this.paintInterSegmentDividers(g2, sc);
        this.paintBorder(g2, sc);
        if (sc.hasFocus() && sc.getSelectionType() == SegmentedControl.SelectionType.MULTIPLE) {
            this.paintSegmentFocusBorder(g2, sc);
        }
    }

    protected void paintBackground(Graphics2D g2, SegmentedControl sc) {
        g2.setColor(sc.getBackground());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Paint paint = g2.getPaint();
        g2.setPaint(this.backgroundPaint);
        g2.fillRoundRect(1, 1, sc.getWidth() - 3, sc.getHeight() - 3, CORNER_ARC, CORNER_ARC);
        g2.setPaint(paint);
    }

    protected void paintSelection(Graphics2D g2, SegmentedControl sc) {
        SegmentButton b = (SegmentButton)sc.getComponent(0);
        g2.setColor(UIManager.getColor("List.selectionBackground"));
        int h = sc.getHeight() - 3;
        if (b.isSelected() || b.getModel().isArmed()) {
            if (b.isSelected()) {
                g2.fillRoundRect(2, 1, b.getX() + b.getWidth() - 1, h, CORNER_ARC, CORNER_ARC);
                g2.fillRect(CORNER_ARC + 1, 1, b.getX() + b.getWidth() - CORNER_ARC - 2, h);
            }
            this.depressedEdgePaint(g2, 2, 1, b.getX() + b.getWidth() - 1, h);
        }
        for (int i = 1; i < sc.getComponentCount() - 1; ++i) {
            b = (SegmentButton)sc.getComponent(i);
            if (!b.isSelected() && !b.getModel().isArmed()) continue;
            if (b.isSelected()) {
                g2.fillRect(b.getX(), 1, b.getWidth(), h);
            }
            this.depressedEdgePaint(g2, b.getX(), 1, b.getWidth(), h);
        }
        b = (SegmentButton)sc.getComponent(sc.getComponentCount() - 1);
        if (b.isSelected() || b.getModel().isArmed()) {
            if (b.isSelected()) {
                g2.fillRoundRect(b.getX(), 1, sc.getWidth() - 3 - b.getX(), h, CORNER_ARC, CORNER_ARC);
                g2.fillRect(b.getX(), 1, b.getWidth(), h);
            }
            this.depressedEdgePaint(g2, b.getX(), 1, b.getWidth(), h);
        }
    }

    private void depressedEdgePaint(Graphics2D g2, int x, int y, int width, int height) {
        int depth = 3;
        GradientPaint leftPaint = new GradientPaint(x, y, this.dark, x + depth, y, this.light);
        GradientPaint rightPaint = new GradientPaint(x + width - depth, y, this.light, x + width, y, this.dark);
        GradientPaint topPaint = new GradientPaint(x, y, this.dark, x, y + depth, this.light);
        GradientPaint bottomPaint = new GradientPaint(x, y + height - depth, this.light, x, y + height, this.dark);
        Paint paint = g2.getPaint();
        g2.setPaint(leftPaint);
        g2.fillRect(x, y, depth, height);
        g2.setPaint(rightPaint);
        g2.fillRect(x + width - depth, y, depth, height);
        g2.setPaint(topPaint);
        g2.fillRect(x, y, width, depth);
        g2.setPaint(bottomPaint);
        g2.fillRect(x, y + height - depth, width, depth);
        g2.setPaint(paint);
    }

    protected void paintInterSegmentDividers(Graphics2D g2, SegmentedControl sc) {
        g2.setStroke(thinStroke);
        g2.setColor(UIManager.getColor("Button.foreground"));
        for (int i = 1; i < sc.getComponentCount(); ++i) {
            Component comp = sc.getComponent(i);
            int x = comp.getX() - 1;
            g2.drawLine(x, 1, x, sc.getHeight() - 3);
        }
    }

    protected void paintFocusBorder(Graphics2D g2, SegmentedControl sc) {
        g2.setColor(UIManager.getColor("Button.focus"));
        g2.setStroke(thickStroke);
        g2.drawRoundRect(0, 0, sc.getWidth() - 1, sc.getHeight() - 1, CORNER_ARC, CORNER_ARC);
    }

    protected void paintSegmentFocusBorder(Graphics2D g2, SegmentedControl sc) {
        g2.setColor(UIManager.getColor("Button.focus"));
        g2.setStroke(thickerStroke);
        SegmentButton b = (SegmentButton)sc.getComponent(0);
        int h = sc.getHeight() - 3;
        if (b.hasFocus()) {
            g2.drawLine(b.getX() + b.getWidth() - 1, 1, b.getX() + b.getWidth() - 1, h);
            Shape clip = g2.getClip();
            g2.setClip(0, 0, b.getX() + b.getWidth() + 1, sc.getHeight());
            g2.drawRoundRect(1, 1, sc.getWidth() - 3, sc.getHeight() - 3, CORNER_ARC, CORNER_ARC);
            g2.setClip(clip);
        }
        for (int i = 1; i < sc.getComponentCount() - 1; ++i) {
            b = (SegmentButton)sc.getComponent(i);
            if (!b.hasFocus()) continue;
            g2.drawRect(b.getX(), 1, b.getWidth(), h);
        }
        b = (SegmentButton)sc.getComponent(sc.getComponentCount() - 1);
        if (b.hasFocus()) {
            g2.drawLine(b.getX(), 1, b.getX(), h);
            Shape clip = g2.getClip();
            g2.setClip(b.getX() - 1, 0, b.getWidth() + 2, sc.getHeight());
            g2.drawRoundRect(1, 1, sc.getWidth() - 3, sc.getHeight() - 3, CORNER_ARC, CORNER_ARC);
            g2.setClip(clip);
        }
    }

    protected void paintBorder(Graphics2D g2, SegmentedControl sc) {
        g2.setStroke(thinStroke);
        g2.setColor(UIManager.getColor("Button.foreground"));
        g2.drawRoundRect(1, 1, sc.getWidth() - 3, sc.getHeight() - 3, CORNER_ARC, CORNER_ARC);
    }

    public static ComponentUI createUI(JComponent c) {
        return ui;
    }
}

