/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.list;

import java.awt.Color;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import oracle.javatools.ui.Colors;

public class RolloverRenderer
implements ListCellRenderer {
    private MouseL mouseL = new MouseL();
    private int rolloverCell = -1;
    private Color bgRolloverUnselected;
    private Color bgRolloverSelected;
    private ListCellRenderer baseRenderer;

    public RolloverRenderer(JList list) {
        this(list, new DefaultListCellRenderer());
    }

    public RolloverRenderer(final JList list, ListCellRenderer baseRenderer) {
        this.baseRenderer = baseRenderer;
        list.addMouseMotionListener(this.mouseL);
        list.addMouseListener(this.mouseL);
        list.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                Point p = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(p, list);
                int oldLoc = RolloverRenderer.this.rolloverCell;
                RolloverRenderer.this.rolloverCell = list.locationToIndex(p);
                Rectangle bounds = list.getCellBounds(RolloverRenderer.this.rolloverCell, RolloverRenderer.this.rolloverCell);
                if (bounds == null || !bounds.contains(p)) {
                    RolloverRenderer.this.rolloverCell = -1;
                }
                RolloverRenderer.this.repaintCell(list, oldLoc);
                RolloverRenderer.this.repaintCell(list, RolloverRenderer.this.rolloverCell);
            }
        });
    }

    private void repaintCell(JList list, int index) {
        if (index != -1) {
            list.repaint(list.getCellBounds(index, index));
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JComponent comp = (JComponent)this.baseRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (index == this.rolloverCell) {
            if (isSelected) {
                comp.setBackground(Colors.CELL_ROLLOVER_SELECTION_HIGHLIGHT);
            } else {
                comp.setBackground(Colors.CELL_ROLLOVER_HIGHLIGHT);
            }
        }
        return comp;
    }

    private class MouseL
    extends MouseInputAdapter {
        private MouseL() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JList list = (JList)e.getSource();
            int old = RolloverRenderer.this.rolloverCell;
            RolloverRenderer.this.rolloverCell = -1;
            RolloverRenderer.this.repaintCell(list, old);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JList list = (JList)e.getSource();
            int old = RolloverRenderer.this.rolloverCell;
            Rectangle vRect = list.getVisibleRect();
            e.getPoint().translate(vRect.x, vRect.y);
            RolloverRenderer.this.rolloverCell = list.locationToIndex(e.getPoint());
            if (RolloverRenderer.this.rolloverCell != -1 && !list.getCellBounds(RolloverRenderer.this.rolloverCell, RolloverRenderer.this.rolloverCell).contains(e.getPoint())) {
                RolloverRenderer.this.rolloverCell = -1;
            }
            if (old != RolloverRenderer.this.rolloverCell) {
                RolloverRenderer.this.repaintCell(list, old);
                RolloverRenderer.this.repaintCell(list, RolloverRenderer.this.rolloverCell);
            }
        }
    }
}

