/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.internal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultTreeModel;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.ui.TriStateCellEditor;
import oracle.javatools.ui.TriStateCheckBox;
import oracle.javatools.ui.TriStateTableRenderer;
import oracle.javatools.ui.checktree.CheckboxTree;
import oracle.javatools.ui.checktree.TriStateNode;

final class UIDemoCheckBoxPanel
extends JPanel {
    UIDemoCheckBoxPanel() {
        this.init();
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("gapx 8px, gapy 2px"));
        this.add((Component)new JCheckBox("Regular JCheckbox"), "wrap");
        final TriStateCheckBox triCheck = new TriStateCheckBox("TriStateCheckbox");
        final JComboBox<String> combo = new JComboBox<String>(new String[]{"Make Selected", "Make Partial", "Make Unselected"});
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (combo.getSelectedIndex()) {
                    case 0: {
                        triCheck.setState(TriStateCheckBox.State.TRUE);
                        break;
                    }
                    case 1: {
                        triCheck.setState(TriStateCheckBox.State.PARTIAL);
                        break;
                    }
                    case 2: {
                        triCheck.setState(TriStateCheckBox.State.FALSE);
                    }
                }
            }
        });
        combo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (index == -1) {
                    label.setText("Choose State...");
                }
                return label;
            }
        });
        final JCheckBox disableCheckbox = new JCheckBox("Enabled", true);
        disableCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                triCheck.setEnabled(disableCheckbox.isSelected());
            }
        });
        final JCheckBox direction = new JCheckBox("Direction: True -> Partial -> False");
        direction.setSelected(triCheck.getDirection());
        direction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                triCheck.setDirection(direction.isSelected());
            }
        });
        final JCheckBox userSelect = new JCheckBox("Can User Cycle to Partial State");
        userSelect.setSelected(triCheck.canUserSetPartial());
        userSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                triCheck.setCanUserSetPartial(userSelect.isSelected());
            }
        });
        this.add((Component)triCheck, "split");
        this.add(combo, "");
        this.add((Component)disableCheckbox, "skip, wrap");
        this.add((Component)direction, "skip, wrap");
        this.add((Component)userSelect, "skip, wrap");
        this.add((Component)new JLabel("CheckboxTree:"), "gaptop 20px");
        this.add((Component)new JLabel("Table:"), "gaptop 20px, wrap");
        this.add(this.getCheckboxTree(), "");
        this.add((Component)this.getCheckboxTable(), "top, wrap");
    }

    private Component getCheckboxTree() {
        TriStateNode root = new TriStateNode("Lunch");
        TriStateNode sandwiches = new TriStateNode("Sandwiches");
        TriStateNode cheese = new TriStateNode("Cheese");
        TriStateNode beef = new TriStateNode("Beef");
        TriStateNode ham = new TriStateNode("Ham");
        root.add(sandwiches);
        sandwiches.add(cheese);
        sandwiches.add(beef);
        sandwiches.add(ham);
        cheese.add(new TriStateNode("With Pickle"));
        cheese.add(new TriStateNode("With Onion"));
        beef.add(new TriStateNode("With Mustard"));
        beef.add(new TriStateNode("With Horseradish"));
        beef.add(new TriStateNode("With Onions"));
        TriStateNode drink = new TriStateNode("Drinks");
        TriStateNode tea = new TriStateNode("Tea");
        TriStateNode cola = new TriStateNode("Cola");
        root.add(drink);
        drink.add(tea);
        drink.add(cola);
        tea.add(new TriStateNode("With Honey"));
        tea.add(new TriStateNode("With Sugar"));
        cola.add(new TriStateNode("Coke"));
        cola.add(new TriStateNode("Pepsi"));
        DefaultTreeModel model = new DefaultTreeModel(root);
        CheckboxTree tree = new CheckboxTree(model);
        for (int row = 0; tree.getRowCount() > row; ++row) {
            tree.expandRow(row);
        }
        JScrollPane sp = new JScrollPane(tree);
        sp.setPreferredSize(new Dimension(180, 320));
        return sp;
    }

    private JComponent getCheckboxTable() {
        DefaultTableModel model = new DefaultTableModel(1, 3){
            private boolean booleanState;
            private TriStateCheckBox.State triState;
            {
                this.booleanState = false;
                this.triState = TriStateCheckBox.State.FALSE;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return "Text";
                    }
                    case 1: {
                        return "JCheckBox";
                    }
                    case 2: {
                        return "TriStateCheckBox";
                    }
                }
                return super.getColumnName(column);
            }

            @Override
            public Object getValueAt(int row, int column) {
                switch (column) {
                    case 0: {
                        return "Check it out";
                    }
                    case 1: {
                        return this.booleanState;
                    }
                    case 2: {
                        return this.triState;
                    }
                }
                return 0;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                switch (column) {
                    case 1: {
                        this.booleanState = (Boolean)aValue;
                        return;
                    }
                    case 2: {
                        this.triState = (TriStateCheckBox.State)((Object)aValue);
                        return;
                    }
                }
            }

            @Override
            public Class<?> getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return Boolean.class;
                    }
                    case 2: {
                        return TriStateCheckBox.State.class;
                    }
                }
                return String.class;
            }
        };
        JTable table = new JTable(model);
        final TriStateCheckBox editorTSCB = new TriStateCheckBox();
        table.setDefaultRenderer(TriStateCheckBox.State.class, new TriStateTableRenderer());
        table.setDefaultEditor(TriStateCheckBox.State.class, new TriStateCellEditor(editorTSCB));
        table.setFillsViewportHeight(true);
        JScrollPane sp = new JScrollPane(table);
        sp.setPreferredSize(new Dimension(320, 36));
        final JCheckBox direction = new JCheckBox("Direction: True -> Partial -> False");
        direction.setSelected(editorTSCB.getDirection());
        direction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                editorTSCB.setDirection(direction.isSelected());
            }
        });
        final JCheckBox userSelect = new JCheckBox("Can User Cycle to Partial State");
        userSelect.setSelected(editorTSCB.canUserSetPartial());
        userSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                editorTSCB.setCanUserSetPartial(userSelect.isSelected());
            }
        });
        JPanel panel = new JPanel((LayoutManager)new MigLayout("wrap 1, insets 0"));
        panel.add((Component)sp, "");
        panel.add((Component)direction, "");
        panel.add((Component)userSelect, "");
        return panel;
    }
}

