/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.infotip.templates;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.ui.infotip.InfoTipSeparator;
import oracle.javatools.ui.infotip.templates.ActiveTemplate;
import oracle.javatools.ui.infotip.templates.BasicTemplate;
import oracle.javatools.ui.infotip.templates.ItemTemplate;

public final class MultiItemTemplate
extends BasicTemplate {
    private final ActionListener actionListener = new ItemActionListener();
    private final List<ItemTemplate> templates = new ArrayList<ItemTemplate>();
    private final List<JComponent> components = new ArrayList<JComponent>();
    private final List<JComponent> separators = new ArrayList<JComponent>();

    public MultiItemTemplate(List<? extends ItemTemplate> templates) {
        super(new JPanel((LayoutManager)new MigLayout("flowy, fill, ins 1, gap 0")));
        this.content.setOpaque(false);
        this.templates.addAll(templates);
        for (ItemTemplate template : this.templates) {
            if (!this.components.isEmpty()) {
                InfoTipSeparator separator = new InfoTipSeparator();
                this.content.add((Component)separator, "growx, growy 0, h 3, gapy 6");
                this.separators.add(separator);
            }
            JComponent component = template.getContent();
            this.content.add((Component)component, "grow, w 100%");
            this.components.add(component);
            template.addActionListener(this.actionListener);
        }
        this.doSizing();
    }

    private void doSizing() {
        int width = 0;
        for (ItemTemplate template : this.templates) {
            int labelWidth = template.getPreferredWidth();
            width = Math.max(labelWidth, width);
        }
        width = Math.max(width, 400);
        for (ItemTemplate template : this.templates) {
            template.setPreferredWidth(width);
        }
    }

    private class ItemActionListener
    implements ActionListener {
        private ItemActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActiveTemplate template = (ActiveTemplate)e.getSource();
            if ("closeActionCommand".equals(e.getActionCommand())) {
                int index = MultiItemTemplate.this.templates.indexOf(template);
                if (index != -1) {
                    MultiItemTemplate.this.templates.remove(index);
                    MultiItemTemplate.this.content.remove((Component)MultiItemTemplate.this.components.get(index));
                    MultiItemTemplate.this.components.remove(index);
                    if (MultiItemTemplate.this.components.isEmpty()) {
                        MultiItemTemplate.this.fireActionPerformed("closeActionCommand");
                    } else {
                        int si = index == 0 ? 0 : index - 1;
                        MultiItemTemplate.this.content.remove((Component)MultiItemTemplate.this.separators.get(si));
                        MultiItemTemplate.this.separators.remove(si);
                        MultiItemTemplate.this.fireActionPerformed("sizeChangedCommand");
                    }
                }
            } else if ("closeInfotipCommand".equals(e.getActionCommand())) {
                MultiItemTemplate.this.fireActionPerformed("closeInfotipCommand");
            } else if ("sizeChangedCommand".equals(e.getActionCommand())) {
                MultiItemTemplate.this.doSizing();
                MultiItemTemplate.this.fireActionPerformed("sizeChangedCommand");
            }
        }
    }
}

