/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.infotip;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.Hoverable;
import oracle.ide.hover.HoverableRegistry;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BasicTemplate;
import oracle.javatools.ui.infotip.templates.Template;

public final class InfoTipHoverFactory {
    private InfoTipHoverFactory() {
    }

    public static InfoTipHover fromComponent(JComponent parent, JComponent content, Rectangle location) {
        HoverableImpl hoverableImpl = new HoverableImpl(parent, content, location);
        return hoverableImpl.getInfoTipHover();
    }

    public static InfoTipHover fromComponent(JComponent parent, JComponent content) {
        return InfoTipHoverFactory.fromComponent(parent, content, parent.getBounds());
    }

    public static InfoTipHover fromTemplate(JComponent parent, Template template) {
        return InfoTipHoverFactory.fromTemplate(parent, template, null);
    }

    public static InfoTipHover fromTemplate(JComponent parent, Template template, Rectangle location) {
        HoverableImpl hoverableImpl = new HoverableImpl(parent, template, location);
        return hoverableImpl.getInfoTipHover();
    }

    public static InfoTipHover forTable(JTable table, TableInfoTipProvider tableInfoTipProvider) {
        TableHoverableImpl hoverableImpl = new TableHoverableImpl(table, tableInfoTipProvider, null);
        return hoverableImpl.getInfoTipHover();
    }

    public static interface TableInfoTipProvider {
        public Template getTipContentForCell(JTable var1, int var2, int var3, Point var4, List<HoverFlavor> var5);
    }

    private static class TableHoverableImpl
    extends HoverableImpl {
        private final TableInfoTipProvider provider;
        private final JTable table;

        TableHoverableImpl(JTable table, TableInfoTipProvider provider, Rectangle location) {
            super((JComponent)table, new JLabel("Placeholder"), location);
            this.provider = provider;
            this.table = table;
        }

        @Override
        public Hover hover(Point point, List<HoverFlavor> flavors) {
            Point p = new Point(point);
            SwingUtilities.convertPointFromScreen(p, this.table);
            int row = this.table.rowAtPoint(p);
            int col = this.table.columnAtPoint(p);
            if (row == -1 || col == -1) {
                return null;
            }
            Template template = this.provider.getTipContentForCell(this.table, row, col, p, flavors);
            if (template == null) {
                return null;
            }
            this.infoTipHover.setContent(template);
            this.infoTipHover.showHover();
            this.infoTipHover.setLocation(this.table.getCellRect(row, col, false));
            return this.infoTipHover;
        }
    }

    private static class HoverableImpl
    implements Hoverable {
        protected final JComponent parent;
        protected Rectangle r;
        protected InfoTipHover infoTipHover;

        HoverableImpl(JComponent parent, JComponent content, Rectangle r) {
            this(parent, new BasicTemplate(content), r);
        }

        HoverableImpl(JComponent parent, Template template, Rectangle r) {
            this.parent = parent;
            this.r = r;
            this.initialize(template);
        }

        private void initialize(Template template) {
            if (this.r == null) {
                this.r = new Rectangle(0, 0, this.parent.getWidth(), this.parent.getHeight());
            }
            this.infoTipHover = new InfoTipHover(template, InfoTipStyles.DEFAULT, this.parent, this.r, HoverFlavor.getFlavor((String)"info"));
            AncestorListener listener = new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    HoverableRegistry.registerComponent((Component)parent, (Hoverable)this);
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    HoverableRegistry.unregisterComponent((Component)parent, (Hoverable)this);
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }
            };
            this.parent.addAncestorListener(listener);
            if (this.parent.isShowing()) {
                HoverableRegistry.registerComponent((Component)this.parent, (Hoverable)this);
            }
        }

        public Hover hover(Point p, List<HoverFlavor> flavors) {
            if (this.infoTipHover.isEnabled()) {
                this.infoTipHover.setLocation(this.r);
                this.infoTipHover.showHover();
                return this.infoTipHover;
            }
            return null;
        }

        InfoTipHover getInfoTipHover() {
            return this.infoTipHover;
        }
    }

    public static interface LazyContent {
        public JComponent createContent();
    }
}

