/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.javatools.ui.completion.CompletionProvider;

public final class StringCompletionProvider
implements CompletionProvider<String> {
    public final DefaultListCellRenderer renderer = new DefaultListCellRenderer();
    private List<String> strings = new ArrayList<String>();

    public StringCompletionProvider(Collection<String> strings) {
        this.strings.addAll(strings);
    }

    @Override
    public ListCellRenderer getCellRenderer() {
        return this.renderer;
    }

    @Override
    public boolean handlesInsight(Document doc, int pos) {
        return true;
    }

    public String[] getInsightData(Document doc, int pos) {
        ArrayList<String> matches = new ArrayList<String>();
        try {
            String prefix = doc.getText(0, pos).toLowerCase();
            for (String s : this.strings) {
                if (!s.toLowerCase().startsWith(prefix)) continue;
                matches.add(s);
            }
        }
        catch (BadLocationException e) {
            return new String[0];
        }
        return matches.toArray(new String[matches.size()]);
    }

    @Override
    public void completeInsight(Document doc, int pos, String insightObject) {
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(0, insightObject, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public boolean isAutoPopupChar(char c) {
        return true;
    }
}

