/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.calendar;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.time.LocalDate;
import java.time.Month;
import java.time.format.TextStyle;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;
import oracle.javatools.ui.calendar.CalendarModel;

final class MonthComponent
extends JComboBox<Month>
implements ItemListener {
    private final CalendarModel model;

    public MonthComponent(CalendarModel model) {
        this.model = model;
        for (Month month : Month.values()) {
            this.addItem(month);
        }
        this.setRenderer(new MonthRenderer());
        this.addItemListener(this);
        this.updateDisplay();
        this.setBackground(UIManager.getColor("TextArea.background"));
        this.setOpaque(false);
        model.addPropertyChangeListener(evt -> this.updateDisplay());
    }

    @Override
    public void setLocale(Locale l) {
        super.setLocale(l);
        this.repaint();
    }

    public void updateDisplay() {
        this.setSelectedItem(this.model.getVisibleDate().getMonth());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        Month month = (Month)this.getSelectedItem();
        LocalDate newDate = this.model.getVisibleDate().withMonth(month.getValue());
        this.model.setVisibleDate(newDate);
    }

    private class MonthRenderer
    extends DefaultListCellRenderer {
        private MonthRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel monthLabel = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Month) {
                Month month = (Month)value;
                String text = month.getDisplayName(TextStyle.FULL, MonthComponent.this.getLocale());
                monthLabel.setText(text);
            }
            return monthLabel;
        }
    }
}

