/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.calendar;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.calendar.CalendarDateProvider;
import oracle.javatools.ui.calendar.CalendarModel;
import oracle.javatools.ui.calendar.DayComponent;
import oracle.javatools.ui.calendar.MonthComponent;
import oracle.javatools.ui.calendar.TimeDisplayPanel;
import oracle.javatools.ui.calendar.TimeEditPanel;
import oracle.javatools.ui.calendar.YearComponent;

public final class CalendarPanel
extends JPanel {
    public static final String DOUBLE_CLICK_COMMAND = "DOUBLE_CLICK_COMMAND";
    public static final String SELECTION_CHANGED_COMMAND = "SELECTION_CHANGED_COMMAND";
    private transient List<ActionListener> actionListeners = new CopyOnWriteArrayList<ActionListener>();
    private final CalendarModel model = new CalendarModel();
    private DayComponent dayPanel = new DayComponent(this.model);
    private MonthComponent monthPanel = new MonthComponent(this.model);
    private YearComponent yearPanel = new YearComponent(this.model);
    private TimeDisplayPanel timeDisplay = new TimeDisplayPanel(this.model);
    private TimeEditPanel timeEditor = new TimeEditPanel(this.model);
    private JButton previousButton;
    private JButton nextButton;
    private JButton todayButton;

    @Deprecated
    public CalendarPanel(Locale locale) {
        this();
        this.setLocale(locale);
    }

    public CalendarPanel() {
        this.createSubcomponents();
        this.layoutComponents();
        this.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), BorderFactory.createEmptyBorder(2, 4, 8, 4)));
        this.setBackground(UIManager.getColor("TextArea.background"));
        this.model.setSelectedDate(LocalDate.now());
        this.model.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("selectedDates")) {
                this.fireSelectionAction();
            }
        });
        this.model.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("showTime") || evt.getPropertyName().equals("editTime")) {
                this.layoutComponents();
            }
        });
    }

    @Override
    public void setLocale(Locale l) {
        super.setLocale(l);
        this.dayPanel.setLocale(l);
        this.monthPanel.setLocale(l);
        this.yearPanel.setLocale(l);
        this.timeDisplay.setLocale(l);
        this.timeEditor.setLocale(l);
    }

    public CalendarModel getModel() {
        return this.model;
    }

    private void createSubcomponents() {
        this.previousButton = new BasicArrowButton(7);
        this.nextButton = new BasicArrowButton(3);
        this.todayButton = new JButton(UIBundle.get("CALENDAR_TODAY"));
        this.previousButton.setBackground(UIManager.getColor("TextArea.background"));
        this.nextButton.setBackground(UIManager.getColor("TextArea.background"));
        this.previousButton.setOpaque(false);
        this.nextButton.setOpaque(false);
        this.todayButton.setOpaque(false);
        this.previousButton.setBorderPainted(false);
        this.previousButton.setAction(null);
        this.nextButton.setBorderPainted(false);
        ArrowButtonListener abl = new ArrowButtonListener();
        this.previousButton.addActionListener(abl);
        this.nextButton.addActionListener(abl);
        DoubleClickListener dcl = new DoubleClickListener();
        this.dayPanel.getTable().getGrid().addMouseListener((MouseListener)dcl);
        this.todayButton.addActionListener(e -> this.goToToday());
    }

    private void layoutComponents() {
        this.removeAll();
        this.setLayout((LayoutManager)new MigLayout("ins 4 2 0 2, nogrid"));
        this.add(this.previousButton);
        this.add(this.monthPanel);
        this.add(this.yearPanel);
        this.add(this.nextButton);
        this.add((Component)this.dayPanel, "newline, al center");
        this.dayPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("ComboBox.disabledBackground")));
        if (this.model.isShowTime()) {
            if (this.model.isEditTime()) {
                this.add((Component)this.timeEditor, "newline, gap 0 2 0 2, al center, growx");
            } else {
                this.add((Component)this.timeDisplay, "newline, gap 0 2 4 2, al center");
            }
        }
        if (this.model.isShowToday()) {
            this.add((Component)this.todayButton, "newline, gap 0 2 4 2, al center");
        }
    }

    @Deprecated
    public Date[] getSelectedDates() {
        return this.model.getSelectedDatesDeprecated();
    }

    public Set<ZonedDateTime> getDates() {
        return this.model.getSelectedDates();
    }

    @Deprecated
    public void setSelectedDate(Date date) {
        this.model.setSelectedDate(date);
        this.fireSelectionAction();
    }

    @Deprecated
    public void setTimeZone(TimeZone timeZone) {
        this.model.setZoneId(timeZone.toZoneId());
    }

    @Deprecated
    public TimeZone getTimeZone() {
        return TimeZone.getTimeZone(this.model.getZoneId());
    }

    public void setMultiSelect(boolean isMultiSelect) {
        this.model.setMultiSelect(isMultiSelect);
    }

    public boolean isMultiSelect() {
        return this.model.isMultiSelect();
    }

    @Deprecated
    public void setSelectedDates(Date[] dates) {
        this.model.setSelectedDatesDeprecated(dates);
    }

    @Deprecated
    public void addSelectedDates(Date[] dates) {
        for (Date d : dates) {
            LocalDate localDate = CalendarModel.dateToLocalDate(d);
            this.model.addSelectedDate(localDate);
        }
        this.fireSelectionAction();
    }

    @Deprecated
    public void removeSelectedDates(Date[] dates) {
        for (Date date : dates) {
            this.model.removeSelectedDate(CalendarModel.dateToLocalDate(date));
        }
    }

    @Deprecated
    public Date getVisibleDate() {
        return CalendarModel.localDateToDate(this.model.getVisibleDate());
    }

    @Deprecated
    public void makeDateVisible(Date date) {
        this.model.setVisibleDate(CalendarModel.dateToLocalDate(date));
    }

    @Deprecated
    public void setMinimumDate(Date minimumDate) {
        LocalDate localDate = minimumDate == null ? null : CalendarModel.dateToLocalDate(minimumDate);
        this.model.setMinDate(localDate);
    }

    @Deprecated
    public Date getMinimumDate() {
        return CalendarModel.localDateToDate(this.model.getMinDate());
    }

    @Deprecated
    public void setMaximumDate(Date maximumDate) {
        LocalDate localDate = maximumDate == null ? null : CalendarModel.dateToLocalDate(maximumDate);
        this.model.setMaxDate(localDate);
    }

    @Deprecated
    public Date getMaximumDate() {
        return CalendarModel.localDateToDate(this.model.getMaxDate());
    }

    @Deprecated
    public void setDateProvider(CalendarDateProvider calDateProvider) {
        this.model.setProvider(calDateProvider);
    }

    @Deprecated
    public CalendarDateProvider getDateProvider() {
        return this.model.getProvider();
    }

    public void setShowTime(boolean showTime) {
        this.model.setShowTime(showTime);
    }

    public boolean isShowingTime() {
        return this.model.isShowTime();
    }

    public void setShowToday(boolean showToday) {
        this.model.setShowToday(showToday);
    }

    public boolean isShowingToday() {
        return this.model.isShowToday();
    }

    public void setEditTime(boolean editTime) {
        this.model.setEditTime(editTime);
    }

    public boolean isEditingTime() {
        return this.model.isEditTime();
    }

    public void setShowTimeZone(boolean showTimeZone) {
        this.timeDisplay.setShowTimeZone(showTimeZone);
        this.timeEditor.setShowTimeZone(showTimeZone);
    }

    public boolean getShowTimeZone() {
        return this.timeDisplay.getShowTimeZone();
    }

    public void setVisibleDate(boolean visible) {
        this.dayPanel.setVisible(visible);
        this.monthPanel.setVisible(visible);
        this.yearPanel.setVisible(visible);
        this.previousButton.setVisible(visible);
        this.nextButton.setVisible(visible);
    }

    public void setVisibleTime(boolean visible) {
        if (visible && !this.model.isShowTime()) {
            this.setShowTime(true);
            this.setVisibleTimeZone(false);
        }
        this.timeDisplay.setShowTime(visible);
        this.timeEditor.setShowTime(visible);
    }

    public void setVisibleTimeZone(boolean visible) {
        if (visible && !this.model.isShowTime()) {
            this.setShowTime(true);
            this.setVisibleTime(false);
        }
        this.setShowTimeZone(visible);
    }

    @Deprecated
    public TimeZone getNearestTimeZone(TimeZone timeZone) {
        return timeZone;
    }

    @Deprecated
    public TimeZone getTimeZoneInList(TimeZone timeZone) {
        return timeZone;
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList<ActionListener>(2);
        }
        this.actionListeners.add(listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        if (this.actionListeners != null) {
            this.actionListeners.remove(listener);
        }
    }

    void fireSelectionAction() {
        ActionEvent e = new ActionEvent(this, 1001, SELECTION_CHANGED_COMMAND);
        for (ActionListener al : this.actionListeners) {
            al.actionPerformed(e);
        }
    }

    public void goToToday() {
        this.model.setSelectedDate(LocalDate.now());
        this.model.setVisibleDate(LocalDate.now());
    }

    void focusOnDay() {
        this.dayPanel.getTable().requestFocus();
    }

    private class ArrowButtonListener
    implements ActionListener {
        private ArrowButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LocalDate date = CalendarPanel.this.model.getVisibleDate();
            if (e.getSource() == CalendarPanel.this.previousButton) {
                date = date.minusMonths(1L);
            } else if (e.getSource() == CalendarPanel.this.nextButton) {
                date = date.plusMonths(1L);
            }
            CalendarPanel.this.model.setVisibleDate(date);
        }
    }

    private class DoubleClickListener
    extends MouseAdapter {
        private DoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (me.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(me)) {
                ActionEvent e = new ActionEvent(this, 1001, CalendarPanel.DOUBLE_CLICK_COMMAND);
                for (ActionListener al : CalendarPanel.this.actionListeners) {
                    al.actionPerformed(e);
                }
            }
        }
    }
}

