/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.text.Position;

public class SearchableList<E>
extends JList<E> {
    private static final long serialVersionUID = 1L;

    public SearchableList(ListModel<E> model) {
        super(model);
    }

    public SearchableList() {
    }

    @Override
    public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
        ListModel model = this.getModel();
        int max = model.getSize();
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (startIndex < 0 || startIndex >= max) {
            throw new IllegalArgumentException();
        }
        prefix = prefix.toUpperCase();
        int increment = bias == Position.Bias.Forward ? 1 : -1;
        int index = startIndex;
        do {
            String string;
            Object o;
            if ((o = model.getElementAt(index)) == null) continue;
            if (o instanceof String) {
                string = ((String)o).toUpperCase();
            } else {
                Component comp = this.getCellRenderer().getListCellRendererComponent(this, o, index, false, false);
                if (comp instanceof JLabel) {
                    string = ((JLabel)comp).getText().toUpperCase();
                } else {
                    string = o.toString();
                    if (string != null) {
                        string = string.toUpperCase();
                    }
                }
            }
            if (string == null || !string.startsWith(prefix)) continue;
            return index;
        } while ((index = (index + increment + max) % max) != startIndex);
        return -1;
    }
}

