/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.text.EditorKit;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.html.parser.ParserDelegator;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.javatools.ui.RichHintLabel;

public class RichDialogHeader
extends DialogHeader {
    private static final int _UI_IMAGE_HEIGHT = 40;
    private static final int _UI_IMAGE_WIDTH = 40;
    private static final int _HGAP = 15;
    private String _originalText;
    private JLabel _headerImageLabel;
    private RichHintLabel _headerDescription;

    public RichDialogHeader() {
        this.setLayout(new BorderLayout(15, 0));
    }

    public RichDialogHeader(String headerDescription, Image headerImage) {
        this();
        this.setHeaderDescription(headerDescription);
        this.setHeaderImage(headerImage);
    }

    public void setHeaderImage(Image image) {
        if (this._headerImageLabel == null) {
            if (image == null) {
                return;
            }
            this._headerImageLabel = new JLabel();
            this._headerImageLabel.setVerticalAlignment(1);
        }
        ImageIcon icon = null;
        if (image != null) {
            ImageUtils.loadImage((Image)image);
            icon = new ImageIcon(image);
        }
        this._headerImageLabel.setIcon(icon);
        this._checkHeader();
    }

    public Image getHeaderImage() {
        if (this._headerImageLabel == null) {
            return null;
        }
        Icon icon = this._headerImageLabel.getIcon();
        return icon == null ? null : ((ImageIcon)icon).getImage();
    }

    public void setHeaderDescription(String label) {
        if (this._headerDescription == null) {
            if (label == null || "".equals(label)) {
                return;
            }
            this._headerDescription = new RichHintLabel();
            this._configureRichHintLabel(this._headerDescription);
        }
        this._originalText = label;
        this._headerDescription.setHtmlText(label);
        this._checkHeader();
        this._setHeaderPreferredSize();
    }

    public String getHeaderDescription() {
        return this._headerDescription == null ? null : this._headerDescription.getHtmlText();
    }

    public String getOriginalDescription() {
        return this._originalText;
    }

    public void registerHintTextActions(String id, Action action) {
        if (this._headerDescription != null) {
            this._headerDescription.registerAction(id, action);
        }
    }

    public void registerHintTextActions(Map<String, Action> map) {
        if (this._headerDescription != null) {
            for (String key : map.keySet()) {
                this._headerDescription.registerAction(key, map.get(key));
            }
        }
    }

    private void _checkHeader() {
        if (this._headerImageLabel != null) {
            if (this._headerImageLabel.getIcon() == null) {
                this.remove(this._headerImageLabel);
            } else {
                this.add(this._headerImageLabel, "East");
            }
        }
        if (this._headerDescription != null) {
            String text = this._headerDescription.getHtmlText();
            if (text == null || "".equals(text)) {
                this.remove(this._headerDescription);
            } else {
                this.add(this._headerDescription, "Center");
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void _configureRichHintLabel(RichHintLabel label) {
        Color c;
        EditorKit kit = label.getEditorKit();
        if (kit instanceof HTMLEditorKit && (c = (Color)UIManager.getDefaults().get("Label.foreground")) != null) {
            StyleSheet style = ((HTMLEditorKit)kit).getStyleSheet();
            style.addRule("body{color: " + ColorUtils.colorToHTML((Color)c) + ";}");
        }
    }

    private void _setHeaderPreferredSize() {
        String htmlText = this.getHeaderDescription();
        if (htmlText == null || "".equals(htmlText)) {
            if (this._headerDescription != null) {
                this._headerDescription.setPreferredSize(null);
            }
            return;
        }
        StringReader reader = new StringReader(htmlText);
        final StringBuilder plainText = new StringBuilder(htmlText.length());
        HTMLEditorKit.ParserCallback callBack = new HTMLEditorKit.ParserCallback(){

            @Override
            public void handleText(char[] data, int pos) {
                plainText.append(data);
            }

            @Override
            public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (HTML.Tag.BR.equals(t)) {
                    plainText.append("\n");
                }
            }
        };
        ParserDelegator pd = new ParserDelegator();
        try {
            pd.parse(reader, callBack, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MultiLineLabel mll = new MultiLineLabel(WordWrapper.getTextWrapper(), plainText.toString());
        mll.setPreferredAspectRatio(9.7f);
        mll.setVerticalShrinking(true);
        this._headerDescription.setPreferredSize(mll.getPreferredSize());
    }
}

