/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public final class InputInfo {
    private static Listener listener = new Listener();
    private static boolean initialized = false;
    private static boolean controlDown;
    private static boolean altDown;
    private static boolean shiftDown;
    private static boolean altGraphDown;
    private static boolean metaDown;
    private static boolean dragging;
    private static boolean button1Down;
    private static boolean button2Down;
    private static boolean button3Down;

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, 56L);
    }

    public static final boolean isControlDown() {
        return controlDown;
    }

    public static final boolean isAltDown() {
        return altDown;
    }

    public static final boolean isShiftDown() {
        return shiftDown;
    }

    public static final boolean isAltGraphDown() {
        return altGraphDown;
    }

    public static final boolean isMetaDown() {
        return metaDown;
    }

    public static final boolean isDragging() {
        return dragging;
    }

    public static final boolean isButton1Down() {
        return button1Down;
    }

    public static final boolean isButton2Down() {
        return button2Down;
    }

    public static final boolean isButton3Down() {
        return button3Down;
    }

    static {
        InputInfo.initialize();
        controlDown = false;
        altDown = false;
        shiftDown = false;
        altGraphDown = false;
        metaDown = false;
        dragging = false;
        button1Down = false;
        button2Down = false;
        button3Down = false;
    }

    private static class Listener
    implements AWTEventListener {
        private Listener() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof KeyEvent) {
                KeyEvent ke = (KeyEvent)event;
                controlDown = ke.isControlDown();
                altDown = ke.isAltDown();
                altGraphDown = ke.isAltGraphDown();
                metaDown = ke.isMetaDown();
                shiftDown = ke.isShiftDown();
            }
            if (event instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)event;
                controlDown = me.isControlDown();
                altDown = me.isAltDown();
                altGraphDown = me.isAltGraphDown();
                metaDown = me.isMetaDown();
                shiftDown = me.isShiftDown();
                if (me.getID() == 506) {
                    dragging = true;
                } else if (me.getID() == 503) {
                    dragging = false;
                }
                if (me.getButton() == 1) {
                    if (me.getID() == 501) {
                        button1Down = true;
                    } else if (me.getID() == 502) {
                        button1Down = false;
                    }
                }
                if (me.getButton() == 2) {
                    if (me.getID() == 501) {
                        button2Down = true;
                    } else if (me.getID() == 502) {
                        button2Down = false;
                    }
                }
                if (me.getButton() == 3) {
                    if (me.getID() == 501) {
                        button3Down = true;
                    } else if (me.getID() == 502) {
                        button3Down = false;
                    }
                }
                if (!(button1Down || button2Down || button3Down)) {
                    dragging = false;
                }
            }
        }
    }
}

