/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.javatools.ui.Colors;

public final class ComponentWithHint<T extends Component>
extends JPanel {
    private static final int DEFAULT_VERTICAL_GAP = 4;
    private T _component;
    private final MultiLineLabel _hint = new MultiLineLabel();
    private final PropertyL _propertyL = new PropertyL();

    public ComponentWithHint() {
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this._hint, "South");
        this._hint.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this._hint.setForeground(Colors.HINT_TEXT);
        this._hint.setTextWrapper(WordWrapper.getTextWrapper());
    }

    public void setLeadingIndent(int width) {
        this._hint.setBorder(BorderFactory.createEmptyBorder(4, width, 0, 0));
    }

    public ComponentWithHint(T component, String hint) {
        this();
        this.setComponent(component);
        this.setHint(hint);
    }

    public void setComponent(T component) {
        if (this._component == component) {
            return;
        }
        T oldComponent = this._component;
        if (oldComponent != null) {
            this.remove((Component)oldComponent);
        }
        if (component != null) {
            this.add((Component)component, "Center");
        }
        if (oldComponent != null) {
            ((Component)oldComponent).removePropertyChangeListener(this._propertyL);
        }
        this._component = component;
        this.revalidate();
        this.invalidate();
        this.validate();
        this.firePropertyChange("component", oldComponent, component);
        this._hint.setEnabled(((Component)this._component).isEnabled());
        if (this._component != null) {
            ((Component)this._component).addPropertyChangeListener("enabled", this._propertyL);
        }
    }

    public T getComponent() {
        return this._component;
    }

    public void setHint(String hint) {
        String oldHint = this._hint.getText();
        if (!oldHint.equals(hint)) {
            this._hint.setVisible(hint != null);
            this._hint.setText(hint);
            this.invalidate();
            this.validate();
            this.firePropertyChange("hint", oldHint, hint);
        }
    }

    public String getHint() {
        return this._hint.getText();
    }

    private class PropertyL
    implements PropertyChangeListener {
        private PropertyL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ComponentWithHint.this._hint.setEnabled(ComponentWithHint.this._component.isEnabled());
        }
    }
}

