/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AttributedStringBuilder<K extends AttributedCharacterIterator.Attribute, V> {
    public static final AttributedString EMPTY_ATTRIBUTED_STRING = new AttributedString("");
    List<Run> runs = new ArrayList<Run>();

    public AttributedStringBuilder(String text) {
        this.append(text, null);
    }

    public AttributedStringBuilder(AttributedString attributedString) {
        this.append(attributedString);
    }

    public AttributedStringBuilder(String text, K attribute, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(attribute, value);
        this.append(text, map);
    }

    public AttributedStringBuilder(String text, Map<K, V> attributes) {
        this.append(text, attributes);
    }

    public void append(String text) {
        this.append(text, null);
    }

    public void append(AttributedString attributedString) {
        AttributedCharacterIterator it = attributedString.getIterator();
        StringBuilder runText = new StringBuilder();
        char c = it.current();
        for (int index = 0; index < it.getEndIndex() - 1 && c != '\uffff'; ++index) {
            runText.append(c);
            Map<AttributedCharacterIterator.Attribute, Object> runAtts = it.getAttributes();
            int runLimit = it.getRunLimit();
            while (index < runLimit && (c = it.next()) != '\uffff') {
                runText.append(c);
                ++index;
            }
            String text = runText.toString();
            Run run = new Run(text, runAtts);
            this.runs.add(run);
            c = it.next();
            runText = new StringBuilder();
        }
    }

    public void append(String text, K attribute, V value) {
        if (text == null || text.length() == 0) {
            return;
        }
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(attribute, value);
        this.append(text, map);
    }

    public void append(String text, Map<K, V> attributes) {
        if (text == null || text.length() == 0) {
            return;
        }
        Run run = new Run(text, attributes);
        this.runs.add(run);
    }

    public AttributedString toAttributedString() {
        StringBuilder sb = new StringBuilder();
        for (Run run : this.runs) {
            sb.append(run.text);
        }
        AttributedString as = new AttributedString(sb.toString());
        int i = 0;
        for (Run run : this.runs) {
            if (run.attributes != null) {
                as.addAttributes(run.attributes, i, i + run.text.length());
            }
            i += run.text.length();
        }
        return as;
    }

    public static String toString(AttributedString as) {
        AttributedCharacterIterator it = as.getIterator();
        StringBuilder sb = new StringBuilder(it.getEndIndex());
        char c = it.first();
        while (c != '\uffff') {
            sb.append(c);
            c = it.next();
        }
        return sb.toString();
    }

    public static char charAt(AttributedString as, int i) {
        AttributedCharacterIterator it = as.getIterator();
        char c = it.first();
        int j = 0;
        while (c != '\uffff') {
            if (j == i) {
                return c;
            }
            c = it.next();
            ++j;
        }
        throw new IndexOutOfBoundsException();
    }

    public void addAttribute(K key, V value) {
        for (Run run : this.runs) {
            run.attributes.put(key, value);
        }
    }

    private class Run {
        String text;
        Map<K, V> attributes;

        private Run(String text, Map<K, V> attributes) {
            this.text = text;
            this.attributes = attributes;
        }
    }
}

