/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemabrowser.model;

import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.schemabrowser.model.DatabaseNodeComparator;
import oracle.dbtools.raptor.schemabrowser.model.FilterableObject;
import oracle.ide.model.DefaultDisplayable;
import oracle.javatools.util.ModelUtil;

public final class SBType
extends DefaultDisplayable
implements Comparable<SBType>,
FilterableObject {
    private DBFolderInstance m_instance;
    private String m_name;
    private Icon m_icon;
    private URL m_url;
    private List<DatabaseNode> m_objects;

    public SBType(DBFolderInstance dBFolderInstance) {
        this.m_instance = dBFolderInstance;
        DatabaseFolder databaseFolder = (DatabaseFolder)this.m_instance.getDescriptor();
        this.m_name = databaseFolder.getLabel();
        this.m_icon = databaseFolder.getIcon();
    }

    public String getTypeName() {
        return this.m_instance.getType();
    }

    DBFolderInstance getFolder() {
        return this.m_instance;
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public String getShortLabel() {
        return this.m_name;
    }

    public URL getURL() {
        if (this.m_url == null) {
            String string = (String)this.m_instance.getProperty("ConnectionName");
            String string2 = (String)this.m_instance.getProperty("CATALOG");
            String string3 = (String)this.m_instance.getProperty("SCHEMA");
            String string4 = (String)this.m_instance.getProperty("TYPE");
            this.m_url = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string, (String)string2, (String)string3, (String)string4);
        }
        return this.m_url;
    }

    @Override
    public int compareTo(SBType sBType) {
        if (sBType == this) {
            return 0;
        }
        DatabaseFolder databaseFolder = (DatabaseFolder)this.m_instance.getDescriptor();
        DatabaseFolder databaseFolder2 = (DatabaseFolder)sBType.m_instance.getDescriptor();
        int n = Double.valueOf(databaseFolder.getWeight()).compareTo(databaseFolder2.getWeight());
        if (n == 0) {
            n = databaseFolder.getLabel().compareTo(databaseFolder2.getLabel());
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SBType) {
            SBType sBType = (SBType)object;
            return this.m_instance.equals(sBType.m_instance);
        }
        return false;
    }

    public int hashCode() {
        return this.m_instance.hashCode();
    }

    public List<DatabaseNode> getObjects() throws TaskException {
        if (this.m_objects == null) {
            this.m_objects = this.fetchObjects();
        }
        return this.m_objects;
    }

    @Override
    public boolean canHaveFilter() {
        return this.m_instance.canHaveFilter();
    }

    @Override
    public boolean isFiltered() {
        return this.m_instance.isFiltered();
    }

    @Override
    public void clearFilter() {
        this.m_instance.clearFilter();
    }

    @Override
    public boolean promptForFilter() {
        return this.m_instance.promptForFilter();
    }

    private List<DatabaseNode> fetchObjects() throws TaskException {
        ArrayList<DatabaseNode> arrayList = new ArrayList<DatabaseNode>();
        try {
            URL uRL = this.getURL();
            List list = this.m_instance.getChildren(null, false);
            for (DBObjectInstance dBObjectInstance : list) {
                DatabaseNode databaseNode = DatabaseNavigatorElementFactory.createObjectNode((URL)uRL, (DBObjectInstance)dBObjectInstance);
                arrayList.add(databaseNode);
            }
        }
        catch (SQLException sQLException) {
            throw new TaskException((Throwable)sQLException);
        }
        catch (AbortException abortException) {
            arrayList.clear();
        }
        Collections.sort(arrayList, DatabaseNodeComparator.getInstance());
        return arrayList;
    }

    void refresh() throws TaskException {
        if (this.m_objects != null) {
            this.m_objects.clear();
            this.m_objects.addAll(this.fetchObjects());
        }
    }

    public void removeObject(String string) {
        if (this.m_objects != null) {
            for (DatabaseNode databaseNode : this.m_objects) {
                String string2 = databaseNode.getObjectName();
                if (!ModelUtil.areEqual((Object)string2, (Object)string)) continue;
                this.m_objects.remove(databaseNode);
                break;
            }
        }
    }

    public void markForRefresh() {
        if (this.m_objects != null) {
            this.m_objects = null;
        }
    }

    boolean addObjects(String[] stringArray) throws TaskException {
        ArrayList<DatabaseNode> arrayList = new ArrayList<DatabaseNode>();
        try {
            URL uRL = this.getURL();
            List list = this.m_instance.getChildren(stringArray, false);
            for (DBObjectInstance dBObjectInstance : list) {
                DatabaseNode databaseNode = DatabaseNavigatorElementFactory.createObjectNode((URL)uRL, (DBObjectInstance)dBObjectInstance);
                arrayList.add(databaseNode);
            }
        }
        catch (SQLException sQLException) {
            throw new TaskException((Throwable)sQLException);
        }
        catch (AbortException abortException) {
            arrayList.clear();
        }
        boolean bl = false;
        if (arrayList.size() > 0) {
            this.m_objects.addAll(arrayList);
            Collections.sort(this.m_objects, DatabaseNodeComparator.getInstance());
            bl = true;
        }
        return bl;
    }
}

