/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.CommitItem;
import org.tigris.subversion.javahl.ConflictDescriptor;
import org.tigris.subversion.javahl.ConflictResult;
import org.tigris.subversion.javahl.ConflictVersion;
import org.tigris.subversion.javahl.CopySource;
import org.tigris.subversion.javahl.Depth;
import org.tigris.subversion.javahl.DiffSummary;
import org.tigris.subversion.javahl.DirEntry;
import org.tigris.subversion.javahl.Info;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.JavaHLPropertyData;
import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.LogMessage;
import org.tigris.subversion.javahl.LogMessageCallback;
import org.tigris.subversion.javahl.Mergeinfo;
import org.tigris.subversion.javahl.NotifyInformation;
import org.tigris.subversion.javahl.ProgressEvent;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.RevisionRange;
import org.tigris.subversion.javahl.SVNClient;
import org.tigris.subversion.javahl.Status;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.javahl.SVNClientImpl;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNConflictResult;
import org.tmatesoft.svn.core.wc.SVNDiffStatus;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNLogType;

public class JavaHLObjectFactory {
    private static final Map STATUS_CONVERSION_MAP = new SVNHashMap();
    private static final Map REVISION_KIND_CONVERSION_MAP = new SVNHashMap();
    private static final Map ACTION_CONVERSION_MAP = new SVNHashMap();
    private static final Map LOCK_CONVERSION_MAP = new SVNHashMap();
    private static final Map CONFLICT_REASON_CONVERSATION_MAP = new SVNHashMap();
    private static final Comparator CHANGE_PATH_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            ChangePath cp1 = (ChangePath)o1;
            ChangePath cp2 = (ChangePath)o2;
            return SVNPathUtil.PATH_COMPARATOR.compare(cp1.getPath(), cp2.getPath());
        }
    };

    public static Collection getChangeListsCollection(String[] changelists) {
        if (changelists != null) {
            return Arrays.asList(changelists);
        }
        return null;
    }

    public static Status createStatus(String path, SVNStatus status) {
        SVNTreeConflictDescription tc;
        String url;
        if (status == null) {
            return null;
        }
        String string = url = status.getURL() != null ? status.getURL().toString() : null;
        if (url == null && status.getEntryProperties() != null) {
            url = (String)status.getEntryProperties().get("svn:entry:url");
        }
        if (url == null && status.getRemoteURL() != null) {
            url = status.getRemoteURL().toString();
        }
        int nodeKind = JavaHLObjectFactory.getNodeKind(status.getKind());
        if (status.getContentsStatus() == SVNStatusType.STATUS_IGNORED) {
            nodeKind = 3;
        }
        long revision = status.getRevision().getNumber();
        long lastChangedRevision = -1L;
        if (status.getCommittedRevision() != null) {
            lastChangedRevision = status.getCommittedRevision().getNumber();
        }
        Date d = status.getCommittedDate();
        long lastChangedDate = -1L;
        if (d != null) {
            lastChangedDate = d.getTime() * 1000L;
        }
        String lastCommitAuthor = status.getAuthor();
        int textStatus = JavaHLObjectFactory.getStatusValue(status.getContentsStatus());
        int propStatus = JavaHLObjectFactory.getStatusValue(status.getPropertiesStatus());
        int repositoryTextStatus = JavaHLObjectFactory.getStatusValue(status.getRemoteContentsStatus());
        int repositoryPropStatus = JavaHLObjectFactory.getStatusValue(status.getRemotePropertiesStatus());
        boolean locked = status.isLocked();
        boolean copied = status.isCopied();
        boolean switched = status.isSwitched();
        String conflictOld = null;
        if (status.getConflictOldFile() != null) {
            conflictOld = status.getConflictOldFile().getName();
        }
        String conflictNew = null;
        if (status.getConflictNewFile() != null) {
            conflictNew = status.getConflictNewFile().getName();
        }
        String conflictWorking = null;
        if (status.getConflictWrkFile() != null) {
            conflictWorking = status.getConflictWrkFile().getName();
        }
        String urlCopiedFrom = status.getCopyFromURL();
        long revisionCopiedFrom = status.getCopyFromRevision().getNumber();
        String lockToken = null;
        String lockOwner = null;
        String lockComment = null;
        long lockCreationDate = 0L;
        if (status.getLocalLock() != null) {
            lockToken = status.getLocalLock().getID();
            lockOwner = status.getLocalLock().getOwner();
            lockComment = status.getLocalLock().getComment();
            lockCreationDate = status.getLocalLock().getCreationDate().getTime() * 1000L;
        }
        Lock reposLock = JavaHLObjectFactory.createLock(status.getRemoteLock());
        if (path != null) {
            path = path.replace(File.separatorChar, '/');
        }
        long reposRev = status.getRemoteRevision() != null && status.getRemoteRevision() != SVNRevision.UNDEFINED ? status.getRemoteRevision().getNumber() : -1L;
        long reposDate = status.getRemoteDate() != null ? status.getRemoteDate().getTime() * 1000L : -1L;
        String reposAuthor = status.getRemoteAuthor();
        int reposKind = JavaHLObjectFactory.getNodeKind(status.getRemoteKind());
        if (status.getRemoteKind() == null) {
            reposKind = 0;
        }
        Status st = new Status(path, url, nodeKind, revision, lastChangedRevision, lastChangedDate, lastCommitAuthor, textStatus, propStatus, repositoryTextStatus, repositoryPropStatus, locked, copied, (tc = status.getTreeConflict()) != null, JavaHLObjectFactory.createConflictDescription((SVNConflictDescription)tc), conflictOld, conflictNew, conflictWorking, urlCopiedFrom, revisionCopiedFrom, switched, false, lockToken, lockOwner, lockComment, lockCreationDate, reposLock, reposRev, reposDate, reposKind, reposAuthor, status.getChangelistName());
        return st;
    }

    public static SVNRevision getSVNRevision(Revision r) {
        if (r == null) {
            return SVNRevision.UNDEFINED;
        }
        if (r.getKind() == 1) {
            return SVNRevision.create((long)((Revision.Number)r).getNumber());
        }
        if (r.getKind() == 2) {
            return SVNRevision.create((Date)((Revision.DateSpec)r).getDate());
        }
        return (SVNRevision)REVISION_KIND_CONVERSION_MAP.get(r.getKind());
    }

    public static SVNDepth getSVNDepth(int depth) {
        switch (depth) {
            case 0: {
                return SVNDepth.EMPTY;
            }
            case -1: {
                return SVNDepth.EXCLUDE;
            }
            case 1: {
                return SVNDepth.FILES;
            }
            case 2: {
                return SVNDepth.IMMEDIATES;
            }
            case 3: {
                return SVNDepth.INFINITY;
            }
        }
        return SVNDepth.UNKNOWN;
    }

    public static ConflictDescriptor createConflictDescription(SVNConflictDescription conflictDescription) {
        if (conflictDescription == null) {
            return null;
        }
        SVNMergeFileSet mergeFiles = conflictDescription.getMergeFiles();
        String basePath = null;
        String repositoryPath = null;
        try {
            basePath = mergeFiles.getBasePath();
            repositoryPath = mergeFiles.getRepositoryPath();
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        ConflictVersion left = null;
        ConflictVersion right = null;
        int op = 0;
        if (conflictDescription.isTreeConflict()) {
            SVNTreeConflictDescription tc = (SVNTreeConflictDescription)conflictDescription;
            left = JavaHLObjectFactory.createConflictVersion(tc.getSourceLeftVersion());
            right = JavaHLObjectFactory.createConflictVersion(tc.getSourceRightVersion());
            op = JavaHLObjectFactory.getConflictOperation(tc.getOperation());
        }
        return new ConflictDescriptor(mergeFiles.getWCPath(), JavaHLObjectFactory.getConflictKind(conflictDescription.isPropertyConflict()), JavaHLObjectFactory.getNodeKind(conflictDescription.getNodeKind()), conflictDescription.getPropertyName(), mergeFiles.isBinary(), mergeFiles.getMimeType(), JavaHLObjectFactory.getConflictAction(conflictDescription.getConflictAction()), JavaHLObjectFactory.getConflictReason(conflictDescription.getConflictReason()), op, basePath, repositoryPath, mergeFiles.getWCPath(), mergeFiles.getResultPath(), left, right);
    }

    private static int getConflictOperation(SVNOperation operation) {
        if (operation == SVNOperation.MERGE) {
            return 3;
        }
        if (operation == SVNOperation.NONE) {
            return 0;
        }
        if (operation == SVNOperation.UPDATE) {
            return 1;
        }
        if (operation == SVNOperation.SWITCH) {
            return 2;
        }
        return 0;
    }

    private static ConflictVersion createConflictVersion(SVNConflictVersion version) {
        if (version == null) {
            return null;
        }
        String url = version.getRepositoryRoot() != null ? version.getRepositoryRoot().toString() : null;
        return new ConflictVersion(url, version.getPegRevision(), version.getPath(), JavaHLObjectFactory.getNodeKind(version.getKind()));
    }

    public static SVNConflictResult getSVNConflictResult(ConflictResult conflictResult) {
        if (conflictResult == null) {
            return null;
        }
        return new SVNConflictResult(JavaHLObjectFactory.getSVNConflictChoice(conflictResult.getChoice()), conflictResult.getMergedPath() != null ? new File(conflictResult.getMergedPath()).getAbsoluteFile() : null);
    }

    public static int getConflictAction(SVNConflictAction conflictAction) {
        if (conflictAction == SVNConflictAction.ADD) {
            return 1;
        }
        if (conflictAction == SVNConflictAction.DELETE) {
            return 2;
        }
        if (conflictAction == SVNConflictAction.EDIT) {
            return 0;
        }
        return -1;
    }

    public static SVNConflictChoice getSVNConflictChoice(int conflictResult) {
        switch (conflictResult) {
            case 1: {
                return SVNConflictChoice.BASE;
            }
            case 6: {
                return SVNConflictChoice.MERGED;
            }
            case 5: {
                return SVNConflictChoice.MINE_CONFLICT;
            }
            case 3: {
                return SVNConflictChoice.MINE_FULL;
            }
            case 4: {
                return SVNConflictChoice.THEIRS_CONFLICT;
            }
            case 2: {
                return SVNConflictChoice.THEIRS_FULL;
            }
            case 0: {
                return SVNConflictChoice.POSTPONE;
            }
        }
        return null;
    }

    public static int getConflictReason(SVNConflictReason conflictReason) {
        Object reason = CONFLICT_REASON_CONVERSATION_MAP.get(conflictReason);
        if (reason != null) {
            return (Integer)reason;
        }
        return -1;
    }

    public static int getConflictKind(boolean isPropertyConflict) {
        return isPropertyConflict ? 1 : 0;
    }

    public static DiffSummary createDiffSummary(SVNDiffStatus status) {
        int diffStatus = -1;
        if (status.getModificationType() == SVNStatusType.STATUS_NORMAL || status.getModificationType() == SVNStatusType.STATUS_NONE) {
            diffStatus = 0;
        } else if (status.getModificationType() == SVNStatusType.STATUS_ADDED) {
            diffStatus = 1;
        } else if (status.getModificationType() == SVNStatusType.STATUS_MODIFIED) {
            diffStatus = 2;
        } else if (status.getModificationType() == SVNStatusType.STATUS_DELETED) {
            diffStatus = 3;
        }
        return new DiffSummary(status.getPath(), diffStatus, status.isPropertiesModified(), JavaHLObjectFactory.getNodeKind(status.getKind()));
    }

    public static int getNodeKind(SVNNodeKind svnKind) {
        if (svnKind == SVNNodeKind.DIR) {
            return 2;
        }
        if (svnKind == SVNNodeKind.NONE) {
            return 0;
        }
        if (svnKind == SVNNodeKind.FILE) {
            return 1;
        }
        return 3;
    }

    public static int getStatusValue(SVNStatusType svnStatusType) {
        Object status = STATUS_CONVERSION_MAP.get(svnStatusType);
        if (status == null) {
            return -1;
        }
        return (Integer)status;
    }

    public static int getLockStatusValue(SVNStatusType svnStatusType) {
        Object status = LOCK_CONVERSION_MAP.get(svnStatusType);
        if (status == null) {
            return -1;
        }
        return (Integer)status;
    }

    public static int getNotifyActionValue(SVNEventAction action) {
        Object status = ACTION_CONVERSION_MAP.get(action);
        if (status == null) {
            return -1;
        }
        return (Integer)status;
    }

    public static DirEntry createDirEntry(SVNDirEntry dirEntry) {
        if (dirEntry == null) {
            return null;
        }
        SVNURL url = dirEntry.getURL();
        SVNURL repositoryRoot = dirEntry.getRepositoryRoot();
        String relativeToRepositoryRoot = SVNPathUtil.getRelativePath((String)repositoryRoot.getPath(), (String)url.getPath());
        String relativeToTargetPath = dirEntry.getRelativePath();
        String targetToRootPath = relativeToRepositoryRoot.substring(0, relativeToRepositoryRoot.length() - relativeToTargetPath.length());
        return new DirEntry(relativeToTargetPath, SVNPathUtil.getAbsolutePath((String)targetToRootPath), JavaHLObjectFactory.getNodeKind(dirEntry.getKind()), dirEntry.getSize(), dirEntry.hasProperties(), dirEntry.getRevision(), dirEntry.getDate() != null ? dirEntry.getDate().getTime() * 1000L : 0L, dirEntry.getAuthor());
    }

    public static LogMessage createLogMessage(SVNLogEntry logEntry) {
        if (logEntry == null) {
            return null;
        }
        Map cpaths = logEntry.getChangedPaths();
        ChangePath[] cp = null;
        if (cpaths == null) {
            cp = new ChangePath[]{};
        } else {
            ArrayList<ChangePath> clientChangePaths = new ArrayList<ChangePath>();
            for (String path : cpaths.keySet()) {
                SVNLogEntryPath entryPath = (SVNLogEntryPath)cpaths.get(path);
                if (entryPath == null) continue;
                clientChangePaths.add(new ChangePath(path, entryPath.getCopyRevision(), entryPath.getCopyPath(), entryPath.getType(), JavaHLObjectFactory.getNodeKind(entryPath.getKind())));
            }
            cp = clientChangePaths.toArray(new ChangePath[clientChangePaths.size()]);
            Arrays.sort(cp, CHANGE_PATH_COMPARATOR);
        }
        long time = 0L;
        if (logEntry.getDate() != null) {
            time = logEntry.getDate().getTime() * 1000L;
            if (logEntry.getDate() instanceof SVNDate) {
                time = ((SVNDate)logEntry.getDate()).getTimeInMicros();
            }
        }
        return new LogMessage(cp, logEntry.getRevision(), logEntry.getAuthor(), time, logEntry.getMessage());
    }

    public static Mergeinfo createMergeInfo(Map mergeInfo) {
        if (mergeInfo == null) {
            return null;
        }
        Mergeinfo result = new Mergeinfo();
        for (Map.Entry entry : mergeInfo.entrySet()) {
            SVNURL mergeSrcURL = (SVNURL)entry.getKey();
            String url = mergeSrcURL.toString();
            SVNMergeRangeList rangeList = (SVNMergeRangeList)entry.getValue();
            SVNMergeRange[] ranges = rangeList.getRanges();
            for (int i = 0; i < ranges.length; ++i) {
                SVNMergeRange range = ranges[i];
                result.addRevisionRange(url, JavaHLObjectFactory.createRevisionRange(range));
            }
        }
        return result;
    }

    public static RevisionRange createRevisionRange(SVNMergeRange range) {
        if (range == null) {
            return null;
        }
        return new RevisionRange(new Revision.Number(range.getStartRevision()), new Revision.Number(range.getEndRevision()));
    }

    public static RevisionRange[] createRevisionRanges(SVNMergeRangeList rangeList) {
        if (rangeList == null) {
            return null;
        }
        SVNMergeRange[] ranges = rangeList.getRanges();
        RevisionRange[] result = new RevisionRange[ranges.length];
        for (int i = 0; i < ranges.length; ++i) {
            result[i] = JavaHLObjectFactory.createRevisionRange(ranges[i]);
        }
        return result;
    }

    public static SVNRevisionRange getSVNRevisionRange(RevisionRange revisionRange) {
        return new SVNRevisionRange(JavaHLObjectFactory.getSVNRevision(revisionRange.getFromRevision()), JavaHLObjectFactory.getSVNRevision(revisionRange.getToRevision()));
    }

    public static void handleLogMessage(SVNLogEntry logEntry, LogMessageCallback handler) {
        if (logEntry == null || handler == null) {
            return;
        }
        Map cpaths = logEntry.getChangedPaths();
        ChangePath[] cp = null;
        if (cpaths == null) {
            cp = new ChangePath[]{};
        } else {
            ArrayList<ChangePath> clientChangePaths = new ArrayList<ChangePath>();
            for (String path : cpaths.keySet()) {
                SVNLogEntryPath entryPath = (SVNLogEntryPath)cpaths.get(path);
                if (entryPath == null) continue;
                clientChangePaths.add(new ChangePath(path, entryPath.getCopyRevision(), entryPath.getCopyPath(), entryPath.getType(), JavaHLObjectFactory.getNodeKind(entryPath.getKind())));
            }
            cp = clientChangePaths.toArray(new ChangePath[clientChangePaths.size()]);
        }
        SVNProperties revisionProperties = logEntry.getRevisionProperties();
        HashMap<String, String> revisionPropertiesMap = new HashMap<String, String>();
        for (String name : revisionProperties.nameSet()) {
            revisionPropertiesMap.put(name, revisionProperties.getStringValue(name));
        }
        handler.singleMessage(cp, logEntry.getRevision(), revisionPropertiesMap, logEntry.hasChildren());
    }

    public static CommitItem[] getCommitItems(SVNCommitItem[] commitables, boolean isImport, boolean isURLsOnly) {
        if (commitables == null) {
            return null;
        }
        CommitItem[] items = new CommitItem[commitables.length];
        for (int i = 0; i < items.length; ++i) {
            String path;
            String url;
            SVNCommitItem sc = commitables[i];
            if (sc == null) {
                items[i] = null;
                continue;
            }
            int stateFlag = 0;
            if (sc.isDeleted()) {
                stateFlag += 2;
            }
            if (sc.isAdded()) {
                ++stateFlag;
            }
            if (sc.isContentsModified()) {
                stateFlag += 4;
            }
            if (sc.isPropertiesModified()) {
                stateFlag += 8;
            }
            if (sc.isCopied()) {
                stateFlag += 16;
            }
            String string = url = sc.getURL() != null ? sc.getURL().toString() : null;
            String string2 = isURLsOnly ? null : (path = sc.getFile() != null ? sc.getFile().getAbsolutePath() : null);
            if (path != null) {
                path = path.replace(File.separatorChar, '/');
            }
            if (path != null && isImport) {
                url = null;
            }
            int kind = isImport ? 0 : JavaHLObjectFactory.getNodeKind(sc.getKind());
            items[i] = new CommitItem(path, kind, stateFlag, url, sc.getCopyFromURL() != null ? sc.getCopyFromURL().toString() : null, sc.getRevision().getNumber());
        }
        return items;
    }

    public static Lock createLock(SVNLock svnLock) {
        if (svnLock == null) {
            return null;
        }
        return new Lock(svnLock.getOwner(), svnLock.getPath(), svnLock.getID(), svnLock.getComment(), svnLock.getCreationDate() != null ? svnLock.getCreationDate().getTime() * 1000L : 0L, svnLock.getExpirationDate() != null ? svnLock.getExpirationDate().getTime() * 1000L : 0L);
    }

    public static Info createInfo(SVNInfo info) {
        String path;
        if (info == null) {
            return null;
        }
        int schedule = 0;
        if ("add".equals(info.getSchedule())) {
            schedule = 1;
        } else if ("delete".equals(info.getSchedule())) {
            schedule = 2;
        }
        File file = info.getFile();
        boolean deleted = file != null && !file.exists() && schedule == 2;
        boolean absent = file != null && !deleted && !file.exists();
        boolean incomplete = false;
        long copyRev = info.getCopyFromRevision() != null ? info.getCopyFromRevision().getNumber() : -1L;
        String copyUrl = info.getCopyFromURL() != null ? info.getCopyFromURL().toString() : null;
        String string = path = info.getFile() != null ? info.getFile().getName() : SVNPathUtil.tail((String)info.getPath());
        if (path != null) {
            path = path.replace(File.separatorChar, '/');
        }
        return new Info(path, info.getURL() != null ? info.getURL().toString() : null, info.getRepositoryUUID(), info.getRepositoryRootURL() != null ? info.getRepositoryRootURL().toString() : null, schedule, JavaHLObjectFactory.getNodeKind(info.getKind()), info.getAuthor(), info.getRevision() != null ? info.getRevision().getNumber() : -1L, info.getCommittedRevision() != null ? info.getCommittedRevision().getNumber() : -1L, info.getCommittedDate(), info.getTextTime(), info.getPropTime(), info.getCopyFromRevision() != null || info.getCopyFromURL() != null, deleted, absent, incomplete, copyRev, copyUrl);
    }

    public static Info2 createInfo2(SVNInfo info) {
        int depth;
        String path;
        if (info == null) {
            return null;
        }
        int schedule = 0;
        if ("add".equals(info.getSchedule())) {
            schedule = 1;
        } else if ("delete".equals(info.getSchedule())) {
            schedule = 2;
        }
        long copyRev = info.getCopyFromRevision() != null ? info.getCopyFromRevision().getNumber() : -1L;
        String copyUrl = info.getCopyFromURL() != null ? info.getCopyFromURL().toString() : null;
        String string = path = info.getFile() != null ? info.getFile().getAbsolutePath() : info.getPath();
        if (path != null) {
            path = path.replace(File.separatorChar, '/');
        }
        int n = depth = info.getDepth() != null ? info.getDepth().getId() : -2;
        if (info.getKind() == SVNNodeKind.FILE) {
            depth = 0;
        }
        return new Info2(path, info.getURL() != null ? info.getURL().toString() : null, info.getRevision() != null ? info.getRevision().getNumber() : -1L, JavaHLObjectFactory.getNodeKind(info.getKind()), info.getRepositoryRootURL() != null ? info.getRepositoryRootURL().toString() : null, info.getRepositoryUUID(), info.getCommittedRevision() != null ? info.getCommittedRevision().getNumber() : -1L, info.getCommittedDate() != null ? info.getCommittedDate().getTime() * 1000L : 0L, info.getAuthor(), JavaHLObjectFactory.createLock(info.getLock()), !info.isRemote(), schedule, copyUrl, copyRev, info.getTextTime() != null ? info.getTextTime().getTime() * 1000L : 0L, info.getPropTime() != null ? info.getPropTime().getTime() * 1000L : 0L, info.getChecksum(), info.getConflictOldFile() != null ? info.getConflictOldFile().getName() : null, info.getConflictNewFile() != null ? info.getConflictNewFile().getName() : null, info.getConflictWrkFile() != null ? info.getConflictWrkFile().getName() : null, info.getPropConflictFile() != null ? info.getPropConflictFile().getName() : null, info.getChangelistName(), info.getWorkingSize(), info.getRepositorySize(), depth, JavaHLObjectFactory.createConflictDescription((SVNConflictDescription)info.getTreeConflict()));
    }

    public static ProgressEvent createProgressEvent(long onProgress, long total) {
        return new ProgressEvent(onProgress, total);
    }

    public static PropertyData createPropertyData(Object client, String path, String name, SVNPropertyValue value) {
        if (client instanceof SVNClientImpl) {
            if (value.isString()) {
                return new JavaHLPropertyData((SVNClientImpl)client, null, path, name, value.getString(), SVNPropertyValue.getPropertyAsBytes((SVNPropertyValue)value));
            }
            return new JavaHLPropertyData((SVNClientImpl)client, null, path, name, SVNPropertyValue.getPropertyAsString((SVNPropertyValue)value), value.getBytes());
        }
        if (value.isString()) {
            return new PropertyData((SVNClient)client, path, name, value.getString(), SVNPropertyValue.getPropertyAsBytes((SVNPropertyValue)value));
        }
        return new PropertyData((SVNClient)client, path, name, SVNPropertyValue.getPropertyAsString((SVNPropertyValue)value), value.getBytes());
    }

    public static NotifyInformation createNotifyInformation(SVNEvent event, String path) {
        int actionId = JavaHLObjectFactory.getNotifyActionValue(event.getAction());
        if (actionId == -1) {
            return null;
        }
        String errMsg = null;
        if (event.getErrorMessage() != null) {
            errMsg = event.getErrorMessage().getFullMessage();
        }
        return new NotifyInformation(path, actionId, JavaHLObjectFactory.getNodeKind(event.getNodeKind()), event.getMimeType(), JavaHLObjectFactory.createLock(event.getLock()), errMsg, JavaHLObjectFactory.getStatusValue(event.getContentsStatus()), JavaHLObjectFactory.getStatusValue(event.getPropertiesStatus()), JavaHLObjectFactory.getLockStatusValue(event.getLockStatus()), event.getRevision(), event.getChangelistName(), JavaHLObjectFactory.createRevisionRange(event.getMergeRange()), "");
    }

    public static CopySource createCopySource(SVNLocationEntry location) {
        return new CopySource(location.getPath(), Revision.getInstance(location.getRevision()), null);
    }

    public static Level getLoggingLevel(int level) {
        if (level == 0) {
            return Level.OFF;
        }
        if (level == 1) {
            return Level.SEVERE;
        }
        if (level == 2) {
            return Level.FINE;
        }
        if (level == 3) {
            return Level.FINEST;
        }
        return Level.OFF;
    }

    public static void throwException(SVNException e, SVNClientImpl svnClient) throws ClientException {
        int code = 0;
        if (e.getErrorMessage() != null) {
            code = e.getErrorMessage().getErrorCode().getCode();
        }
        ClientException ec = new ClientException(e.getMessage(), null, code);
        ec.initCause(e);
        svnClient.getDebugLog().logFine(SVNLogType.DEFAULT, (Throwable)ec);
        svnClient.getDebugLog().logFine(SVNLogType.DEFAULT, (Throwable)e);
        throw ec;
    }

    public static final int infinityOrEmpty(boolean recurse) {
        return Depth.infinityOrEmpty(recurse);
    }

    public static final int infinityOrFiles(boolean recurse) {
        return Depth.infinityOrFiles(recurse);
    }

    public static final int infinityOrImmediates(boolean recurse) {
        return Depth.infinityOrImmediates(recurse);
    }

    public static final int unknownOrFiles(boolean recurse) {
        return Depth.unknownOrFiles(recurse);
    }

    public static final int unknownOrImmediates(boolean recurse) {
        return Depth.unknownOrImmediates(recurse);
    }

    static {
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_ADDED, 3);
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_CONFLICTED, 9);
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_DELETED, 4);
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_EXTERNAL, 13);
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_IGNORED, 11);
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_INCOMPLETE, 12);
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_MISSING, 6);
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_MODIFIED, 2);
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_NONE, 0);
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_NORMAL, 1);
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_OBSTRUCTED, 10);
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_REPLACED, 7);
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_UNVERSIONED, 5);
        STATUS_CONVERSION_MAP.put(SVNStatusType.STATUS_NAME_CONFLICT, 5);
        STATUS_CONVERSION_MAP.put(SVNStatusType.CHANGED, 5);
        STATUS_CONVERSION_MAP.put(SVNStatusType.CONFLICTED, 7);
        STATUS_CONVERSION_MAP.put(SVNStatusType.INAPPLICABLE, 0);
        STATUS_CONVERSION_MAP.put(SVNStatusType.MERGED, 6);
        STATUS_CONVERSION_MAP.put(SVNStatusType.MISSING, 3);
        STATUS_CONVERSION_MAP.put(SVNStatusType.OBSTRUCTED, 4);
        STATUS_CONVERSION_MAP.put(SVNStatusType.UNCHANGED, 2);
        STATUS_CONVERSION_MAP.put(SVNStatusType.UNKNOWN, 1);
        LOCK_CONVERSION_MAP.put(SVNStatusType.LOCK_INAPPLICABLE, 0);
        LOCK_CONVERSION_MAP.put(SVNStatusType.LOCK_LOCKED, 3);
        LOCK_CONVERSION_MAP.put(SVNStatusType.LOCK_UNCHANGED, 2);
        LOCK_CONVERSION_MAP.put(SVNStatusType.LOCK_UNKNOWN, 1);
        LOCK_CONVERSION_MAP.put(SVNStatusType.LOCK_UNLOCKED, 4);
        REVISION_KIND_CONVERSION_MAP.put(5, SVNRevision.BASE);
        REVISION_KIND_CONVERSION_MAP.put(3, SVNRevision.COMMITTED);
        REVISION_KIND_CONVERSION_MAP.put(7, SVNRevision.HEAD);
        REVISION_KIND_CONVERSION_MAP.put(4, SVNRevision.PREVIOUS);
        REVISION_KIND_CONVERSION_MAP.put(0, SVNRevision.UNDEFINED);
        REVISION_KIND_CONVERSION_MAP.put(6, SVNRevision.WORKING);
        ACTION_CONVERSION_MAP.put(SVNEventAction.ADD, 0);
        ACTION_CONVERSION_MAP.put(SVNEventAction.ANNOTATE, 20);
        ACTION_CONVERSION_MAP.put(SVNEventAction.COMMIT_ADDED, 16);
        ACTION_CONVERSION_MAP.put(SVNEventAction.COMMIT_DELETED, 17);
        ACTION_CONVERSION_MAP.put(SVNEventAction.COMMIT_DELTA_SENT, 19);
        ACTION_CONVERSION_MAP.put(SVNEventAction.COMMIT_MODIFIED, 15);
        ACTION_CONVERSION_MAP.put(SVNEventAction.COMMIT_REPLACED, 18);
        ACTION_CONVERSION_MAP.put(SVNEventAction.COPY, 1);
        ACTION_CONVERSION_MAP.put(SVNEventAction.DELETE, 2);
        ACTION_CONVERSION_MAP.put(SVNEventAction.FAILED_REVERT, 5);
        ACTION_CONVERSION_MAP.put(SVNEventAction.LOCK_FAILED, 23);
        ACTION_CONVERSION_MAP.put(SVNEventAction.LOCKED, 21);
        ACTION_CONVERSION_MAP.put(SVNEventAction.RESOLVED, 6);
        ACTION_CONVERSION_MAP.put(SVNEventAction.RESTORE, 3);
        ACTION_CONVERSION_MAP.put(SVNEventAction.REVERT, 4);
        ACTION_CONVERSION_MAP.put(SVNEventAction.SKIP, 7);
        ACTION_CONVERSION_MAP.put(SVNEventAction.STATUS_COMPLETED, 13);
        ACTION_CONVERSION_MAP.put(SVNEventAction.STATUS_EXTERNAL, 14);
        ACTION_CONVERSION_MAP.put(SVNEventAction.UNLOCK_FAILED, 24);
        ACTION_CONVERSION_MAP.put(SVNEventAction.UNLOCKED, 22);
        ACTION_CONVERSION_MAP.put(SVNEventAction.UPDATE_ADD, 9);
        ACTION_CONVERSION_MAP.put(SVNEventAction.UPDATE_COMPLETED, 11);
        ACTION_CONVERSION_MAP.put(SVNEventAction.UPDATE_DELETE, 8);
        ACTION_CONVERSION_MAP.put(SVNEventAction.UPDATE_EXTERNAL, 12);
        ACTION_CONVERSION_MAP.put(SVNEventAction.UPDATE_UPDATE, 10);
        ACTION_CONVERSION_MAP.put(SVNEventAction.UPDATE_NONE, 10);
        ACTION_CONVERSION_MAP.put(SVNEventAction.UPDATE_EXISTS, 25);
        ACTION_CONVERSION_MAP.put(SVNEventAction.UPDATE_REPLACE, 30);
        ACTION_CONVERSION_MAP.put(SVNEventAction.CHANGELIST_SET, 26);
        ACTION_CONVERSION_MAP.put(SVNEventAction.CHANGELIST_CLEAR, 27);
        ACTION_CONVERSION_MAP.put(SVNEventAction.MERGE_BEGIN, 28);
        ACTION_CONVERSION_MAP.put(SVNEventAction.FOREIGN_MERGE_BEGIN, 29);
        ACTION_CONVERSION_MAP.put(SVNEventAction.PROPERTY_ADD, 31);
        ACTION_CONVERSION_MAP.put(SVNEventAction.PROPERTY_MODIFY, 32);
        ACTION_CONVERSION_MAP.put(SVNEventAction.PROPERTY_DELETE, 33);
        ACTION_CONVERSION_MAP.put(SVNEventAction.PROPERTY_DELETE_NONEXISTENT, 34);
        ACTION_CONVERSION_MAP.put(SVNEventAction.REVPROPER_SET, 35);
        ACTION_CONVERSION_MAP.put(SVNEventAction.REVPROP_DELETE, 36);
        ACTION_CONVERSION_MAP.put(SVNEventAction.MERGE_COMPLETE, 37);
        ACTION_CONVERSION_MAP.put(SVNEventAction.TREE_CONFLICT, 38);
        ACTION_CONVERSION_MAP.put(SVNEventAction.COMMIT_COMPLETED, -11);
        CONFLICT_REASON_CONVERSATION_MAP.put(SVNConflictReason.ADDED, 5);
        CONFLICT_REASON_CONVERSATION_MAP.put(SVNConflictReason.DELETED, 2);
        CONFLICT_REASON_CONVERSATION_MAP.put(SVNConflictReason.EDITED, 0);
        CONFLICT_REASON_CONVERSATION_MAP.put(SVNConflictReason.MISSING, 3);
        CONFLICT_REASON_CONVERSATION_MAP.put(SVNConflictReason.OBSTRUCTED, 1);
        CONFLICT_REASON_CONVERSATION_MAP.put(SVNConflictReason.UNVERSIONED, 4);
    }
}

